/*
 * Decompiled with CFR 0.152.
 */
package coins.backend;

import coins.backend.IntervalTimer;
import coins.backend.Transformer;
import coins.backend.util.BiList;
import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.Trace;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Root {
    private static final String CONTRIBDIR = "coins.backend.contrib";
    public final PrintWriter debOut;
    public final boolean sourceDebugInfo;
    public final boolean optLoopInversion;
    public final boolean liveRangeSplitting;
    public final boolean dispIntervalTime;
    public final boolean GCflush;
    public final IntervalTimer timer;
    public final CompileSpecification spec;
    public final Trace trace;
    public final boolean javaCG;
    public final String additionalPass;
    private Map hookTable = new HashMap();
    private CoinsOptions opts;
    private PrintWriter asmWriter;
    private Object simulationData;

    public static void init(CompileSpecification spec) {
    }

    public Root(CompileSpecification spec, PrintWriter debOut, OutputStream asmOut) {
        this(spec, debOut);
        this.setAsmStream(asmOut);
    }

    public Root(CompileSpecification spec, PrintWriter debOut) {
        this.spec = spec;
        this.debOut = debOut;
        this.trace = spec.getTrace();
        this.dispIntervalTime = this.trace.shouldTrace("backtime");
        this.GCflush = this.trace.shouldTrace("backgc");
        this.opts = spec.getCoinsOptions();
        this.optLoopInversion = this.opts.isSet("loopinversion");
        this.sourceDebugInfo = this.opts.isSet("debuginfo");
        this.liveRangeSplitting = this.opts.isSet("liverangesplit");
        this.additionalPass = this.opts.getArg("lirpass");
        this.javaCG = !this.opts.isSet("schemecg");
        this.timer = new IntervalTimer();
        String plugins = spec.getCoinsOptions().getArg("attach");
        while (plugins != null) {
            this.attach(Root.getSlashedWord(plugins));
            plugins = Root.nextSlash(plugins);
        }
    }

    public boolean isOptionSet(String optionName) {
        return this.opts.isSet(optionName);
    }

    public void attach(String className) {
        if (className.indexOf(46) < 0) {
            className = "coins.backend.contrib." + className;
        }
        try {
            Class<?> custom = Class.forName(className);
            Method m = custom.getDeclaredMethod("attach", Class.forName("coins.driver.CompileSpecification"), Class.forName("coins.backend.Root"));
            m.invoke(null, this.spec, this);
        }
        catch (ClassNotFoundException e) {
            throw new Error("Class not found: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new Error("No such method: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new Error("Security Exception: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new Error("Illegal Access Exception: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new Error("Illegal Argument Exception: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new Error("Invocation Target Exception: " + e.getMessage());
        }
    }

    public void setAsmStream(OutputStream stream) {
        this.asmWriter = new PrintWriter(stream);
    }

    public PrintWriter asmWriter() {
        return this.asmWriter;
    }

    public void setSimulationData(Object data) {
        this.simulationData = data;
    }

    public Object simulationData() {
        return this.simulationData;
    }

    public boolean traceOK(String tag, int thresh) {
        int level = this.trace.getTraceLevel(tag);
        return level >= thresh;
    }

    public void registerTransformer(Transformer trans) {
        if (trans != null) {
            this.setHook(trans.name(), trans);
        }
    }

    public void setHook(String name, Object val) {
        this.hookTable.put(name, val);
    }

    public void addHook(String name, Object val) {
        BiList list = (BiList)this.hookTable.get(name);
        if (list == null) {
            list = new BiList();
            this.hookTable.put(name, list);
        }
        list.add(val);
    }

    public Object getHook(String name) {
        return this.hookTable.get(name);
    }

    private static String getSlashedWord(String s) {
        int n = s.indexOf(47);
        if (n < 0) {
            return s;
        }
        return s.substring(0, n);
    }

    private static String nextSlash(String s) {
        int n = s.indexOf(47);
        if (n < 0 || n + 1 == s.length()) {
            return null;
        }
        return s.substring(n + 1);
    }
}

