/*
 * Decompiled with CFR 0.152.
 */
package coins.ast.expr;

import coins.ast.ASTree;
import coins.ast.Declarator;
import coins.ast.TypeDecoder;
import coins.ast.Visitor;
import coins.ast.expr.LvalueExpr;

public class VariableExpr
extends ASTree
implements LvalueExpr {
    private Declarator decl;

    public VariableExpr(Declarator d) {
        this.decl = d;
    }

    public boolean isLvalue() {
        return !TypeDecoder.isArrayOrFunction(this.decl.getType(), 0);
    }

    public boolean hasAddress() {
        return true;
    }

    public void accept(Visitor v) {
        v.atVariableExpr(this);
    }

    public ASTree getLeft() {
        return null;
    }

    public ASTree getRight() {
        return null;
    }

    public void setLeft(ASTree _left) {
    }

    public void setRight(ASTree _right) {
    }

    public byte[] getType() {
        return this.decl.getType();
    }

    public Declarator getDeclarator() {
        return this.decl;
    }

    public String toString() {
        return this.decl.getName();
    }
}

