/*
 * Decompiled with CFR 0.152.
 */
package coins.ast.expr;

import coins.ast.Expr;
import coins.ast.TokenId;
import coins.ast.Visitor;
import coins.ast.expr.BinaryExpr;

public class AssignExpr
extends BinaryExpr
implements TokenId {
    private int opId;
    private String fileName;
    private int lineNumber;

    public AssignExpr(Expr lvalue, int op, Expr expr) {
        super(lvalue, expr);
        this.opId = op;
    }

    public void accept(Visitor v) {
        v.atAssignExpr(this);
    }

    public byte[] getType() {
        return ((Expr)((Object)this.getLeft())).getType();
    }

    public int operatorId() {
        return this.opId;
    }

    public String operatorName() {
        if (this.opId == 61) {
            return "=";
        }
        switch (this.opId) {
            case 350: {
                return "%=";
            }
            case 351: {
                return "&=";
            }
            case 352: {
                return "*=";
            }
            case 353: {
                return "+=";
            }
            case 354: {
                return "-=";
            }
            case 355: {
                return "/=";
            }
            case 356: {
                return "<<=";
            }
            case 357: {
                return "^=";
            }
            case 358: {
                return "|=";
            }
            case 359: {
                return ">>=";
            }
        }
        throw new RuntimeException("unknown operator: " + this.opId);
    }

    public void setPosition(String pFileName, int pLineNumber) {
        this.fileName = pFileName;
        this.lineNumber = pLineNumber;
    }

    public String fileName() {
        return this.fileName;
    }

    public int lineNumber() {
        return this.lineNumber;
    }
}

