/*
 * Decompiled with CFR 0.152.
 */
package coins.ast.expr;

import coins.ast.Expr;
import coins.ast.TokenId;
import coins.ast.TypeDecoder;
import coins.ast.Visitor;
import coins.ast.expr.BinaryExpr;
import coins.ast.expr.LvalueExpr;

public class ArrayExpr
extends BinaryExpr
implements TokenId,
LvalueExpr {
    private byte[] encodedType;

    public ArrayExpr(Expr array, Expr index, byte[] type) {
        super(array, index);
        this.encodedType = type;
    }

    public void accept(Visitor v) {
        v.atArrayExpr(this);
    }

    public byte[] getType() {
        return this.encodedType;
    }

    public boolean isLvalue() {
        return !TypeDecoder.isArrayOrFunction(this.encodedType, 0);
    }

    public boolean hasAddress() {
        return true;
    }

    public Expr getArray() {
        return this.getLeftOperand();
    }

    public Expr getIndex() {
        return this.getRightOperand();
    }

    public int operatorId() {
        return 383;
    }

    public String operatorName() {
        return "[]";
    }
}

