/*
 * Decompiled with CFR 0.152.
 */
package coins.ast;

import coins.ast.ASTree;
import coins.ast.Declarator;
import coins.ast.DeclaratorList;
import coins.ast.Stmnt;
import coins.ast.TypeId;
import coins.ast.Visitor;

public class Function
extends ASTree
implements TypeId,
Stmnt {
    private String fileName;
    private int lineNumber;
    private String dname;
    private byte[] type;
    private int storage;
    private DeclaratorList argList;
    private Stmnt functionBody;

    public Function(Declarator decl, Stmnt body) {
        this.fileName = decl.fileName();
        this.lineNumber = decl.lineNumber();
        this.dname = decl.getName();
        this.type = decl.getType();
        this.storage = decl.getStorage();
        this.argList = decl.getArgs();
        this.functionBody = body;
    }

    public ASTree getLeft() {
        return this.argList;
    }

    public ASTree getRight() {
        return (ASTree)((Object)this.functionBody);
    }

    public void setLeft(ASTree _left) {
        this.argList = (DeclaratorList)_left;
    }

    public void setRight(ASTree _right) {
        this.functionBody = (Stmnt)((Object)_right);
    }

    public void accept(Visitor v) {
        v.atFunction(this);
    }

    public String fileName() {
        return this.fileName;
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public String getName() {
        return this.dname;
    }

    public byte[] getType() {
        return this.type;
    }

    public int getStorage() {
        return this.storage;
    }

    public DeclaratorList getArguments() {
        return this.argList;
    }

    public Stmnt getBody() {
        return this.functionBody;
    }

    protected String getTag() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<func ");
        sbuf.append(this.storage);
        sbuf.append(' ');
        for (int i = 0; i < this.type.length; ++i) {
            sbuf.append((char)this.type[i]);
        }
        sbuf.append(' ');
        if (this.dname == null) {
            sbuf.append('?');
        } else {
            sbuf.append(this.dname);
        }
        sbuf.append('>');
        return sbuf.toString();
    }

    protected void putSeparator(StringBuffer sbuf) {
        sbuf.append("\n\t");
    }
}

