/*
 * Decompiled with CFR 0.152.
 */
package coins.alias;

import coins.HirRoot;
import coins.alias.AliasFactory;
import coins.alias.MyExpId;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirVisitorModel2;
import coins.ir.hir.PhiExp;
import coins.ir.hir.PointedExp;
import coins.ir.hir.QualifiedExp;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubscriptedExp;
import coins.ir.hir.VarNode;
import coins.sym.Sym;
import java.util.LinkedList;

class MyExpIdAssigner
extends HirVisitorModel2 {
    MyExpId[] fMyExpIdTable;
    final AliasFactory fFactory;
    SubpDefinition fSubpDef;
    private static final int EXP_ID_HASH_SIZE = 127;
    private final LinkedList[] fMyExpIdHashtable = new LinkedList[127];

    MyExpIdAssigner(SubpDefinition pSubpDef, HirRoot pHirRoot) {
        super(pHirRoot);
        this.ioRoot.dbgAlias.print(2, "\nMyExpIdAssigner " + pSubpDef.getSubpSym().toString());
        int lIndexTop = pSubpDef.getNodeIndexMax();
        if (lIndexTop <= 0 || pHirRoot.getFlowRoot() == null || pHirRoot.getFlowRoot().fSubpFlow == null || !pHirRoot.getFlowRoot().fSubpFlow.getRestructureFlag()) {
            // empty if block
        }
        this.fMyExpIdTable = new MyExpId[lIndexTop];
        this.fSubpDef = pSubpDef;
        this.fFactory = new AliasFactory(pHirRoot);
    }

    MyExpId[] assign() {
        this.visit(this.fSubpDef.getHirBody());
        if (this.ioRoot.getCompileSpecification().getTrace().shouldTrace("Alias", 5)) {
            HirIterator lHirIt = this.hirRoot.hir.hirIterator(this.fSubpDef.getHirBody());
            while (lHirIt.hasNext()) {
                HIR lHIR = lHirIt.next();
                if (lHIR == null) continue;
                this.ioRoot.printOut.println("HIR: " + lHIR.getIndex() + ", MyExpId: " + this.fMyExpIdTable[lHIR.getIndex()]);
            }
        }
        return this.fMyExpIdTable;
    }

    public void atVarNode(VarNode pVarNode) {
        MyExpId lMyExpId = this.assignToNode(pVarNode);
    }

    public void atExp(Exp pExp) {
        MyExpId lMyExpId = this.assignToNode(pExp);
        this.visitChildren(pExp);
    }

    public void atSubscriptedExp(SubscriptedExp pExp) {
        MyExpId lMyExpId = this.assignToNode(pExp);
        this.visitChildren(pExp);
    }

    public void atQualifiedExp(QualifiedExp pExp) {
        this.assignToNode(pExp);
        this.visitChildren(pExp);
    }

    public void atPointedExp(PointedExp pExp) {
        this.assignToNode(pExp);
        this.visitChildren(pExp);
    }

    public void atFunctionExp(FunctionExp pExp) {
        this.assignToNode(pExp);
        this.visitChildren(pExp);
    }

    public void atAssignStmt(AssignStmt pStmt) {
        this.assignToNode(pStmt);
        this.visitChildren(pStmt);
    }

    public void atPhiExp(PhiExp pExp) {
        this.assignToNode(pExp);
        this.visitChildren(pExp);
    }

    private MyExpId assignToNode(HIR pHir) {
        int lHashCode = MyExpIdAssigner.computeHashCodeOfNode(pHir);
        LinkedList<MyExpId> lMyExpIdChain = this.fMyExpIdHashtable[lHashCode];
        MyExpId lMyExpId2 = null;
        if (lMyExpIdChain == null) {
            this.fMyExpIdHashtable[lHashCode] = lMyExpIdChain = new LinkedList<MyExpId>();
        }
        boolean lBroken = false;
        for (MyExpId lMyExpId2 : lMyExpIdChain) {
            if (!MyExpIdAssigner.isSameTree(lMyExpId2.getHir(), pHir)) continue;
            lBroken = true;
            break;
        }
        if (!lBroken) {
            lMyExpId2 = this.fFactory.myExpId(pHir);
            lMyExpIdChain.addFirst(lMyExpId2);
        }
        this.fMyExpIdTable[pHir.getIndex()] = lMyExpId2;
        return lMyExpId2;
    }

    private static int computeHashCodeOfNode(HIR pNode) {
        if (pNode == null) {
            return 0;
        }
        int lCode = pNode.getOperator() + System.identityHashCode(pNode.getType());
        Sym lSym = pNode.getSym();
        if (lSym != null) {
            lCode = lCode * 2 + System.identityHashCode(lSym);
        } else {
            int lChildCount = pNode.getChildCount();
            for (int lChild = 1; lChild <= lChildCount; ++lChild) {
                lCode = lCode * 2 + MyExpIdAssigner.computeHashCodeOfNode((HIR)pNode.getChild(lChild));
            }
        }
        lCode = (lCode & Integer.MAX_VALUE) % 127;
        return lCode;
    }

    private static boolean isSameTree(HIR pTree1, HIR pTree2) {
        if (pTree1 == pTree2) {
            return true;
        }
        if (pTree1 == null || pTree2 == null) {
            return false;
        }
        if (MyExpIdAssigner.computeHashCodeOfNode(pTree1) != MyExpIdAssigner.computeHashCodeOfNode(pTree2)) {
            return false;
        }
        Sym lSym1 = pTree1.getSym();
        if (lSym1 != null) {
            return lSym1 == pTree2.getSym();
        }
        int lChildCount = pTree1.getChildCount();
        if (pTree1.getOperator() != pTree2.getOperator() || pTree2.getChildCount() != lChildCount || pTree1.getType() != pTree2.getType()) {
            return false;
        }
        for (int lChild = 1; lChild <= lChildCount; ++lChild) {
            if (MyExpIdAssigner.isSameTree((HIR)pTree1.getChild(lChild), (HIR)pTree2.getChild(lChild))) continue;
            return false;
        }
        return true;
    }
}

