/*
 * Decompiled with CFR 0.152.
 */
package coins.alias;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.PassException;
import coins.SymRoot;
import coins.alias.AliasAnal;
import coins.alias.AliasAnalHir1;
import coins.alias.AliasGroup;
import coins.backend.Module;
import coins.backend.Root;
import coins.backend.opt.JumpOpt;
import coins.backend.opt.SimpleOpt;
import coins.backend.util.ImList;
import coins.driver.CoinsOptions;
import coins.driver.CommandLine;
import coins.driver.CompileSpecification;
import coins.driver.CompilerDriver;
import coins.driver.Driver;
import coins.driver.Suffix;
import coins.driver.Trace;
import coins.ir.IrList;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirList;
import coins.ir.hir.HirVisitorModel2;
import coins.ir.hir.PointedExp;
import coins.ir.hir.Program;
import coins.ir.hir.QualifiedExp;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubscriptedExp;
import coins.ssa.SsaDriver;
import coins.sym.Type;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class AliasDriver
extends Driver {
    public void makeHirAliasAnalysis(HirRoot hirRoot) {
        CoinsOptions lCoinsOpts = hirRoot.ioRoot.getCompileSpecification().getCoinsOptions();
        IrList subpDefList = ((Program)hirRoot.programRoot).getSubpDefinitionList();
        ListIterator subpDefIterator = subpDefList.iterator();
        while (subpDefIterator.hasNext()) {
            SubpDefinition subpDef = (SubpDefinition)subpDefIterator.next();
            hirRoot.symRoot.useSymTableOfSubpDefinition(subpDef);
            AliasAnalHir1 lAlias = new AliasAnalHir1(hirRoot);
            lAlias.prepareForAliasAnalHir(subpDef);
            if (lCoinsOpts.isSet("aliasopt")) {
                this.testAliasByOptimizing(lAlias, subpDef, hirRoot);
                continue;
            }
            lAlias.printAliasPairs(subpDef);
        }
    }

    protected boolean testAliasByOptimizing(AliasAnal pAliasAnal, SubpDefinition pSubpDef, HirRoot pHirRoot) {
        return new SubpOptimizer(pAliasAnal, pSubpDef, pHirRoot).process();
    }

    public static void replaceNode(HIR pOld, HIR pNew) {
        if (pOld instanceof HIR) {
            HIR lParent = (HIR)pOld.getParent();
            if (lParent.getOperator() == 14) {
                HirList lHirList = (HirList)lParent;
                lHirList.set(lHirList.indexOf(pOld), pNew);
                pNew.setParent(lHirList);
            } else {
                lParent.replaceSource(pOld.getChildNumber(), pNew);
            }
        }
    }

    private List initTimingList(CoinsOptions coinsOptions, String option, char delimiter) {
        if (coinsOptions.isSet(option)) {
            return this.separateDelimitedList(coinsOptions.getArg(option), delimiter);
        }
        return new ArrayList();
    }

    private List initHirToCTimingList(CoinsOptions coinsOptions) {
        return this.initTimingList(coinsOptions, "hir2c", '/');
    }

    private List initLirToCTimingList(CoinsOptions coinsOptions) {
        return this.initTimingList(coinsOptions, "lir2c", '/');
    }

    public void compile(File sourceFile, Suffix suffix, InputStream in, OutputStream out, IoRoot io) throws IOException, PassException {
        CompileSpecification spec = io.getCompileSpecification();
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        List hirToCTimings = this.initHirToCTimingList(coinsOptions);
        List lirToCTimings = this.initLirToCTimingList(coinsOptions);
        Trace trace = spec.getTrace();
        SymRoot symRoot = new SymRoot(io);
        HirRoot hirRoot = new HirRoot(symRoot);
        symRoot.attachHirRoot(hirRoot);
        symRoot.initiate();
        boolean useOldLir = coinsOptions.isSet("oldlir");
        boolean useNewLir = coinsOptions.isSet("newlir");
        if (!useOldLir && !useNewLir) {
            if ("newlir".equals("oldlir")) {
                useOldLir = true;
                coinsOptions.set("oldlir");
            } else {
                useNewLir = true;
                coinsOptions.set("newlir");
            }
        }
        boolean skipHIR = suffix.getLanguageName().equals("LIR");
        boolean isLirOutput = false;
        if (suffix.getSuffixOption() != null) {
            trace.trace(this.myName, 5000, "suffix option: " + suffix.getSuffixOption());
            isLirOutput = suffix.getSuffixOption().equals("out-newlir");
        }
        FlowRoot hirFlowRoot = null;
        Object lirFlowRoot = null;
        ImList sexp = null;
        this.checkLIROptionsIntegrity(sourceFile, useOldLir, useNewLir, isLirOutput, skipHIR, io);
        if (!skipHIR) {
            this.makeHirFromSource(sourceFile, hirRoot, suffix, in, io);
            this.optimizeHirBeforeFlowAnalysis(hirRoot, symRoot, io);
            this.makeCSourceFromHirBase("new", hirToCTimings, hirRoot, symRoot, io);
            boolean alias = coinsOptions.isSet("alias");
            boolean optalias = coinsOptions.isSet("optalias");
            if (alias || !optalias) {
                // empty if block
            }
            this.makeHirAliasAnalysis(hirRoot);
            hirFlowRoot = coinsOptions.isSet("hirAnal") ? this.makeHIRFlowAnalysis(hirRoot, symRoot, io) : new FlowRoot(hirRoot);
            this.makeCSourceFromHirBase("flo", hirToCTimings, hirRoot, symRoot, io);
            this.setOptimizationOptions(spec, coinsOptions, useNewLir);
            this.optimizeHirAfterFlowAnalysis(hirRoot, hirFlowRoot, symRoot, io);
            this.makeCSourceFromHirBase("opt", hirToCTimings, hirRoot, symRoot, io);
            this.testSym(hirRoot, io);
            this.testHir(hirRoot, hirFlowRoot, io);
            sexp = this.makeNewLirFromHir(hirRoot, io, sourceFile, out, isLirOutput);
            if (isLirOutput) {
                trace.trace(this.myName, 5000, "LIR file is created. Quitting compile.");
                return;
            }
        } else {
            sexp = this.makeLIRFromLIRSource(in, io);
        }
        Root root = new Root(spec, new PrintWriter(System.out, true));
        Module unit = Module.loadSLir(sexp, coinsOptions.getArg("target"), "standard", root);
        this.makeCSourceFromLir("new", lirToCTimings, unit, io);
        if (spec.getCoinsOptions().isSet("ssa-opt")) {
            unit.apply(new SsaDriver(unit, io, spec));
            unit.apply(SimpleOpt.trig);
            unit.apply(JumpOpt.trig);
        } else {
            unit.basicOptimization();
        }
        this.makeCSourceFromLir("opt", lirToCTimings, unit, io);
        unit.generateCode(out);
        if (trace.shouldTrace("Sym", 1)) {
            trace.trace("Sym", 1, "\nSym after code generation ");
            symRoot.symTable.printSymTableAllDetail(symRoot.symTableRoot);
            symRoot.symTableConst.printSymTableDetail();
        }
    }

    public static void main(String[] args) {
        try {
            CommandLine spec = new CommandLine(args);
            int status = new CompilerDriver(spec).go(new AliasDriver());
            System.exit(status);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private class SubpOptimizer
    extends HirVisitorModel2 {
        private AliasAnal fAliasAnal;
        private SubpDefinition fSubpDef;
        private boolean fOptimized;

        private SubpOptimizer(AliasAnal pAliasAnal, SubpDefinition pSubpDef, HirRoot pHirRoot) {
            super(pHirRoot);
            this.fAliasAnal = pAliasAnal;
            this.fSubpDef = pSubpDef;
        }

        private boolean process() {
            this.visit(this.fSubpDef.getHirBody());
            return this.fOptimized;
        }

        public void atSubscritedExp(SubscriptedExp pExp) {
            this.tryOpt(pExp);
        }

        public void atQualifiedExp(QualifiedExp pExp) {
            this.tryOpt(pExp);
        }

        public void atPointedExp(PointedExp pExp) {
            this.tryOpt(pExp);
        }

        public void atExp(Exp pExp) {
            switch (pExp.getOperator()) {
                case 67: 
                case 68: {
                    this.tryOpt(pExp);
                    break;
                }
                default: {
                    this.visitChildren(pExp);
                }
            }
        }

        private void tryOpt(Exp pExp) {
            if (this.fAliasAnal.isLvalue(pExp)) {
                AliasGroup lAliasGroup = this.fAliasAnal.getAliasGroupFor(pExp);
                Type lType = pExp.getType();
                if ((long)lType.getAlignment() == lType.getSizeValue()) {
                    for (Exp lExp : lAliasGroup) {
                        if (!this.fAliasAnal.mustAlias(pExp, lExp) || lType != lExp.getType() || (long)lType.getAlignment() != lType.getSizeValue() || lExp.getOperator() != 7) continue;
                        AliasDriver.replaceNode(pExp, lExp.copyWithOperands());
                        this.fOptimized = true;
                        return;
                    }
                }
            }
            this.visitChildren(pExp);
        }
    }
}

