/*
 * Decompiled with CFR 0.152.
 */
package coins.alias;

import coins.HirRoot;
import coins.IoRoot;
import coins.alias.AliasAnal;
import coins.alias.AliasError;
import coins.alias.AliasFactory;
import coins.alias.AliasGroup;
import coins.alias.AliasUtil;
import coins.alias.ConstructPointsToGraph;
import coins.alias.MyExpId;
import coins.alias.MyExpIdAssigner;
import coins.alias.Tag;
import coins.alias.TagTreeBuilder;
import coins.alias.TagVector;
import coins.alias.util.BriggsSet;
import coins.alias.util.Scanner;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.SubpDefinition;
import coins.sym.Type;
import coins.sym.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AliasAnalHir1
implements AliasAnal {
    protected static final int AREA_INCLUDES = 1;
    protected static final int AREA_OVERLAPS = 2;
    protected static final int MUST_ALIAS = 3;
    protected static final int NOT_ALIAS = 4;
    protected static final int MAY_ALIAS = 7;
    protected static final String PREDEFINED = "aliaspredefined";
    protected Set fPredefined;
    Map fHIRToTag;
    Map fHIRTomallocTag;
    private Map fHIRToAliasGroup = new HashMap();
    private List fParentlessTags;
    int fTagBitCount;
    private int fBitPos;
    Tag[] fBitAssignedTags;
    TagVector[] fPointsTo;
    private TagVector fNonNullInitials;
    private TagVector fInitialAddressTakens;
    TagVector fCurFrame;
    TagVector fStatic;
    TagVector fHeap;
    TagVector fOther;
    TagVector fGlobals;
    TagVector fExternPes;
    TagVector fExternOpt;
    private boolean fCurFrameAddressTaken;
    public final HirRoot hirRoot;
    public final IoRoot ioRoot;
    final boolean fIsOptimistic;
    final AliasFactory fFactory;
    protected final AliasUtil fUtil;
    protected int fDbgLevel;

    public AliasAnalHir1(HirRoot pHirRoot) {
        this(pHirRoot.ioRoot.getCompileSpecification().getCoinsOptions().getArg("alias") != null ? pHirRoot.ioRoot.getCompileSpecification().getCoinsOptions().getArg("alias").equals("opt") : false, pHirRoot);
        this.fDbgLevel = pHirRoot.ioRoot.dbgAlias.getLevel();
    }

    public AliasAnalHir1(boolean pIsOptimistic, HirRoot pHirRoot) {
        this.hirRoot = pHirRoot;
        this.ioRoot = this.hirRoot.ioRoot;
        this.fFactory = new AliasFactory(this.hirRoot);
        this.fUtil = new AliasUtil(this.hirRoot.symRoot);
        this.fIsOptimistic = pIsOptimistic;
        this.dbg(1, "AliasAnalHir1", "optimistic=" + pIsOptimistic);
        this.readPredefined(this.ioRoot);
    }

    private Set readPredefined(IoRoot pIo) {
        HashSet lPredefineds = new HashSet();
        lPredefineds.addAll(this.hirRoot.symRoot.sourceLanguage.functionsWithoutSideEffect);
        this.dbg(2, "AliasAnal", "functionsWithoutSideEffect" + lPredefineds);
        this.fPredefined = lPredefineds;
        return this.fPredefined;
    }

    public void prepareForAliasAnalHir(SubpDefinition pSubpDef) {
        this.dbg(2, "prepareForAliasAnalHir1", pSubpDef.getSubpSym().getName());
        this.init();
        this.prepareTags(pSubpDef);
        this.constructPointsToGraph(pSubpDef);
        this.buildAliasGroups(pSubpDef);
    }

    private void init() {
    }

    void prepareTags(SubpDefinition pSubpDef) {
        int i;
        MyExpIdAssigner lAssigner = this.fFactory.myExpIdAssigner(pSubpDef);
        MyExpId[] lMyExpIdTable = lAssigner.assign();
        if (this.ioRoot.getCompileSpecification().getTrace().shouldTrace("Alias", 5)) {
            for (int i2 = 0; i2 < lMyExpIdTable.length; ++i2) {
                this.ioRoot.printOut.println("lMyExpIdTable[" + i2 + "] = " + lMyExpIdTable[i2]);
            }
        }
        TagTreeBuilder lBuilder = this.fFactory.tagTreeBuilder(pSubpDef, lMyExpIdTable, this.fIsOptimistic);
        this.fHIRToTag = lBuilder.process();
        this.fHIRTomallocTag = lBuilder.fHIRTomallocTag;
        this.fParentlessTags = lBuilder.fParentlessTags;
        this.fTagBitCount = lBuilder.fTagBitCount;
        this.fNonNullInitials = this.fFactory.tagVector(this.fTagBitCount);
        this.fInitialAddressTakens = this.fFactory.tagVector(this.fTagBitCount);
        this.fCurFrame = this.fFactory.tagVector(this.fTagBitCount);
        this.fStatic = this.fFactory.tagVector(this.fTagBitCount);
        this.fHeap = this.fFactory.tagVector(this.fTagBitCount);
        this.fOther = this.fFactory.tagVector(this.fTagBitCount);
        this.fGlobals = this.fFactory.tagVector(this.fTagBitCount);
        this.fExternPes = this.fFactory.tagVector(this.fTagBitCount);
        this.fExternOpt = this.fFactory.tagVector(this.fTagBitCount);
        this.fPointsTo = new TagVector[this.fTagBitCount];
        for (i = 0; i < this.fTagBitCount; ++i) {
            this.fPointsTo[i] = this.fFactory.tagVector(this.fTagBitCount);
        }
        this.assignBits();
        for (i = 0; i < this.fTagBitCount; ++i) {
            if (!this.fNonNullInitials.isSet(i)) continue;
            this.fPointsTo[i].vectorOr(this.fInitialAddressTakens, this.fPointsTo[i]);
            if (this.fDbgLevel <= 3) continue;
            this.dbg(5, "fPointsTo " + i, Arrays.asList(this.fPointsTo));
        }
        if (this.fDbgLevel > 3) {
            this.dbg(5, "Bit-assigned tags ", Arrays.asList(this.fBitAssignedTags));
        }
    }

    private void assignBits() {
        ArrayList<Tag> lOther = new ArrayList<Tag>();
        this.fBitAssignedTags = new Tag[this.fTagBitCount];
        this.fBitPos = -1;
        this.fCurFrameAddressTaken = false;
        if (this.fDbgLevel > 3) {
            this.dbg(5, "fParentlessTags: ", this.fParentlessTags);
        }
        block5: for (Tag lTag : this.fParentlessTags) {
            switch (lTag.fStorageClass) {
                case 1: 
                case 2: {
                    this.setVectForCurFrameStatic(lTag);
                    continue block5;
                }
                case 3: {
                    this.setVectForHeap(lTag);
                    continue block5;
                }
                case 0: 
                case 4: {
                    lOther.add(lTag);
                    continue block5;
                }
            }
            throw new AliasError("Unexpected.");
        }
        for (Tag lTag : lOther) {
            if (lTag.fMyExpId == null) {
                this.setVectForOther(lTag);
                continue;
            }
            this.setVectForUndecay(lTag, ((Tag)this.fHIRToTag.get((Object)lTag.fMyExpId.fHIR.getChild1())).fBitPos);
        }
        this.fOther.vectorOr(this.fStatic, this.fExternPes);
        this.fExternPes.vectorOr(this.fHeap, this.fExternPes);
        this.fOther.vectorOr(this.fGlobals, this.fExternOpt);
        this.fInitialAddressTakens.setBit(this.fTagBitCount - 1);
    }

    private TagVector setVectForCurFrameStatic(Tag pTag) {
        Var lVar = (Var)pTag.fMyExpId.getHir().getSym();
        pTag.fTagVect = this.fFactory.tagVector(this.fTagBitCount);
        pTag.fTagVect.setBit(++this.fBitPos);
        if (lVar != null) {
            if (lVar.getSymKind() == 9) {
                if (this.fDbgLevel > 3) {
                    this.dbg(5, "Parameter", pTag);
                }
                this.fNonNullInitials.setBit(this.fBitPos);
            }
            if (lVar.getStorageClass() == 6) {
                if (lVar.isGlobal()) {
                    this.fGlobals.setBit(this.fBitPos);
                    this.fInitialAddressTakens.setBit(this.fBitPos);
                    this.fNonNullInitials.setBit(this.fBitPos);
                }
                if (!this.fIsOptimistic || lVar.getFlag(6)) {
                    this.fInitialAddressTakens.setBit(this.fBitPos);
                    this.fNonNullInitials.setBit(this.fBitPos);
                }
            } else if (lVar.getStorageClass() == 7 && lVar.getFlag(6)) {
                this.fCurFrameAddressTaken = true;
            }
            if (lVar.getStorageClass() == 7) {
                this.fCurFrame.setBit(this.fBitPos);
            } else {
                this.fStatic.setBit(this.fBitPos);
            }
        } else {
            int lParentBitPos = pTag.fParent.fBitPos;
            if (this.fNonNullInitials.isSet(lParentBitPos)) {
                this.fNonNullInitials.setBit(this.fBitPos);
            }
            if (this.fInitialAddressTakens.isSet(lParentBitPos)) {
                this.fInitialAddressTakens.setBit(this.fBitPos);
            }
            if (this.fCurFrame.isSet(lParentBitPos)) {
                this.fCurFrame.setBit(this.fBitPos);
            }
            if (this.fStatic.isSet(lParentBitPos)) {
                this.fStatic.setBit(this.fBitPos);
            }
            if (this.fGlobals.isSet(lParentBitPos)) {
                this.fGlobals.setBit(this.fBitPos);
            }
        }
        pTag.fBitPos = this.fBitPos;
        this.fBitAssignedTags[this.fBitPos] = pTag;
        ArrayList<Tag> lPromotedChildren = new ArrayList<Tag>();
        for (Tag lChild : pTag.fChildren) {
            if (lChild.fIsUnique) {
                if (pTag.fKind == 7) {
                    this.processUnionChildren(pTag);
                    continue;
                }
                pTag.fTagVect.vectorOr(this.setVectForCurFrameStatic(lChild), pTag.fTagVect);
                continue;
            }
            lPromotedChildren.add(lChild);
        }
        for (Tag lTag : lPromotedChildren) {
            this.processNonUniqueChildren(lTag, pTag.fTagVect);
        }
        return pTag.fTagVect;
    }

    private TagVector setVectForHeap(Tag pTag) {
        pTag.fTagVect = this.fFactory.tagVector(this.fTagBitCount);
        pTag.fTagVect.setBit(++this.fBitPos);
        pTag.fBitPos = this.fBitPos;
        this.fBitAssignedTags[this.fBitPos] = pTag;
        this.fHeap.setBit(this.fBitPos);
        return pTag.fTagVect;
    }

    private TagVector setVectForUndecay(Tag pTag, int pPointerBitPos) {
        pTag.fTagVect = this.fFactory.tagVector(this.fTagBitCount);
        pTag.fTagVect.setBit(++this.fBitPos);
        this.fNonNullInitials.setBit(this.fBitPos);
        pTag.fBitPos = this.fBitPos;
        this.fBitAssignedTags[this.fBitPos] = pTag;
        ArrayList lPromotedChildren = new ArrayList();
        throw new AliasError("How should I handle the storage class for undecay?");
    }

    private TagVector setVectForOther(Tag pTag) {
        pTag.fTagVect = this.fFactory.tagVector(this.fTagBitCount);
        pTag.fTagVect.setBit(++this.fBitPos);
        this.fNonNullInitials.setBit(this.fBitPos);
        pTag.fBitPos = this.fBitPos;
        this.fBitAssignedTags[this.fBitPos] = pTag;
        this.fOther.setBit(this.fBitPos);
        return pTag.fTagVect;
    }

    private void processNonUniqueChildren(Tag pTag, TagVector pParentVect) {
        pTag.fTagVect = this.fFactory.tagVector(this.fTagBitCount);
        pParentVect.vectorCopy(pTag.fTagVect);
        for (Tag lTag : pTag.fChildren) {
            this.processNonUniqueChildren(lTag, pParentVect);
        }
    }

    private void processUnionChildren(Tag pTag) {
        for (Tag lTag : pTag.fChildren) {
            lTag.fTagVect = this.fFactory.tagVector(this.fTagBitCount);
            pTag.fTagVect.vectorCopy(lTag.fTagVect);
            this.processUnionChildren(lTag);
        }
    }

    private TagVector[] constructPointsToGraph(SubpDefinition pSubpDef) {
        ConstructPointsToGraph lConstructPointsToGraph = new ConstructPointsToGraph(this, this.hirRoot);
        this.fPointsTo = lConstructPointsToGraph.makePointsToGraph(pSubpDef);
        return this.fPointsTo;
    }

    private Map buildAliasGroups(SubpDefinition pSubpDef) {
        AliasGroup lAliasGroup;
        BriggsSet lBriggsSet;
        Tag lTag;
        AliasGroup[] lAliasGroups = new AliasGroup[this.fTagBitCount];
        for (int i = 0; i < lAliasGroups.length; ++i) {
            lAliasGroups[i] = this.fFactory.aliasGroup();
        }
        HashMap<Tag, BriggsSet> lTagToAliasGroups = new HashMap<Tag, BriggsSet>();
        for (Map.Entry lEntry : this.fHIRToTag.entrySet()) {
            Exp lExp = (Exp)lEntry.getKey();
            lTag = (Tag)lEntry.getValue();
            lBriggsSet = lTag.fTagVect.toBriggsSet();
            Scanner lScanner = lBriggsSet.scanner();
            while (lScanner.hasNext()) {
                int lBitPos = lScanner.next();
                lAliasGroups[lBitPos].add(lExp);
            }
            lTagToAliasGroups.put(lTag, lBriggsSet);
        }
        Object lIt = this.fHIRToTag.entrySet().iterator();
        while (lIt.hasNext()) {
            Map.Entry lEntry;
            lAliasGroup = this.fFactory.aliasGroup();
            lEntry = lIt.next();
            Exp lExp = (Exp)lEntry.getKey();
            if (this.fDbgLevel > 3) {
                this.dbg(5, "Building AliasGroup for " + lExp + " ...", "");
            }
            lTag = (Tag)lEntry.getValue();
            lBriggsSet = (BriggsSet)lTagToAliasGroups.get(lTag);
            Scanner lScanner = lBriggsSet.scanner();
            while (lScanner.hasNext()) {
                int lBitPos = lScanner.next();
                for (Exp lExp0 : lAliasGroups[lBitPos]) {
                    Type lType0;
                    Type lType = lTag.getFlag(1) ? lTag.fUnionAncestor.fType : lExp.getType();
                    Tag lTag0 = (Tag)this.fHIRToTag.get(lExp0);
                    Type type = lType0 = lTag0.getFlag(1) ? lTag0.fUnionAncestor.fType : lExp0.getType();
                    if (this.fIsOptimistic && !this.fUtil.mayAlias(lType, lType0)) continue;
                    lAliasGroup.add(lExp0);
                }
            }
            this.fHIRToAliasGroup.put(lExp, lAliasGroup);
        }
        if (this.ioRoot.getCompileSpecification().getTrace().shouldTrace("Alias", 5)) {
            lIt = this.hirRoot.hir.hirIterator(pSubpDef.getHirBody());
            while (lIt.hasNext()) {
                HIR lHIR = lIt.next();
                if (!this.fHIRToTag.containsKey(lHIR)) continue;
                lAliasGroup = (AliasGroup)this.fHIRToAliasGroup.get(lHIR);
                this.ioRoot.printOut.println("AliasGroup for " + lHIR + ": " + lAliasGroup.sort());
            }
        }
        return this.fHIRToAliasGroup;
    }

    protected int areAliased(Exp pExp, Exp pExp0) {
        if (!this.fHIRToTag.containsKey(pExp)) {
            throw new IllegalArgumentException(pExp + " not lvalue.");
        }
        if (!this.fHIRToTag.containsKey(pExp0)) {
            throw new IllegalArgumentException(pExp0 + " not lvalue.");
        }
        if (this.getAliasGroupFor(pExp).contains(pExp0)) {
            return this.areAliased0(pExp, pExp0);
        }
        return 4;
    }

    private int areAliased0(Exp pExp, Exp pExp0) {
        TagVector lTagVect1 = this.fFactory.tagVector(this.fTagBitCount);
        Tag lTag = (Tag)this.fHIRToTag.get(pExp);
        Tag lTag0 = (Tag)this.fHIRToTag.get(pExp0);
        TagVector lTagVect = lTag.fTagVect;
        TagVector lTagVect0 = lTag0.fTagVect;
        lTagVect.vectorAnd(lTagVect0, lTagVect1);
        if (!lTagVect1.isZero()) {
            if (lTagVect.vectorEqual(lTagVect1) && lTag0.fIsUnique || lTagVect0.vectorEqual(lTagVect1) && lTag.fIsUnique) {
                return 3;
            }
            return 7;
        }
        throw new AliasError("Unexpected.");
    }

    public AliasGroup getAliasGroupFor(Exp pExp) {
        if (this.isLvalue(pExp)) {
            return (AliasGroup)this.fHIRToAliasGroup.get(pExp);
        }
        throw new IllegalArgumentException(pExp + " not lvalue.");
    }

    public void printAliasPairs(SubpDefinition pSubpDef) {
        ArrayList<HIR> lHIRList = new ArrayList<HIR>();
        HirIterator lIt = this.hirRoot.hir.hirIterator(pSubpDef.getHirBody());
        while (lIt.hasNext()) {
            HIR lHIR = lIt.next();
            lHIRList.add(lHIR);
        }
        HIR[] lHIRs = lHIRList.toArray(new HIR[0]);
        this.ioRoot.printOut.println("---Alias Pairs--- " + pSubpDef.getSubpSym().getName());
        this.ioRoot.printOut.println("Legend (D: Definitely aliased, P: Possibly aliased)");
        this.ioRoot.printOut.println("");
        for (int i = 0; i < lHIRs.length; ++i) {
            Tag lTag = (Tag)this.fHIRToTag.get(lHIRs[i]);
            if (lTag == null) continue;
            block6: for (int j = i + 1; j < lHIRs.length; ++j) {
                Tag lTag0 = (Tag)this.fHIRToTag.get(lHIRs[j]);
                if (lTag0 == null || lHIRs[i].isSameAs(lHIRs[j])) continue;
                switch (this.areAliased((Exp)lHIRs[i], (Exp)lHIRs[j])) {
                    case 3: {
                        this.ioRoot.printOut.println("(D: " + lHIRs[i] + ", " + lHIRs[j] + ")");
                        continue block6;
                    }
                    case 7: {
                        this.ioRoot.printOut.println("(P: " + lHIRs[i] + ", " + lHIRs[j] + ")");
                    }
                }
            }
        }
        this.ioRoot.printOut.println();
    }

    public void printAliasPairsDetail(SubpDefinition pSubpDef) {
        ArrayList<HIR> lHIRList = new ArrayList<HIR>();
        HirIterator lIt = this.hirRoot.hir.hirIterator(pSubpDef.getHirBody());
        while (lIt.hasNext()) {
            HIR lHIR = lIt.next();
            lHIRList.add(lHIR);
        }
        HIR[] lHIRs = lHIRList.toArray(new HIR[0]);
        this.ioRoot.printOut.println("---Alias Pairs---");
        for (int i = 0; i < lHIRs.length; ++i) {
            Tag lTag = (Tag)this.fHIRToTag.get(lHIRs[i]);
            if (lTag == null) continue;
            for (int j = i + 1; j < lHIRs.length; ++j) {
                Tag lTag0 = (Tag)this.fHIRToTag.get(lHIRs[j]);
                if (lTag0 == null) continue;
                if (lHIRs[i].isSameAs(lHIRs[j])) continue;
                switch (this.areAliased((Exp)lHIRs[i], (Exp)lHIRs[j])) {
                    case 3: {
                        this.ioRoot.printOut.println(AliasUtil.toString(lHIRs[i]) + " and " + AliasUtil.toString(lHIRs[j]) + " are definitely aliased.");
                        break;
                    }
                    case 7: {
                        this.ioRoot.printOut.println(AliasUtil.toString(lHIRs[i]) + " and " + AliasUtil.toString(lHIRs[j]) + " are possibly aliased.");
                    }
                }
                continue;
            }
        }
        this.ioRoot.printOut.println();
    }

    public boolean mayAlias(Exp pExp, Exp pExp0) {
        return (this.areAliased(pExp, pExp0) & 3) != 0;
    }

    public boolean mustAlias(Exp pExp, Exp pExp0) {
        return (this.areAliased(pExp, pExp0) & 4) == 0;
    }

    public boolean isLvalue(Exp pExp) {
        return this.fHIRToTag.containsKey(pExp);
    }

    public void dbg(int pLevel, String pHeader, Object pBody) {
        String lStr;
        String string = lStr = pBody == null ? "null" : pBody.toString();
        if (this.ioRoot.getCompileSpecification().getTrace().getTraceLevel("Alias") >= pLevel) {
            this.ioRoot.printOut.print(" " + pHeader + " " + lStr);
            this.ioRoot.printOut.println();
        }
    }
}

