/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow.util;

import coins.aflow.util.BitVector;
import coins.aflow.util.BitVectorIterator;
import coins.aflow.util.BitVectorIteratorImpl;

public class BitVectorImpl
implements BitVector,
Cloneable {
    protected int fLongWordLength = 1;
    protected int fBitLength = 64;
    protected int fShiftMax = 63;
    protected long[] fVectorWord;

    protected BitVectorImpl() {
    }

    protected BitVectorImpl(int pLongWordCount) {
        this.fLongWordLength = pLongWordCount;
        this.fBitLength = this.fLongWordLength * 64 - 1;
        this.fVectorWord = new long[pLongWordCount];
    }

    public void setBit(int pInx) {
        int lWord = pInx / 64;
        int lInx = pInx - lWord * 64;
        this.fVectorWord[lWord] = this.fVectorWord[lWord] | 1L << this.fShiftMax - lInx;
    }

    public void resetBit(int pInx) {
        int lWord = pInx / 64;
        int lInx = pInx - lWord * 64;
        long lMask = 1L << this.fShiftMax - lInx ^ 0xFFFFFFFFFFFFFFFFL;
        this.fVectorWord[lWord] = this.fVectorWord[lWord] & lMask;
    }

    public int getBit(int pInx) {
        int lWord = pInx / 64;
        int lInx = pInx - lWord * 64;
        int lBit = (int)(this.fVectorWord[lWord] >>> this.fShiftMax - lInx & 1L);
        return lBit;
    }

    public boolean isSet(int pInx) {
        return this.getBit(pInx) == 1;
    }

    public boolean isZero() {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            if (this.fVectorWord[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public int getBitLength() {
        return this.fBitLength;
    }

    public int getWordLength() {
        return this.fLongWordLength;
    }

    public long[] getVectorWord() {
        return this.fVectorWord;
    }

    public BitVectorIterator bitVectorIterator() {
        return new BitVectorIteratorImpl(this);
    }

    public void vectorAnd(BitVector pOperand2, BitVector pResult) {
        if (pOperand2 == null) {
            return;
        }
        for (int i = 0; i < this.fLongWordLength; ++i) {
            ((BitVectorImpl)pResult).fVectorWord[i] = this.fVectorWord[i] & ((BitVectorImpl)pOperand2).fVectorWord[i];
        }
    }

    public void vectorOr(BitVector pOperand2, BitVector pResult) {
        if (pOperand2 == null) {
            return;
        }
        for (int i = 0; i < this.fLongWordLength; ++i) {
            ((BitVectorImpl)pResult).fVectorWord[i] = this.fVectorWord[i] | ((BitVectorImpl)pOperand2).fVectorWord[i];
        }
    }

    public void vectorXor(BitVector pOperand2, BitVector pResult) {
        if (pOperand2 == null) {
            return;
        }
        for (int i = 0; i < this.fLongWordLength; ++i) {
            ((BitVectorImpl)pResult).fVectorWord[i] = this.fVectorWord[i] ^ ((BitVectorImpl)pOperand2).fVectorWord[i];
        }
    }

    public void vectorNot(BitVector pResult) {
        if (pResult == null) {
            return;
        }
        for (int i = 0; i < this.fLongWordLength; ++i) {
            ((BitVectorImpl)pResult).fVectorWord[i] = this.fVectorWord[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public void vectorSub(BitVector pOperand2, BitVector pResult) {
        if (pOperand2 == null) {
            return;
        }
        for (int i = 0; i < this.fLongWordLength; ++i) {
            ((BitVectorImpl)pResult).fVectorWord[i] = this.fVectorWord[i] & (((BitVectorImpl)pOperand2).fVectorWord[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void vectorCopy(BitVector pResult) {
        if (pResult == null) {
            return;
        }
        for (int i = 0; i < this.fLongWordLength; ++i) {
            ((BitVectorImpl)pResult).fVectorWord[i] = this.fVectorWord[i];
        }
    }

    public boolean vectorEqual(BitVector pOperand2) {
        if (pOperand2 == null) {
            return false;
        }
        boolean lResult = false;
        int i = 0;
        do {
            boolean bl = lResult = this.fVectorWord[i] != ((BitVectorImpl)pOperand2).fVectorWord[i];
        } while (++i < this.fLongWordLength && !lResult);
        return !lResult;
    }

    public boolean equals(Object pObj) {
        if (pObj instanceof BitVector) {
            return this.vectorEqual((BitVector)pObj);
        }
        return false;
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this.fVectorWord.length; ++i) {
            code = (int)((long)code + this.fVectorWord[i]);
        }
        return code;
    }

    public void vectorReset() {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            this.fVectorWord[i] = 0L;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            BitVector lBitVect = (BitVector)super.clone();
            ((BitVectorImpl)lBitVect).fVectorWord = (long[])this.fVectorWord.clone();
            return lBitVect;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public String toString() {
        StringBuffer lBuffer = new StringBuffer(" ");
        for (int i = 1; i <= this.fBitLength; ++i) {
            if (this.getBit(i) != 1) continue;
            lBuffer.append(" " + i);
        }
        return lBuffer.toString().intern();
    }

    public String toStringDescriptive() {
        return this.toString();
    }
}

