/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.FlowRoot;
import coins.aflow.BBlock;
import coins.aflow.LoopInf;
import coins.ir.IR;
import coins.sym.FlagBox;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class LoopInfImpl
implements LoopInf {
    protected final FlowRoot flowRoot;
    protected LoopInf fParent;
    protected LoopInf fFirstChild;
    protected LoopInf fNextBrother;
    protected LinkedList fBBlockList;
    protected IR fEntryNode;
    protected LinkedList fAlternateEntryNodeList;
    protected BBlock fEntryBBlock;
    protected LinkedList fAlternateEntryBBlockList;
    protected FlagBox fFlagBox;

    protected LoopInfImpl(FlowRoot pFlowRoot, IR pEntryNode) {
        this.flowRoot = pFlowRoot;
    }

    public LoopInf getParent() {
        return this.fParent;
    }

    public void setParent(LoopInf pParent) {
        this.fParent = pParent;
    }

    public LoopInf getFirstChild() {
        return this.fFirstChild;
    }

    public void setFirstChild(LoopInf pChild) {
        this.fFirstChild = pChild;
    }

    public LoopInf getNextBrother() {
        return this.fNextBrother;
    }

    public void setNextBrother(LoopInf pBrother) {
        this.fNextBrother = pBrother;
    }

    public BBlock getEntryBBlock() {
        return this.fEntryBBlock;
    }

    public void setEntryBBlock(BBlock pEntryBBlock) {
        this.fEntryBBlock = pEntryBBlock;
        if (this.fEntryNode == null) {
            this.fEntryNode = pEntryBBlock.getIrLink();
        }
        this.addBBlock(pEntryBBlock);
    }

    public List getBBlockList() {
        return this.fBBlockList;
    }

    public void addBBlock(BBlock pBBlock) {
        if (!this.fBBlockList.contains(pBBlock)) {
            this.fBBlockList.add(pBBlock);
        }
        if (this.fParent != null) {
            this.fParent.addBBlock(pBBlock);
        }
    }

    public void deleteBBlock(BBlock pBBlock) {
        this.fBBlockList.remove(pBBlock);
        if (this.fParent != null) {
            this.fParent.deleteBBlock(pBBlock);
        }
    }

    public List getAlternateEntryNodeList() {
        return this.fAlternateEntryNodeList;
    }

    public List getAlternateEntryBBlockList() {
        return this.fAlternateEntryBBlockList;
    }

    public void addAlternateEntryNode(IR pEntryNode) {
        if (this.fAlternateEntryNodeList == null) {
            this.fAlternateEntryNodeList = new LinkedList();
        }
        if (!this.fAlternateEntryNodeList.contains(pEntryNode)) {
            this.fAlternateEntryNodeList.add(pEntryNode);
        }
    }

    public void addAlternateEntryBBlock(BBlock pEntryBBlock) {
        if (this.fAlternateEntryBBlockList == null) {
            this.fAlternateEntryBBlockList = new LinkedList();
        }
        if (!this.fAlternateEntryBBlockList.contains(pEntryBBlock)) {
            this.fAlternateEntryBBlockList.add(pEntryBBlock);
        }
    }

    public boolean getFlag(int pFlagNumber) {
        return this.fFlagBox.getFlag(pFlagNumber);
    }

    public void setFlag(int pFlagNumber, boolean pYesNo) {
        this.fFlagBox.setFlag(pFlagNumber, pYesNo);
    }

    public void propagateFlag(int pFlagNumber) {
        this.fFlagBox.setFlag(pFlagNumber, true);
        if (this.fParent != null) {
            this.fParent.propagateFlag(pFlagNumber);
        }
    }

    public void print(int pDebugLevel) {
        if (pDebugLevel <= this.flowRoot.ioRoot.dbgFlow.getLevel()) {
            this.flowRoot.ioRoot.dbgFlow.print(pDebugLevel, "LoopInf", "Entry node " + this.fEntryNode.toString() + " Entry BBlock B" + this.fEntryBBlock.getBBlockNumber() + "\n    BBlockList");
            ListIterator lIterator = this.fBBlockList.listIterator();
            while (lIterator.hasNext()) {
                BBlock lBBlock = (BBlock)lIterator.next();
                if (lBBlock == null) continue;
                this.flowRoot.ioRoot.dbgFlow.print(pDebugLevel, " B" + lBBlock.getBBlockNumber());
            }
            this.flowRoot.ioRoot.dbgFlow.print(pDebugLevel, "\n    Flags HasCall " + this.fFlagBox.getFlag(7) + " ptrAssign " + this.fFlagBox.getFlag(8) + " usePtr " + this.fFlagBox.getFlag(9) + " hasStructUnion " + this.fFlagBox.getFlag(10));
            if (this.fFirstChild != null) {
                this.fFirstChild.print(pDebugLevel);
            }
            if (this.fNextBrother != null) {
                this.fNextBrother.print(pDebugLevel);
            }
        }
    }
}

