/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.BBlock;
import coins.aflow.FindExposedUsed;
import coins.aflow.FlowAnalSymVector;
import coins.aflow.FlowAnalSymVectorImpl;
import coins.aflow.FlowResults;
import coins.aflow.FlowUtil;
import coins.aflow.NodeIterator;
import coins.aflow.SetRefRepr;
import coins.aflow.SubpFlow;
import coins.ir.IR;
import coins.sym.FlowAnalSym;
import java.util.HashSet;

public class FindPExposedUsed
extends FindExposedUsed {
    public FindPExposedUsed(FlowResults pResults) {
        super(pResults);
    }

    protected void registerExposed(BBlock pBBlock, FlowAnalSymVector pExposed) {
        pBBlock.setPExposed(pExposed);
    }

    protected void registerUsed(BBlock pBBlock, FlowAnalSymVector pUsed) {
        pBBlock.setPUsed(pUsed);
    }

    public void find(SetRefRepr pSetRefRepr) {
        boolean lCalled = false;
        SubpFlow lSubpFlow = pSetRefRepr.getBBlock().getSubpFlow();
        HashSet<FlowAnalSym> lExposedFlowAnalSyms = new HashSet<FlowAnalSym>();
        HashSet<FlowAnalSym> lUsedFlowAnalSyms = new HashSet<FlowAnalSym>();
        NodeIterator lIt = pSetRefRepr.nodeIterator();
        while (lIt.hasNext()) {
            IR lIR = lIt.next();
            if (lIR == pSetRefRepr.defNode()) continue;
            if (FlowUtil.readsFromIndefiniteAddress(lIR)) {
                lExposedFlowAnalSyms.addAll(lSubpFlow.getSymIndexTable());
                lUsedFlowAnalSyms.addAll(lSubpFlow.getSymIndexTable());
                break;
            }
            FlowAnalSym lFlowAnalSym = FlowUtil.flowAnalSym(lIR);
            if (lFlowAnalSym == null) continue;
            lExposedFlowAnalSyms.add(lFlowAnalSym);
            lUsedFlowAnalSyms.add(lFlowAnalSym);
        }
        this.fResults.put("PExposed", pSetRefRepr, FlowAnalSymVectorImpl.forSet(lExposedFlowAnalSyms, lSubpFlow));
        this.fResults.put("PUsed", pSetRefRepr, FlowAnalSymVectorImpl.forSet(lUsedFlowAnalSyms, lSubpFlow));
    }

    protected FlowAnalSymVector getDefined(SetRefRepr pSetRefRepr) {
        return pSetRefRepr.getDDefined();
    }

    protected FlowAnalSymVector getExposed(SetRefRepr pSetRefRepr) {
        return pSetRefRepr.getPExposed();
    }

    protected FlowAnalSymVector getUsed(SetRefRepr pSetRefRepr) {
        return pSetRefRepr.getPUsed();
    }
}

