/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.BBlock;
import coins.aflow.ExpVector;
import coins.aflow.ExpVectorImpl;
import coins.aflow.FlowAdapter;
import coins.aflow.FlowExpId;
import coins.aflow.FlowResults;
import coins.aflow.SetRefRepr;
import coins.aflow.SubpFlow;
import coins.aflow.util.FAList;
import coins.alias.RecordAlias;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;

public abstract class FindEKill
extends FlowAdapter {
    public FindEKill(FlowResults pResults) {
        super(pResults);
    }

    public void find(SubpFlow pSubpFlow) {
        Iterator lIt = pSubpFlow.getBBlocks().iterator();
        while (lIt.hasNext()) {
            this.find((BBlock)lIt.next());
        }
    }

    public void find(BBlock pBBlock) {
        HashSet lEKillSet = new HashSet();
        FAList lFlowExpIdTable = (FAList)this.fResults.get("FlowExpIdTable", pBBlock.getSubpFlow());
        for (FlowExpId lExpId : lFlowExpIdTable) {
            this.addEKill(lEKillSet, lExpId, pBBlock);
        }
        ExpVector lEKill = ExpVectorImpl.forSet(lEKillSet, pBBlock.getSubpFlow());
        this.flowRoot.aflow.dbg(2, " FindEKill", pBBlock.toString() + " " + lEKill);
        this.register(pBBlock, lEKill);
    }

    public void find(SetRefRepr pSetRefRepr) {
        SubpFlow lSubpFlow = pSetRefRepr.getBBlock().getSubpFlow();
        FAList lFlowExpIdTable = (FAList)this.fResults.get("FlowExpIdTable", lSubpFlow);
        ExpVector lExpVect = lSubpFlow.expVector();
        ListIterator lIt = lFlowExpIdTable.listIterator();
        while (lIt.hasNext()) {
            FlowExpId lFlowExpId = (FlowExpId)lIt.next();
            if (!this.kills(pSetRefRepr, lFlowExpId)) continue;
            lExpVect.setBit(lIt.previousIndex());
        }
        this.register(pSetRefRepr, lExpVect);
    }

    protected abstract void addEKill(Set var1, FlowExpId var2, BBlock var3, RecordAlias var4);

    protected abstract boolean killsByAlias(SetRefRepr var1, FlowExpId var2, RecordAlias var3);

    protected abstract void addEKill(Set var1, FlowExpId var2, BBlock var3);

    protected abstract boolean kills(SetRefRepr var1, FlowExpId var2);

    protected abstract void register(BBlock var1, ExpVector var2);

    protected abstract void register(SetRefRepr var1, ExpVector var2);
}

