/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.CompileError;
import coins.FlowRoot;
import coins.aflow.BBlock;
import coins.aflow.DefVector;
import coins.aflow.Edge;
import coins.aflow.EdgeImpl;
import coins.aflow.ExpVector;
import coins.aflow.FlowAnalSymVector;
import coins.aflow.FlowExpId;
import coins.aflow.FlowResults;
import coins.aflow.SetRefRepr;
import coins.aflow.SetRefReprList;
import coins.aflow.SubpFlow;
import coins.aflow.util.UnimplementedMethodException;
import coins.ir.IR;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.Stmt;
import coins.sym.Sym;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class BBlockImpl
implements BBlock {
    public final FlowRoot flowRoot;
    protected final int fBBlockNumber;
    protected IR fIrLink;
    protected LinkedList fPredList;
    protected LinkedList fSuccList;
    protected LinkedList fPredEdgeList;
    protected LinkedList fSuccEdgeList;
    protected BBlock fNextInDFO;
    protected BBlock fNextInInverseDFO;
    private List fDom;
    private BBlock fImmediateDom;
    private List fDominatedChildren;
    private List fPostdom;
    private BBlock fImmediatePostdom;
    private List fPostdominatedChildren;
    protected Object fWork;
    private final SubpFlow fSubpFlow;
    final FlowResults fResults;

    protected BBlockImpl(SubpFlow pSubpFlow) {
        this.fSubpFlow = pSubpFlow;
        this.fResults = pSubpFlow.results();
        this.flowRoot = this.fResults.flowRoot;
        this.fBBlockNumber = this.fSubpFlow.getNumberOfBBlocks() + 1;
        this.initiateFields();
    }

    protected void initiateFields() {
        this.fPredList = new LinkedList();
        this.fSuccList = new LinkedList();
        this.fPredEdgeList = new LinkedList();
        this.fSuccEdgeList = new LinkedList();
        this.fDominatedChildren = new LinkedList();
        this.fPostdominatedChildren = new LinkedList();
    }

    public IR getIrLink() {
        return this.fIrLink;
    }

    public int getBBlockNumber() {
        return this.fBBlockNumber;
    }

    public FlowResults results() {
        return this.fResults;
    }

    public SetRefReprList getSetRefReprs() {
        this.flowRoot.ioRoot.dbgFlow.print(5, " getSetRefReprs B " + this.getBBlockNumber());
        return (SetRefReprList)this.fResults.get("BBlockSetRefReprs", this);
    }

    public void setSetRefReprs(SetRefReprList pSetRefReprs) {
        this.flowRoot.ioRoot.dbgFlow.print(5, " setSetRefReprs B" + this.getBBlockNumber());
        this.fResults.put("BBlockSetRefReprs", this, pSetRefReprs);
    }

    public List getPredList() {
        return this.fPredList;
    }

    public List getSuccList() {
        return this.fSuccList;
    }

    public Edge getPredEdge(BBlock pFromBBlock) {
        int lIndex = this.fPredList.indexOf(pFromBBlock);
        if (lIndex >= 0) {
            return (Edge)this.fPredEdgeList.get(lIndex);
        }
        return null;
    }

    public Edge getSuccEdge(BBlock pToBBlock) {
        int lIndex = this.fSuccList.indexOf(pToBBlock);
        if (lIndex >= 0) {
            return (Edge)this.fSuccEdgeList.get(lIndex);
        }
        return null;
    }

    public boolean isEntryBlock() {
        return this.fSubpFlow.getEntryBBlock() == this;
    }

    public boolean isEntryBBlock() {
        return this.fSubpFlow.getEntryBBlock() == this;
    }

    public boolean isExitBlock() {
        return this.fSubpFlow.getExitBBlock() == this;
    }

    public boolean isExitBBlock() {
        return this.fSubpFlow.getExitBBlock() == this;
    }

    public List getDomForSubpFlow() {
        return this.fDom;
    }

    public void setDomForSubpFlow(List pDom) {
        this.fDom = pDom;
    }

    public List getStrictDomForSubpFlow() {
        List<BBlock> lStrictDom;
        if (this.fDom instanceof ArrayList) {
            lStrictDom = (LinkedList)((ArrayList)this.fDom).clone();
            lStrictDom.remove(this);
        } else if (this.fDom instanceof LinkedList) {
            lStrictDom = (List)((LinkedList)this.fDom).clone();
            lStrictDom.remove(this);
        } else {
            lStrictDom = new LinkedList();
            for (BBlock lBBlock : this.fDom) {
                if (lBBlock == this) continue;
                lStrictDom.add(lBBlock);
            }
        }
        return lStrictDom;
    }

    public BBlock getImmediateDominatorForSubpFlow() {
        return this.fImmediateDom;
    }

    public void setImmediateDominatorForSubpFlow(BBlock pDominator) {
        this.fImmediateDom = pDominator;
    }

    public List getDominatedChildrenForSubpFlow() {
        return this.fDominatedChildren;
    }

    public void setDominatedChildrenForSubpFlow(List pDominatedChildren) {
        this.fDominatedChildren = pDominatedChildren;
    }

    public List getPostdomForSubpFlow() {
        return this.fPostdom;
    }

    public void setPostdomForSubpFlow(List pPostdom) {
        this.fPostdom = pPostdom;
    }

    public List getStrictPostdomForSubpFlow() {
        List<BBlock> lStrictPostdom;
        if (this.fPostdom instanceof ArrayList) {
            lStrictPostdom = (LinkedList)((ArrayList)this.fPostdom).clone();
            lStrictPostdom.remove(this);
        } else if (this.fPostdom instanceof LinkedList) {
            lStrictPostdom = (List)((LinkedList)this.fPostdom).clone();
            lStrictPostdom.remove(this);
        } else {
            lStrictPostdom = new LinkedList();
            for (BBlock lBBlock : this.fPostdom) {
                if (lBBlock == this) continue;
                lStrictPostdom.add(lBBlock);
            }
        }
        return lStrictPostdom;
    }

    public BBlock getImmediatePostdominatorForSubpFlow() {
        return this.fImmediatePostdom;
    }

    public void setImmediatePostdominatorForSubpFlow(BBlock pPostDominator) {
        this.fImmediatePostdom = pPostDominator;
    }

    public List getPostdominatedChildrenForSubpFlow() {
        return this.fPostdominatedChildren;
    }

    public void setPostdominatedChildrenForSubpFlow(List pPostDominatedChildren) {
        this.fPostdominatedChildren = pPostDominatedChildren;
    }

    public BBlock getNextInDFO() {
        return this.fNextInDFO;
    }

    public void setNextInDFO(BBlock pNext) {
        this.fNextInDFO = pNext;
    }

    public BBlock getNextInInverseDFO() {
        return this.fNextInInverseDFO;
    }

    public void setNextInInveseDFO(BBlock pNext) {
        this.fNextInInverseDFO = pNext;
    }

    public Object getWork() {
        return this.fWork;
    }

    public void setWork(Object pWork) {
        this.fWork = pWork;
    }

    public String toStringShort() {
        StringBuffer lBuffer = new StringBuffer("BBlock " + this.fBBlockNumber + " pred(");
        for (BBlock lBBlock : this.fPredList) {
            lBuffer.append(" " + lBBlock.getBBlockNumber());
        }
        lBuffer.append(") succ( ");
        for (BBlock lBBlock : this.fSuccList) {
            lBuffer.append(" " + lBBlock.getBBlockNumber());
        }
        lBuffer.append(")");
        return lBuffer.toString();
    }

    public String toStringDetail() {
        StringBuffer lBuffer = new StringBuffer();
        lBuffer = lBuffer.append(this.toStringShort()).append(this.getIrLink().toString());
        if (this.isEntryBlock()) {
            lBuffer.append(" isEntry");
        }
        if (this.isExitBlock()) {
            lBuffer.append(" isExit");
        }
        lBuffer.append(" Immediate Dominator for SubpFlow: " + this.getImmediateDominatorForSubpFlow());
        lBuffer.append(" Dominated Children for SubpFlow: " + this.getDominatedChildrenForSubpFlow());
        return lBuffer.toString();
    }

    public void printSubtrees() {
        throw new UnimplementedMethodException();
    }

    public BBlock insertLoopPreheader() {
        throw new UnimplementedMethodException();
    }

    public BBlock insertConditionalInitPart() throws CompileError {
        BlockStmt lConditionalInit;
        Stmt lLoopNode;
        if (this.flowRoot.isHirAnalysis() && (lLoopNode = (Stmt)this.getIrLink()) instanceof LoopStmt && (lConditionalInit = ((LoopStmt)lLoopNode).getConditionalInitPart()) == null) {
            ((LoopStmt)lLoopNode).addToConditionalInitPart(null);
            BlockStmt blockStmt = ((LoopStmt)lLoopNode).getConditionalInitPart();
        }
        return this;
    }

    public void changeSuccEdge(BBlock pBefore, BBlock pAfter) {
        this.deleteFromSuccList(pBefore);
        this.addToSuccList(pAfter);
    }

    public void changePredEdge(BBlock pBefore, BBlock pAfter) {
        this.deleteFromPredList(pBefore);
        this.addToPredList(pAfter);
    }

    public void addEdge(Exp pConditionalExp, BBlock pToBlock) {
        throw new UnimplementedMethodException();
    }

    public void deleteEdge(BBlock pToBlock) {
        throw new UnimplementedMethodException();
    }

    public void deleteBBlock() {
        throw new UnimplementedMethodException();
    }

    public void addToPredList(BBlock pPred) {
        List lList = this.getPredList();
        if (!lList.contains(pPred)) {
            lList.add(pPred);
            int lIndex = lList.indexOf(pPred);
            EdgeImpl lEdge = new EdgeImpl(this.flowRoot, pPred, this);
            this.fPredEdgeList.add(lIndex, lEdge);
            ((BBlockImpl)pPred).addToSuccList0(this, lEdge);
        }
    }

    public void addToSuccList(BBlock pSucc) {
        List lList = this.getSuccList();
        if (!lList.contains(pSucc)) {
            lList.add(pSucc);
            int lIndex = lList.indexOf(pSucc);
            EdgeImpl lEdge = new EdgeImpl(this.flowRoot, this, pSucc);
            this.fSuccEdgeList.add(lIndex, lEdge);
            ((BBlockImpl)pSucc).addToPredList0(this, lEdge);
        }
    }

    private void addToPredList0(BBlock pPred, Edge pEdge) {
        List lList = this.getPredList();
        if (!lList.contains(pPred)) {
            lList.add(pPred);
            int lIndex = lList.indexOf(pPred);
            this.fPredEdgeList.add(lIndex, pEdge);
        }
    }

    private void addToSuccList0(BBlock pSucc, Edge pEdge) {
        List lList = this.getSuccList();
        if (!lList.contains(pSucc)) {
            lList.add(pSucc);
            int lIndex = lList.indexOf(pSucc);
            this.fSuccEdgeList.add(lIndex, pEdge);
        }
    }

    public void deleteFromPredList(BBlock pPred) {
        List lList = this.getPredList();
        if (lList.contains(pPred)) {
            int lIndex = lList.indexOf(pPred);
            lList.remove(pPred);
            this.fPredEdgeList.remove(lIndex);
            ((BBlockImpl)pPred).deleteFromSuccList0(this);
        }
    }

    public void deleteFromSuccList(BBlock pSucc) {
        List lList = this.getSuccList();
        if (lList.contains(pSucc)) {
            int lIndex = lList.indexOf(pSucc);
            lList.remove(pSucc);
            this.fSuccEdgeList.remove(lIndex);
            ((BBlockImpl)pSucc).deleteFromPredList0(this);
        }
    }

    private void deleteFromPredList0(BBlock pPred) {
        List lList = this.getPredList();
        if (lList.contains(pPred)) {
            int lIndex = lList.indexOf(pPred);
            lList.remove(pPred);
            this.fPredEdgeList.remove(lIndex);
        }
    }

    public void deleteFromSuccList0(BBlock pSucc) {
        List lList = this.getSuccList();
        if (lList.contains(pSucc)) {
            int lIndex = lList.indexOf(pSucc);
            lList.remove(pSucc);
            this.fSuccEdgeList.remove(lIndex);
        }
    }

    public void fuseSuccessor(BBlock pToBlock) {
        List lSuccListOfSucc = pToBlock.getSuccList();
        for (BBlock lSuccOfSucc : lSuccListOfSucc) {
            this.addToSuccList(lSuccOfSucc);
            ((BBlockImpl)lSuccOfSucc).deleteFromPredList0(pToBlock);
        }
        this.deleteFromSuccList(pToBlock);
    }

    public SubpFlow getSubpFlow() {
        return this.fSubpFlow;
    }

    public String toString() {
        return this.toStringVeryShort();
    }

    public String toStringVeryShort() {
        return "BBlock " + this.getBBlockNumber();
    }

    public DefVector getDef() {
        return (DefVector)this.fResults.get("Def", this);
    }

    public void setDef(DefVector pVect) {
        this.fResults.put("Def", this, pVect);
    }

    public DefVector getDDef() {
        return (DefVector)this.fResults.get("DDef", this);
    }

    public void setDDef(DefVector pVect) {
        this.fResults.put("DDef", this, pVect);
    }

    public DefVector getPDef() {
        return (DefVector)this.fResults.get("PDef", this);
    }

    public void setPDef(DefVector pVect) {
        this.fResults.put("PDef", this, pVect);
    }

    public DefVector getDKill() {
        return (DefVector)this.fResults.get("DKill", this);
    }

    public void setDKill(DefVector pVect) {
        this.fResults.put("DKill", this, pVect);
    }

    public DefVector getPKill() {
        return (DefVector)this.fResults.get("PKill", this);
    }

    public void setPKill(DefVector pVect) {
        this.fResults.put("PKill", this, pVect);
    }

    public DefVector getReach() {
        return (DefVector)this.fResults.get("Reach", this);
    }

    public void setReach(DefVector pVect) {
        this.fResults.put("Reach", this, pVect);
    }

    public DefVector getPReach() {
        return (DefVector)this.fResults.get("PReach", this);
    }

    public void setPReach(DefVector pVect) {
        this.fResults.put("PReach", this, pVect);
    }

    public void setDReach(DefVector pVect) {
        this.fResults.put("DReach", this, pVect);
    }

    public FlowAnalSymVector getDDefined() {
        return (FlowAnalSymVector)this.fResults.get("DDefined", this);
    }

    public void setDDefined(FlowAnalSymVector pVect) {
        this.fResults.put("DDefined", this, pVect);
    }

    public FlowAnalSymVector getPDefined() {
        return (FlowAnalSymVector)this.fResults.get("PDefined", this);
    }

    public void setPDefined(FlowAnalSymVector pVect) {
        this.fResults.put("PDefined", this, pVect);
    }

    public FlowAnalSymVector getPUsed() {
        return (FlowAnalSymVector)this.fResults.get("PUsed", this);
    }

    public void setPUsed(FlowAnalSymVector pVect) {
        this.fResults.put("PUsed", this, pVect);
    }

    public FlowAnalSymVector getDExposed() {
        return (FlowAnalSymVector)this.fResults.get("DExposed", this);
    }

    public void setDExposed(FlowAnalSymVector pVect) {
        this.fResults.put("DExposed", this, pVect);
    }

    public FlowAnalSymVector getPExposed() {
        return (FlowAnalSymVector)this.fResults.get("PExposed", this);
    }

    public void setPExposed(FlowAnalSymVector pVect) {
        this.fResults.put("PExposed", this, pVect);
    }

    public ExpVector getDEGen() {
        return (ExpVector)this.fResults.get("DEGen", this);
    }

    public void setDEGen(ExpVector pVect) {
        this.fResults.put("DEGen", this, pVect);
    }

    public ExpVector getPEKill() {
        return (ExpVector)this.fResults.get("PEKill", this);
    }

    public void setPEKill(ExpVector pVect) {
        this.fResults.put("PEKill", this, pVect);
    }

    public ExpVector getDAvailIn() {
        return (ExpVector)this.fResults.get("DAvailIn", this);
    }

    public void setDAvailIn(ExpVector pVect) {
        this.fResults.put("DAvailIn", this, pVect);
    }

    public ExpVector getDAvailOut() {
        return (ExpVector)this.fResults.get("DAvailOut", this);
    }

    public void setDAvailOut(ExpVector pVect) {
        this.fResults.put("DAvailOut", this, pVect);
    }

    public FlowAnalSymVector getPLiveIn() {
        return (FlowAnalSymVector)this.fResults.get("PLiveIn", this);
    }

    public void setPLiveIn(FlowAnalSymVector pVect) {
        this.fResults.put("PLiveIn", this, pVect);
    }

    public FlowAnalSymVector getPLiveOut() {
        return (FlowAnalSymVector)this.fResults.get("PLiveOut", this);
    }

    public void setPLiveOut(FlowAnalSymVector pVect) {
        this.fResults.put("PLiveOut", this, pVect);
    }

    public FlowAnalSymVector getDDefIn() {
        return (FlowAnalSymVector)this.fResults.get("DDefIn", this);
    }

    public void setDDefIn(FlowAnalSymVector pVect) {
        this.fResults.put("DDefIn", this, pVect);
    }

    public FlowAnalSymVector getDDefOut() {
        return (FlowAnalSymVector)this.fResults.get("DDefOut", this);
    }

    public void setDDefOut(FlowAnalSymVector pVect) {
        this.fResults.put("DDefOut", this, pVect);
    }

    public boolean isDDef(SetRefRepr pSetRefRepr) {
        return this.getDef().isSet(this.getSubpFlow().getSetRefReprs().indexOf(pSetRefRepr));
    }

    public boolean isPDef(SetRefRepr pSetRefRepr) {
        return this.getPDef().isSet(this.getSubpFlow().getSetRefReprs().indexOf(pSetRefRepr));
    }

    public boolean isDKill(SetRefRepr pSetRefRepr) {
        return this.getDKill().isSet(this.getSubpFlow().getSetRefReprs().indexOf(pSetRefRepr));
    }

    public boolean isPKill(SetRefRepr pSetRefRepr) {
        return this.getReach().isSet(this.getSubpFlow().getSetRefReprs().indexOf(pSetRefRepr));
    }

    public boolean isPReach(SetRefRepr pSetRefRepr) {
        return this.getPReach().isSet(this.getSubpFlow().getSetRefReprs().indexOf(pSetRefRepr));
    }

    public boolean isDDefined(Sym pSym) {
        return this.getDDefined().isSet(this.getSubpFlow().getSymIndexTable().indexOf(pSym));
    }

    public boolean isPDefined(Sym pSym) {
        return this.getPDefined().isSet(this.getSubpFlow().getSymIndexTable().indexOf(pSym));
    }

    public boolean isDUsed(Sym pSym) {
        return this.getDUsed().isSet(this.getSubpFlow().getSymIndexTable().indexOf(pSym));
    }

    public boolean isPUsed(Sym pSym) {
        return this.getPUsed().isSet(this.getSubpFlow().getSymIndexTable().indexOf(pSym));
    }

    public boolean isDExposed(Sym pSym) {
        return this.getDExposed().isSet(this.getSubpFlow().getSymIndexTable().indexOf(pSym));
    }

    public boolean isPExposed(Sym pSym) {
        return this.getPExposed().isSet(this.getSubpFlow().getSymIndexTable().indexOf(pSym));
    }

    public boolean isDEGen(FlowExpId pExpId) {
        int lInx = pExpId.getIndex();
        return this.getDEGen().isSet(lInx);
    }

    public boolean isPEKill(FlowExpId pExpId) {
        int lInx = pExpId.getIndex();
        return this.getPEKill().isSet(lInx);
    }

    public boolean isDAvailIn(FlowExpId pExpId) {
        int lInx = pExpId.getIndex();
        return this.getDAvailIn().isSet(lInx);
    }

    public boolean isDAvailOut(FlowExpId pExpId) {
        int lInx = pExpId.getIndex();
        return this.getDAvailOut().isSet(lInx);
    }

    public boolean isPLiveIn(Sym pSym) {
        return this.getPLiveIn().isSet(this.getSubpFlow().getSymIndexTable().indexOf(pSym));
    }

    public boolean isPLiveOut(Sym pSym) {
        return this.getPLiveOut().isSet(this.getSubpFlow().getSymIndexTable().indexOf(pSym));
    }

    public boolean isDDefIn(Sym pSym) {
        return this.getDDefIn().isSet(this.getSubpFlow().getSymIndexTable().indexOf(pSym));
    }

    public boolean isDDefOut(Sym pSym) {
        return this.getDDefOut().isSet(this.getSubpFlow().getSymIndexTable().indexOf(pSym));
    }

    public FlowAnalSymVector getDUsed() {
        return (FlowAnalSymVector)this.fResults.get("DUsed", this);
    }

    public void setDUsed(FlowAnalSymVector pVect) {
        this.fResults.put("DUsed", this, pVect);
    }
}

