/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.BBlockHir;
import coins.aflow.BBlockNodeIterator;
import coins.aflow.Flow;
import coins.ir.IR;
import coins.ir.hir.HIR;
import coins.ir.hir.HIR_Impl;
import coins.ir.hir.LabeledStmt;

class BBlockHirNodeIteratorImpl
implements BBlockNodeIterator {
    private HIR fNext = null;
    static final HIR EOB = new HIR_Impl();

    BBlockHirNodeIteratorImpl(BBlockHir pBBlock) {
        this.fNext = (LabeledStmt)pBBlock.getIrLink();
    }

    public boolean hasNext() {
        return this.fNext != EOB && this.fNext != null;
    }

    public IR next() {
        if (this.fNext == null) {
            return null;
        }
        HIR lCurrent = this.fNext;
        HIR lHIR = this.fNext;
        boolean lOpCode = false;
        HIR lHIRNext = BBlockHirNodeIteratorImpl.tryNext(lHIR);
        if (lHIRNext == null) {
            lHIRNext = BBlockHirNodeIteratorImpl.tryNeitherDescendantsNorAncestors(lHIR);
        }
        if (lHIRNext instanceof LabeledStmt) {
            lHIRNext = EOB;
        }
        this.fNext = lHIR = lHIRNext;
        return lCurrent;
    }

    public IR getNextExecutableNode() {
        HIR lHIR;
        while (!Flow.isExecutable(lHIR = (HIR)this.next()) && lHIR != null && lHIR != EOB) {
        }
        if (lHIR == EOB) {
            lHIR = null;
        }
        return lHIR;
    }

    private static HIR tryNext(HIR pHIR) {
        int i = 1;
        for (i = 1; i <= pHIR.getChildCount(); ++i) {
            HIR lNext = (HIR)pHIR.getChild(i);
            if (lNext == null) continue;
            return lNext;
        }
        return BBlockHirNodeIteratorImpl.tryNeitherDescendantsNorAncestors(pHIR);
    }

    private static HIR tryNeitherDescendantsNorAncestors(HIR pHIR) {
        HIR lNext = pHIR.getNextStmt();
        if (lNext != null) {
            return lNext;
        }
        int lChildNumber = pHIR.getChildNumber();
        HIR lParent = (HIR)pHIR.getParent();
        if (lParent == null) {
            return EOB;
        }
        int lChildCount = lParent.getChildCount();
        while (0 < lChildNumber && lChildNumber < lChildCount) {
            if ((lNext = (HIR)lParent.getChild(++lChildNumber)) == null) continue;
            return lNext;
        }
        return BBlockHirNodeIteratorImpl.tryNeitherDescendantsNorAncestors(lParent);
    }
}

