/*
 * Decompiled with CFR 0.152.
 */
package coins;

import coins.SymRoot;
import coins.sym.Const;
import coins.sym.FloatConst;
import coins.sym.IntConst;
import coins.sym.Subp;
import coins.sym.Type;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class SourceLanguage {
    public final SymRoot symRoot;
    public Set functionsWithoutSideEffect;
    private boolean evalFloat = false;
    private static final BigInteger longMask = BigInteger.valueOf(-1L).shiftLeft(64).not();
    public static final int[][] REDEFINABLE = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    public static final int[][] CONVERTIBLE = new int[][]{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    public static final boolean subscriptWithIndex = false;

    public SourceLanguage(SymRoot pSymRoot) {
        this.symRoot = pSymRoot;
        String hiropt = this.symRoot.ioRoot.getCompileSpecification().getCoinsOptions().getArg("hirOpt");
        if (hiropt != null) {
            StringTokenizer st = new StringTokenizer(hiropt, "/");
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals("evalFloat")) continue;
                this.evalFloat = true;
            }
        }
        this.initiateFunctionsWithoutSideEffect();
    }

    public static boolean isC() {
        return true;
    }

    public static boolean isFortran() {
        return false;
    }

    public String makeStringBody(String pSourceString) {
        return this.makeStringBodyForC(pSourceString);
    }

    public static String makeStringBodyStatic(String pSourceString) {
        return SourceLanguage.makeStringBodyForCstatic(pSourceString);
    }

    public String makeStringBodyForC(String pCstring) {
        return pCstring;
    }

    public static String makeStringBodyForCstatic(String pCstring) {
        StringBuffer lString = new StringBuffer();
        int lLength = pCstring.length();
        if (pCstring == null || lLength <= 0) {
            return "".intern();
        }
        if (lLength == 1) {
            return pCstring.intern();
        }
        for (int i = 0; i < lLength; ++i) {
            char lChar = pCstring.charAt(i);
            if (lChar == '\\') {
                lChar = pCstring.charAt(++i);
                switch (lChar) {
                    case 'b': {
                        lString.append('\b');
                        break;
                    }
                    case 'f': {
                        lString.append('\f');
                        break;
                    }
                    case 'n': {
                        lString.append('\n');
                        break;
                    }
                    case 'r': {
                        lString.append('\r');
                        break;
                    }
                    case 't': {
                        lString.append('\t');
                        break;
                    }
                    case '\\': {
                        lString.append('\\');
                        break;
                    }
                    case '\'': {
                        lString.append('\'');
                        break;
                    }
                    case '\"': {
                        lString.append('\"');
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        int lCharCode = Character.digit(lChar, 8);
                        lChar = pCstring.charAt(++i);
                        lCharCode = lCharCode * 8 + Character.digit(lChar, 8);
                        lChar = pCstring.charAt(++i);
                        lCharCode = lCharCode * 8 + Character.digit(lChar, 8);
                        lString.append((char)lCharCode);
                        break;
                    }
                    case 'x': {
                        lChar = pCstring.charAt(++i);
                        int lCharCode = Character.digit(lChar, 16);
                        lChar = pCstring.charAt(++i);
                        lCharCode = lCharCode * 16 + Character.digit(lChar, 16);
                        lString.append((char)lCharCode);
                        break;
                    }
                    default: {
                        lString.append(lChar);
                        break;
                    }
                }
                continue;
            }
            lString.append(lChar);
        }
        return lString.toString().intern();
    }

    public String makeCstring(String pStringBody) {
        return SourceLanguage.makeCstringStatic(pStringBody);
    }

    public static String makeCstringStatic(String pStringBody) {
        StringBuffer lString = new StringBuffer();
        int lLength = pStringBody.length();
        if (pStringBody == null || lLength <= 0) {
            return "\"\"";
        }
        if (lLength == 1) {
            return pStringBody.intern();
        }
        lString.append("\"");
        block13: for (int i = 0; i < lLength; ++i) {
            char lChar = pStringBody.charAt(i);
            switch (lChar) {
                case '\u0007': {
                    lString.append('\u0007');
                    continue block13;
                }
                case '\b': {
                    lString.append("\\b");
                    continue block13;
                }
                case '\f': {
                    lString.append("\\f");
                    continue block13;
                }
                case '\n': {
                    lString.append("\\n");
                    continue block13;
                }
                case '\r': {
                    lString.append("\\r");
                    continue block13;
                }
                case '\t': {
                    lString.append("\\t");
                    continue block13;
                }
                case '\u000b': {
                    lString.append('\u000b');
                    continue block13;
                }
                case '\\': {
                    lString.append("\\\\");
                    continue block13;
                }
                case '?': {
                    lString.append("\\?");
                    continue block13;
                }
                case '\'': {
                    lString.append("\\'");
                    continue block13;
                }
                case '\"': {
                    lString.append("\\\"");
                    continue block13;
                }
                default: {
                    lString.append(lChar);
                }
            }
        }
        lString.append("\"");
        return lString.toString().intern();
    }

    public String makeCstringWithTrailing0(String pStringBody) {
        return SourceLanguage.makeCstringWithTrailing0static(pStringBody);
    }

    public static String makeCstringWithTrailing0static(String pStringBody) {
        String lResult;
        String lString = SourceLanguage.makeCstringStatic(pStringBody);
        int lLeng = lString.length();
        if (lLeng > 2 && lString.charAt(0) == '\"' && lString.charAt(lLeng - 1) == '\"') {
            lResult = lString.substring(1, lLeng - 1);
            lResult = "\"" + lResult + "\\0\"";
        } else {
            lResult = "\"\\0\"";
        }
        return lResult.intern();
    }

    public String getSourceStringConst(String pStringBody) {
        return SourceLanguage.makeCstringWithTrailing0static(pStringBody);
    }

    public int getStringLength(String pStringBody) {
        return pStringBody.length() + 1;
    }

    public static String makeIntConstString(String pInternedConstString, Type pType) {
        String lConstString = pInternedConstString;
        int lEndPos = lConstString.length() - 1;
        if (pType != null && Character.isDigit(lConstString.charAt(lEndPos))) {
            switch (pType.getTypeKind()) {
                case 9: {
                    lConstString = (lConstString + "U").intern();
                    break;
                }
                case 10: {
                    lConstString = (lConstString + "U").intern();
                    break;
                }
                case 5: {
                    lConstString = (lConstString + "L").intern();
                    break;
                }
                case 11: {
                    lConstString = (lConstString + "UL").intern();
                    break;
                }
                case 6: {
                    lConstString = (lConstString + "LL").intern();
                    break;
                }
                case 12: {
                    lConstString = (lConstString + "ULL").intern();
                    break;
                }
            }
        }
        return lConstString;
    }

    public static String getPureIntString(String pInternedName) {
        String lConstString = pInternedName;
        int lEndPos = lConstString.length() - 1;
        if (!Character.isDigit(lConstString.charAt(lEndPos))) {
            if (lConstString.charAt(lEndPos) == 'L' || lConstString.charAt(lEndPos) == 'l') {
                --lEndPos;
            }
            if (lConstString.charAt(lEndPos) == 'L' || lConstString.charAt(lEndPos) == 'l') {
                --lEndPos;
            }
            if (lConstString.charAt(lEndPos) == 'U' || lConstString.charAt(lEndPos) == 'u') {
                --lEndPos;
            }
            lConstString = lConstString.substring(0, lEndPos + 1).intern();
        }
        return lConstString;
    }

    public static String makeFloatConstString(String pInternedConstString, Type pType) {
        String lConstString = pInternedConstString;
        int lEndPos = lConstString.length() - 1;
        char lLastChar = lConstString.charAt(lEndPos);
        if (pType != null && (Character.isDigit(lLastChar) || lLastChar == '.')) {
            if (pType.getTypeKind() == 16) {
                lConstString = (lConstString + "F").intern();
            } else if (pType.getTypeKind() == 18) {
                lConstString = (lConstString + "D").intern();
            }
        }
        return lConstString;
    }

    public static String getPureFloatString(String pInternedName) {
        String lConstString = pInternedName;
        int lEndPos = lConstString.length() - 1;
        char lLastChar = lConstString.charAt(lEndPos);
        if (!Character.isDigit(lLastChar) && lLastChar != '.') {
            if (lLastChar == 'F' || lLastChar == 'D') {
                --lEndPos;
            }
            lConstString = lConstString.substring(0, lEndPos + 1).intern();
        }
        return lConstString;
    }

    public Type baseTypeOrigin(Type pBaseType) {
        Type lOrigin;
        switch (pBaseType.getTypeKind()) {
            case 1: {
                lOrigin = this.symRoot.typeInt;
                break;
            }
            case 7: {
                lOrigin = this.symRoot.typeInt;
                break;
            }
            case 8: {
                lOrigin = this.symRoot.typeU_Int;
                break;
            }
            case 13: 
            case 14: {
                lOrigin = this.symRoot.typeU_Long;
                break;
            }
            case 22: {
                lOrigin = this.symRoot.typeU_Long;
                break;
            }
            case 21: {
                lOrigin = this.symRoot.typeInt;
                break;
            }
            default: {
                lOrigin = pBaseType;
            }
        }
        return lOrigin;
    }

    public boolean isMainProgram(Subp pSubp) {
        return pSubp != null && pSubp.getName().intern() == "main".intern();
    }

    public Const evaluateNeg(Const c1) {
        Type t = c1.getSymType();
        if (t.isInteger()) {
            return this.newIntConst(-c1.longValue(), this.getIpType(t));
        }
        return this.newFloatConst(-c1.doubleValue(), t);
    }

    public Const evaluateAdd(Const c1, Const c2) {
        Type t = this.getUacType(c1, c2);
        if (t != null) {
            if (t.isInteger()) {
                return this.newIntConst(c1.longValue() + c2.longValue(), t);
            }
            if (this.evalFloat) {
                return this.newFloatConst(c1.doubleValue() + c2.doubleValue(), t);
            }
        }
        return null;
    }

    public Const evaluateSub(Const c1, Const c2) {
        Type t = this.getUacType(c1, c2);
        if (t != null) {
            if (t.isInteger()) {
                return this.newIntConst(c1.longValue() - c2.longValue(), t);
            }
            if (this.evalFloat) {
                return this.newFloatConst(c1.doubleValue() - c2.doubleValue(), t);
            }
        }
        return null;
    }

    public Const evaluateMult(Const c1, Const c2) {
        Type t = this.getUacType(c1, c2);
        if (t != null) {
            if (t.isInteger()) {
                return this.newIntConst(c1.longValue() * c2.longValue(), t);
            }
            if (this.evalFloat) {
                return this.newFloatConst(c1.doubleValue() * c2.doubleValue(), t);
            }
        }
        return null;
    }

    public Const evaluateDiv(Const c1, Const c2) {
        if (c2.doubleValue() == 0.0) {
            return null;
        }
        Type t = this.getUacType(c1, c2);
        if (t != null) {
            if (t.isInteger()) {
                return this.newIntConst(this.newBigInteger(c1).divide(this.newBigInteger(c2)).longValue(), t);
            }
            if (this.evalFloat) {
                return this.newFloatConst(c1.doubleValue() / c2.doubleValue(), t);
            }
        }
        return null;
    }

    public Const evaluateMod(Const c1, Const c2) {
        if (c2.doubleValue() == 0.0) {
            return null;
        }
        Type t = this.getUacType(c1, c2);
        if (t != null && t.isInteger()) {
            return this.newIntConst(this.newBigInteger(c1).remainder(this.newBigInteger(c2)).longValue(), t);
        }
        return null;
    }

    public Const evaluateNot(Const c1) {
        Type t = c1.getSymType();
        if (t.isInteger()) {
            return this.newIntConst(c1.longValue() ^ 0xFFFFFFFFFFFFFFFFL, this.getIpType(t));
        }
        return null;
    }

    public Const evaluateShiftLl(Const c1, Const c2) {
        Type t = c1.getSymType();
        if (t.isInteger() && c2.getSymType().isInteger()) {
            return this.newIntConst(c1.longValue() << (int)c2.longValue(), this.getIpType(t));
        }
        return null;
    }

    public Const evaluateShiftRl(Const c1, Const c2) {
        Type t = c1.getSymType();
        if (t.isInteger() && c2.getSymType().isInteger()) {
            return this.newIntConst(c1.longValue() >>> (int)c2.longValue(), this.getIpType(t));
        }
        return null;
    }

    public Const evaluateShiftRa(Const c1, Const c2) {
        Type t = c1.getSymType();
        if (t.isInteger() && c2.getSymType().isInteger()) {
            return this.newIntConst(c1.longValue() >> (int)c2.longValue(), this.getIpType(t));
        }
        return null;
    }

    public Const evaluateAnd(Const c1, Const c2) {
        Type t = this.getUacType(c1, c2);
        if (t != null && t.isInteger()) {
            return this.newIntConst(c1.longValue() & c2.longValue(), t);
        }
        return null;
    }

    public Const evaluateOr(Const c1, Const c2) {
        Type t = this.getUacType(c1, c2);
        if (t != null && t.isInteger()) {
            return this.newIntConst(c1.longValue() | c2.longValue(), t);
        }
        return null;
    }

    public Const evaluateXor(Const c1, Const c2) {
        Type t = this.getUacType(c1, c2);
        if (t != null && t.isInteger()) {
            return this.newIntConst(c1.longValue() ^ c2.longValue(), t);
        }
        return null;
    }

    public Const evaluateCast(Type t, Const c) {
        if (t.getUnqualifiedType() == c.getSymType().getUnqualifiedType()) {
            return c;
        }
        switch (t.getTypeKind()) {
            case 1: {
                switch (c.getSymType().getTypeKind()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 21: {
                        return c.doubleValue() != 0.0 ? this.symRoot.boolConstTrue : this.symRoot.boolConstFalse;
                    }
                }
                return null;
            }
            case 21: {
                t = this.symRoot.typeInt;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                switch (c.getSymType().getTypeKind()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 21: {
                        return this.newIntConst(c.longValue(), t);
                    }
                }
                return null;
            }
            case 16: 
            case 17: 
            case 18: {
                switch (c.getSymType().getTypeKind()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 21: {
                        return this.newFloatConst(c.doubleValue(), t);
                    }
                }
                return null;
            }
        }
        return null;
    }

    public int evaluateCondition(Const c) {
        if (c.getSymType().getTypeRank() > 0) {
            return c.doubleValue() != 0.0 ? 1 : 0;
        }
        return Integer.MIN_VALUE;
    }

    public int evaluateRelation(Const c1, Const c2) {
        Type t = this.getUacType(c1, c2);
        if (t != null) {
            if (t.isInteger()) {
                return this.newBigInteger(c1).compareTo(this.newBigInteger(c2));
            }
            return c1.doubleValue() < c2.doubleValue() ? -1 : (c1.doubleValue() == c2.doubleValue() ? 0 : 1);
        }
        return Integer.MIN_VALUE;
    }

    private Type getUacType(Const c1, Const c2) {
        Type t1 = c1.getSymType();
        Type t2 = c2.getSymType();
        if (t1.getTypeRank() < t2.getTypeRank()) {
            Type t = t1;
            t1 = t2;
            t2 = t;
        }
        if (t2.getTypeRank() <= 0) {
            return null;
        }
        if (t1.getTypeRank() >= this.symRoot.typeFloat.getTypeRank()) {
            return t1.getUnqualifiedType();
        }
        if (t1.getTypeRank() >= this.symRoot.typeInt.getTypeRank()) {
            if (t1.getSizeValue() == t2.getSizeValue() && (t1.isUnsigned() || t2.isUnsigned())) {
                switch (t1.getTypeKind()) {
                    case 3: {
                        return this.symRoot.typeU_Short;
                    }
                    case 4: {
                        return this.symRoot.typeU_Int;
                    }
                    case 5: {
                        return this.symRoot.typeU_Long;
                    }
                    case 6: {
                        return this.symRoot.typeU_LongLong;
                    }
                    case 7: {
                        return this.symRoot.typeU_Char;
                    }
                    case 8: {
                        return this.symRoot.typeU_Char;
                    }
                    case 9: {
                        return this.symRoot.typeU_Short;
                    }
                    case 10: {
                        return this.symRoot.typeU_Int;
                    }
                    case 11: {
                        return this.symRoot.typeU_Long;
                    }
                    case 12: {
                        return this.symRoot.typeU_LongLong;
                    }
                }
                return null;
            }
            return t1.getUnqualifiedType();
        }
        if (t1.getSizeValue() >= this.symRoot.typeInt.getSizeValue() && t1.isUnsigned() || t2.getSizeValue() >= this.symRoot.typeInt.getSizeValue() && t2.isUnsigned()) {
            return this.symRoot.typeU_Int;
        }
        return this.symRoot.typeInt;
    }

    private Type getIpType(Type t) {
        return t.getTypeRank() < this.symRoot.typeInt.getTypeRank() ? this.symRoot.typeInt : t;
    }

    private IntConst newIntConst(long v, Type t) {
        long unusedbits = 64L - 8L * t.getSizeValue();
        if (t.isUnsigned()) {
            return this.symRoot.sym.intConst(v << (int)unusedbits >>> (int)unusedbits, t);
        }
        return this.symRoot.sym.intConst(v << (int)unusedbits >> (int)unusedbits, t);
    }

    private FloatConst newFloatConst(double v, Type t) {
        if (t.getTypeKind() == 16) {
            return this.symRoot.sym.floatConst((float)v, t);
        }
        return this.symRoot.sym.floatConst(v, t);
    }

    private BigInteger newBigInteger(Const c) {
        long unusedbits = 64L - 8L * c.getSymType().getSizeValue();
        if (unusedbits == 0L) {
            if (c.getSymType().isUnsigned()) {
                return BigInteger.valueOf(c.longValue()).and(longMask);
            }
            return BigInteger.valueOf(c.longValue());
        }
        if (c.getSymType().isUnsigned()) {
            return BigInteger.valueOf(c.longValue() << (int)unusedbits >>> (int)unusedbits);
        }
        return BigInteger.valueOf(c.longValue() << (int)unusedbits >> (int)unusedbits);
    }

    public void initiateFunctionsWithoutSideEffect() {
        this.functionsWithoutSideEffect = new HashSet();
        this.functionsWithoutSideEffect.add("sin");
        this.functionsWithoutSideEffect.add("cos");
        this.functionsWithoutSideEffect.add("tan");
        this.functionsWithoutSideEffect.add("asin");
        this.functionsWithoutSideEffect.add("acos");
        this.functionsWithoutSideEffect.add("atan");
        this.functionsWithoutSideEffect.add("sinh");
        this.functionsWithoutSideEffect.add("cosh");
        this.functionsWithoutSideEffect.add("tanh");
        this.functionsWithoutSideEffect.add("log");
        this.functionsWithoutSideEffect.add("exp");
        this.functionsWithoutSideEffect.add("pow");
        this.functionsWithoutSideEffect.add("sqrt");
    }

    public Set getFunctionsWithoutSideEffect() {
        return this.functionsWithoutSideEffect;
    }
}

