/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.print;

import net.wasamon.mjlib.print.FormatException;

public class PrintFormat {
    public static final String version = "PrintFormat 0.2";
    public static final String author = "Takefumi MIYOSHI (miyoshi@ae.titech.ac.jp)";
    public static final String copyright = "(c) 2003/06/27 All right reserved.";
    public static final char STRING = 's';
    public static final char DECIMALSTRING = 'd';
    public static final char CHARACTER = 'c';
    public static final char HEXSTRING = 'x';
    public static final char OCTALSTRING = 'o';
    public static final char BINARYSTRING = 'b';
    public static final char PARCENT = '%';

    private static String toString(Object object, char c) throws FormatException {
        if (object instanceof String) {
            return PrintFormat.toString((String)object, c);
        }
        if (object instanceof Integer) {
            return PrintFormat.toString((Integer)object, c);
        }
        if (object instanceof Short) {
            return PrintFormat.toString((Short)object, c);
        }
        if (object instanceof Long) {
            return PrintFormat.toString((Long)object, c);
        }
        if (object instanceof Byte) {
            return PrintFormat.toString((Byte)object, c);
        }
        return object.toString();
    }

    private static String toString(String string, char c) throws FormatException {
        String string2 = null;
        switch (c) {
            case 's': {
                string2 = string.toString();
                break;
            }
            case 'd': {
                try {
                    string2 = Integer.decode(string).toString();
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FormatException();
                }
            }
            case 'x': {
                try {
                    string2 = Integer.toHexString(Integer.decode(string));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FormatException();
                }
            }
            case 'o': {
                try {
                    string2 = Integer.toOctalString(Integer.decode(string));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FormatException();
                }
            }
            case 'b': {
                try {
                    string2 = Integer.toBinaryString(Integer.decode(string));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FormatException();
                }
            }
        }
        if (string2 == null) {
            throw new FormatException();
        }
        return string2;
    }

    private static String toString(Integer n, char c) throws FormatException {
        String string = null;
        switch (c) {
            case 'd': {
                string = n.toString();
                break;
            }
            case 'x': {
                string = Integer.toHexString(n);
                break;
            }
            case 'b': {
                string = Integer.toBinaryString(n);
            }
        }
        if (string == null) {
            throw new FormatException();
        }
        return string;
    }

    private static String toString(Byte by, char c) throws FormatException {
        String string = null;
        int n = 0;
        switch (c) {
            case 'd': {
                string = by.toString();
                break;
            }
            case 'x': {
                n = by.intValue();
                string = Integer.toHexString(n);
                if (n >= 0) break;
                string = string.substring(6, 8);
                break;
            }
            case 'b': {
                n = by.intValue();
                string = Integer.toBinaryString(n);
                if (n >= 0) break;
                string = string.substring(24, 32);
            }
        }
        if (string == null) {
            throw new FormatException();
        }
        return string;
    }

    private static String toString(Long l, char c) throws FormatException {
        String string = null;
        switch (c) {
            case 'd': {
                string = l.toString();
                break;
            }
            case 'x': {
                string = Long.toHexString(l);
                break;
            }
            case 'b': {
                string = Long.toBinaryString(l);
            }
        }
        if (string == null) {
            throw new FormatException();
        }
        return string;
    }

    private static String toString(Short s, char c) throws FormatException {
        String string = null;
        switch (c) {
            case 'd': {
                string = s.toString();
                break;
            }
            case 'x': {
                string = Integer.toHexString(s.shortValue());
                break;
            }
            case 'b': {
                string = Integer.toBinaryString(s.shortValue());
            }
        }
        if (string == null) {
            throw new FormatException();
        }
        return string;
    }

    private static String makeString(Object object, int n, char c, boolean bl) throws FormatException {
        StringBuffer stringBuffer = new StringBuffer(0);
        String string = PrintFormat.toString(object, c);
        if (bl) {
            for (int i = 0; i < n - string.length(); ++i) {
                if (c == 'd' || c == 'b' || c == 'x' || c == 'o') {
                    stringBuffer.append('0');
                    continue;
                }
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string);
            for (int i = 0; i < n - string.length(); ++i) {
                stringBuffer.append(' ');
            }
        }
        if (string == null) {
            throw new FormatException();
        }
        return stringBuffer.toString();
    }

    private static int convert(String string, int n, Object[] objectArray, int n2, StringBuffer stringBuffer) throws FormatException {
        int n3 = n + 1;
        boolean bl = false;
        StringBuffer stringBuffer2 = new StringBuffer(0);
        char c = string.charAt(n3);
        if (c == '0') {
            bl = true;
        }
        while (n3 < string.length()) {
            c = string.charAt(n3);
            if (Character.isDigit(c)) {
                stringBuffer2.append(c);
                ++n3;
                continue;
            }
            ++n3;
            if (c == '%') {
                stringBuffer.append('%');
            } else {
                int n4 = 0;
                if (!"".equals(stringBuffer2.toString())) {
                    try {
                        n4 = Integer.parseInt(stringBuffer2.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new FormatException();
                    }
                }
                String string2 = PrintFormat.makeString(objectArray[n2], n4, c, bl);
                stringBuffer.append(string2);
            }
            return n3;
        }
        throw new FormatException();
    }

    public static String print(String string, int n) throws FormatException {
        Integer n2 = new Integer(n);
        Object[] objectArray = new Object[]{n2};
        return PrintFormat.print(string, objectArray);
    }

    public static String print(String string, String string2) throws FormatException {
        Object[] objectArray = new Object[]{string2};
        return PrintFormat.print(string, objectArray);
    }

    public static String print(String string, String string2, String string3) throws FormatException {
        Object[] objectArray = new Object[]{string2, string3};
        return PrintFormat.print(string, objectArray);
    }

    public static String print(String string, byte by) throws FormatException {
        Byte by2 = new Byte(by);
        Object[] objectArray = new Object[]{by2};
        return PrintFormat.print(string, objectArray);
    }

    public static String print(String string, long l) throws FormatException {
        Long l2 = new Long(l);
        Object[] objectArray = new Object[]{l2};
        return PrintFormat.print(string, objectArray);
    }

    public static String print(String string, Object[] objectArray) throws FormatException {
        StringBuffer stringBuffer = new StringBuffer(0);
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c;
            try {
                c = string.charAt(n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new FormatException(indexOutOfBoundsException.toString());
            }
            if (c == '%') {
                try {
                    n2 = PrintFormat.convert(string, n2, objectArray, n, stringBuffer);
                }
                catch (NullPointerException nullPointerException) {
                    throw new FormatException();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new FormatException();
                }
                ++n;
                continue;
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws FormatException {
        if (stringArray.length == 0) {
            System.out.println(version);
            System.out.println(author);
            System.out.println(copyright);
            return;
        }
        Object[] objectArray = new Object[stringArray.length - 1];
        for (int i = 0; i < stringArray.length - 1; ++i) {
            objectArray[i] = stringArray[i + 1];
        }
        System.out.println(PrintFormat.print(stringArray[0], objectArray));
    }

    public static byte[] hex_to_a(byte by) {
        byte[] byArray = new byte[2];
        int n = by >> 4 & 0xF;
        byArray[0] = n > 9 ? (byte)(96 + (n - 9)) : (byte)(48 + n);
        n = by & 0xF;
        byArray[1] = n > 9 ? (byte)(96 + (n - 9)) : (byte)(48 + n);
        return byArray;
    }
}

