/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.net;

import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.wasamon.mjlib.net.HttpHeaderException;

public class HttpUtil {
    public static final String version = "HttpUtil 0.1";
    public static final String author = "Takefumi MIYOSHI (miyoshi@ae.titech.ac.jp)";
    public static final String copyright = "(c) 2003/06/27 All right reserved.";

    public static String getHTTPContentHeader(long l, long l2, String string) {
        String string2 = new String();
        byte[] byArray = new byte[]{13};
        byte[] byArray2 = new byte[]{10};
        String string3 = new String(byArray);
        String string4 = new String(byArray2);
        string2 = string2.concat("Last-Modified: ");
        string2 = string2.concat(HttpUtil.getDateString(l));
        string2 = string2.concat(string3);
        string2 = string2.concat(string4);
        string2 = string2.concat("Content-Type: ");
        string2 = string2.concat(string);
        string2 = string2.concat(string3);
        string2 = string2.concat(string4);
        string2 = string2.concat("Content-Length: ");
        string2 = string2.concat(Long.toString(l2));
        return string2;
    }

    public static String getDateString(long l) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(l);
        String string = Integer.toString(calendar.get(1));
        String string2 = Integer.toString(calendar.get(5));
        String string3 = Integer.toString(calendar.get(11));
        String string4 = Integer.toString(calendar.get(12));
        String string5 = Integer.toString(calendar.get(13));
        int n = calendar.get(2);
        int n2 = calendar.get(7);
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        if (string4.length() == 1) {
            string4 = "0" + string4;
        }
        if (string5.length() == 1) {
            string5 = "0" + string5;
        }
        String string6 = HttpUtil.getDayString(n2) + ", " + string2 + " " + HttpUtil.getMonthString(n) + " " + string + " " + string3 + ":" + string4 + ":" + string5 + " " + "GMT";
        return string6;
    }

    private static String getDayString(int n) {
        switch (n) {
            case 1: {
                return "Sun";
            }
            case 2: {
                return "Mon";
            }
            case 3: {
                return "Tue";
            }
            case 4: {
                return "Wed";
            }
            case 5: {
                return "Thu";
            }
            case 6: {
                return "Fri";
            }
            case 7: {
                return "Sat";
            }
        }
        return "";
    }

    public static boolean isThisYear(long l) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        int n = calendar.get(1);
        calendar.setTimeInMillis(l);
        int n2 = calendar.get(1);
        return n == n2;
    }

    public static String getYear(long l) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(l);
        int n = calendar.get(1);
        return Integer.toString(n);
    }

    public static String getMonth(long l) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(l);
        int n = calendar.get(2);
        return HttpUtil.getMonthString(n);
    }

    public static String getDate(long l) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(l);
        String string = Integer.toString(calendar.get(5));
        if (string.length() == 1) {
            string = " " + string;
        }
        return string;
    }

    public static String getTime(long l) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(l);
        String string = Integer.toString(calendar.get(11));
        String string2 = Integer.toString(calendar.get(12));
        if (string.length() == 1) {
            string = "0" + string;
        }
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        return string + ":" + string2;
    }

    private static String getMonthString(int n) {
        switch (n) {
            case 0: {
                return "Jan";
            }
            case 1: {
                return "Feb";
            }
            case 2: {
                return "Mar";
            }
            case 3: {
                return "Apr";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "Jun";
            }
            case 6: {
                return "Jul";
            }
            case 7: {
                return "Aug";
            }
            case 8: {
                return "Sep";
            }
            case 9: {
                return "Oct";
            }
            case 10: {
                return "Nov";
            }
            case 11: {
                return "Dec";
            }
        }
        return "";
    }

    public static long getTime(String string) throws HttpHeaderException {
        String string2 = "Last-Modified: ";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].startsWith(string2)) continue;
            return Long.parseLong(stringArray[n].substring(string2.length(), stringArray[n].length() - 1));
        }
        throw new HttpHeaderException("not found Last-Modified elemnt.");
    }

    public static String getType(String string) throws HttpHeaderException {
        String string2 = "Content-Type: ";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].startsWith(string2)) continue;
            return stringArray[n].substring(string2.length(), stringArray[n].length() - 1);
        }
        throw new HttpHeaderException("not found Content-Type elemnt.");
    }

    public static long getLength(String string) throws HttpHeaderException {
        String string2 = "Content-Length: ";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].startsWith(string2)) continue;
            return Long.parseLong(stringArray[n].substring(string2.length(), stringArray[n].length() - 1));
        }
        throw new HttpHeaderException("not found Content-Length elemnt.");
    }

    public static void main(String[] stringArray) {
        System.out.println(version);
        System.out.println(author);
        System.out.println(copyright);
        System.out.println(HttpUtil.getDateString(new Date().getTime()));
    }
}

