/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mjlib.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class FileName {
    public static final String version = "FileName 0.1";
    public static final String author = "Takefumi MIYOSHI (miyoshi@ae.titech.ac.jp)";
    public static final String copyright = "(c) 2003/06/27 All right reserved.";

    public static String getExt(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray[stringArray.length - 1];
    }

    public static Object[] expandWildExpression(File file, String string) {
        String string2 = FileName.toAbsPathName(file.getAbsolutePath(), string);
        String string3 = FileName.getLast(string2);
        int n = string3.indexOf(42);
        if (n < 0) {
            Object[] objectArray = new String[]{string2};
            return objectArray;
        }
        string3 = string3.replaceAll("\\.", "\\\\.");
        string3 = string3.replaceAll("\\^", "\\\\^");
        string3 = string3.replaceAll("\\$", "\\\\$");
        string3 = string3.replaceAll("\\?", "\\\\?");
        string3 = string3.replaceAll("\\+", "\\\\+");
        string3 = string3.replaceAll("\\|", "\\\\|");
        string3 = string3.replaceAll("\\*", ".*");
        Pattern pattern = Pattern.compile(string3);
        String[] stringArray = file.list();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!pattern.matcher(stringArray[i]).matches()) continue;
            arrayList.add(FileName.toAbsPathName(file.getAbsolutePath(), stringArray[i]));
        }
        return arrayList.toArray();
    }

    public static boolean isRegularFileName(String string) {
        int n = -1;
        n = string.indexOf(42);
        return n < 0;
    }

    public static String toAbsDirName(String string, String string2) {
        String string3 = string2.charAt(0) == '/' ? string2 : string.concat(string2);
        if ((string3 = FileName.toParse(string3)).charAt(string3.length() - 1) != '/') {
            string3 = string3.concat("/");
        }
        return string3;
    }

    public static String toAbsPathName(String string, String string2) {
        if (string2.charAt(0) == '/') {
            return FileName.toParse(string2);
        }
        return FileName.toParse(string.concat(string2));
    }

    public static String toParse(String string) {
        String[] stringArray = FileName.trim(string);
        if (stringArray.length == 0) {
            return "/";
        }
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(".")) continue;
            if (stringArray[i].equals("..")) {
                if (stack.empty()) continue;
                stack.pop();
                continue;
            }
            stack.push(stringArray[i]);
        }
        String string2 = "/";
        while (!stack.empty()) {
            string2 = ((String)stack.pop()).concat(string2);
            string2 = "/".concat(string2);
        }
        return string2;
    }

    public static String[] trim(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "/");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public static String getLongFileName(String[] stringArray, int n) {
        String string = new String("");
        while (true) {
            string = string.concat(stringArray[n]);
            if (n == stringArray.length - 1) break;
            ++n;
            string = string.concat(" ");
        }
        return string;
    }

    public static String getLast(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "/");
        String string2 = "/";
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
            ++n;
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        System.out.println(version);
        System.out.println(author);
        System.out.println(copyright);
    }
}

