/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.jgdb;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

class XMLRPCGDBClient {
    private XmlRpcClient server;
    private static XMLRPCGDBClient instance = new XMLRPCGDBClient();

    public static XMLRPCGDBClient getInstance() {
        return instance;
    }

    private XMLRPCGDBClient() {
        try {
            String hostname = "localhost";
            String host = System.getProperty("net.wasamon.xmlgdb.host");
            if (host != null) {
                hostname = host;
            }
            int port = 8080;
            String p = System.getProperty("net.wasamon.xmlgdb.port");
            if (p != null) {
                port = Integer.parseInt(p);
            }
            this.server = new XmlRpcClient("http://" + hostname + ":" + port + "/RPC2");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public synchronized Object execCommand(String method, Vector param) {
        Object obj = null;
        try {
            obj = this.server.execute("gdb." + method, param);
            System.out.println("recieve val:" + obj);
        }
        catch (IOException e) {
            System.out.println("catch IOException in GdbClient.execCommand: " + e.getClass().getName() + e.getMessage());
            if (obj == null) {
                System.out.println("retry");
                obj = this.execCommand(method, param);
            }
        }
        catch (XmlRpcException e) {
            System.out.println("catch XmlRpcException in GdbClient.execCommand: " + e.getMessage());
            e.printStackTrace();
        }
        return obj;
    }
}

