/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.jgdb;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.wasamon.jgdb.JGDBWindow;

public class RegisterFrame {
    private JFrame frame;
    private JTable table;
    private RegisterTableModel dm;
    JGDBWindow parent;

    public RegisterFrame(JGDBWindow parent) {
        this.parent = parent;
        this.frame = new JFrame("Register Panel");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                RegisterFrame.this.frame.setVisible(false);
            }
        });
        this.dm = new RegisterTableModel();
        this.table = new JTable(this.dm);
        this.frame.getContentPane().add(new JScrollPane(this.table));
        this.frame.pack();
        this.frame.setVisible(false);
    }

    public void setVisible(boolean f) {
        this.frame.setVisible(f);
    }

    public void update() {
        this.dm.setRegNameList(this.parent.gdb().getRegNameList());
        this.dm.setRegValueList(this.parent.gdb().getRegValueList());
        this.repaint();
    }

    public void repaint() {
        this.table.revalidate();
        this.table.repaint();
        this.frame.pack();
        this.frame.repaint();
    }

    public RegisterTableModel getDataModel() {
        return this.dm;
    }

    class RegisterTableModel
    implements TableModel {
        private String[] columns = new String[]{"name", "value"};
        private String[] regNameList;
        private String[] regValueList;

        public void addTableModelListener(TableModelListener l) {
        }

        public Class getColumnClass(int columnIndex) {
            return "".getClass();
        }

        public int getColumnCount() {
            return this.columns.length;
        }

        public String getColumnName(int columnIndex) {
            return this.columns[columnIndex];
        }

        public int getRowCount() {
            if (this.regNameList != null) {
                return this.regNameList.length;
            }
            return 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.regNameList[rowIndex];
            }
            return this.regValueList[rowIndex];
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public void removeTableModelListener(TableModelListener l) {
        }

        public void setRegNameList(String[] regNameList) {
            this.regNameList = regNameList;
        }

        public void setRegValueList(String[] regValueList) {
            this.regValueList = regValueList;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (rowIndex < this.getRowCount()) {
                    this.regNameList[rowIndex] = (String)aValue;
                }
            } else if (rowIndex < this.getRowCount()) {
                this.regValueList[rowIndex] = (String)aValue;
            }
        }
    }
}

