/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.wallet.preprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;

public class PreProcessorParser {
    public static final int EOF_TOKEN = 0;
    public static final int TOKEN_SPACE = 1;
    public static final int TOKEN_COMMENT = 2;
    public static final int TOKEN_CXXCOMMENT = 3;
    public static final int TOKEN_DIRECTIVE = 4;
    public static final int TOKEN_LEFT_PAREN = 5;
    public static final int TOKEN_RIGHT_PAREN = 6;
    public static final int TOKEN_LEFT_BAREN = 7;
    public static final int TOKEN_RIGHT_BAREN = 8;
    public static final int TOKEN_LEFT_BBAREN = 9;
    public static final int TOKEN_RIGHT_BBAREN = 10;
    public static final int TOKEN_COMMA = 11;
    public static final int TOKEN_QUOTE = 12;
    public static final int TOKEN_SEMICOLON = 13;
    public static final int TOKEN_ASTERRISC = 14;
    public static final int TOKEN_AMPARSAND = 15;
    public static final int TOKEN_EQUAL = 16;
    public static final int TOKEN_LT = 17;
    public static final int TOKEN_GT = 18;
    public static final int TOKEN_PLUS = 19;
    public static final int TOKEN_MINUS = 20;
    public static final int TOKEN_DIV = 21;
    public static final int TOKEN_MOD = 22;
    public static final int TOKEN_NOT = 23;
    public static final int TOKEN_LOR = 24;
    public static final int TOKEN_LAND = 25;
    public static final int TOKEN_BOR = 26;
    public static final int TOKEN_NUMBER = 27;
    public static final int TOKEN_FLOATNUMBER = 28;
    public static final int TOKEN_IDENTIFIER = 29;
    public static final int TOKEN_NEW_LINE = 30;
    public static final int TOKEN_QUATED_STRING = 31;
    private static final int[][] __dfaTable__notavacc_reserved = new int[59][];
    private static final int[][] __lrTable__notavacc_reserved;
    private static final int[][] __reductionTable__notavacc_reserved;

    static {
        PreProcessorParser.initializeDFATable0();
        PreProcessorParser.initializeDFATable50();
        __lrTable__notavacc_reserved = new int[3][];
        PreProcessorParser.initializeLRTable0();
        __reductionTable__notavacc_reserved = new int[0][];
    }

    protected Node createNode(int symbolID, NodeInitializationParameters parameters) throws ParseException {
        return this.createNode(symbolID, parameters, false);
    }

    protected final Default.Node createNode(int symbolID, NodeInitializationParameters parameters, boolean compact) {
        throw new AssertionError((Object)"Node creation failed.");
    }

    protected Node modifyWholeTree(Node root) throws ParseException {
        return root;
    }

    protected final CharSequence toCharSequence(File file, String charsetName) throws IOException {
        FileInputStream fis = null;
        InputStreamReader reader = null;
        AbstractInterruptibleChannel fc = null;
        try {
            int size;
            Charset charset;
            fis = new FileInputStream(file);
            reader = charsetName == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, charsetName);
            try {
                charset = Charset.forName(reader.getEncoding());
            }
            catch (UnsupportedCharsetException x) {
                charset = null;
            }
            if (charset != null) {
                CharsetDecoder decoder = charset.newDecoder();
                fc = fis.getChannel();
                int size2 = (int)((FileChannel)fc).size();
                MappedByteBuffer bb = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, 0L, size2);
                CharBuffer charBuffer = decoder.decode(bb);
                return charBuffer;
            }
            long length = file.length();
            if (length <= 0L) {
                length = 1L;
            } else if (length > Integer.MAX_VALUE) {
                length = Integer.MAX_VALUE;
            }
            StringBuffer result = new StringBuffer((int)length);
            char[] buffer = new char[1024];
            while ((size = reader.read(buffer)) >= 0) {
                result.append(buffer, 0, size);
            }
            StringBuffer stringBuffer = result;
            return stringBuffer;
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (reader != null) {
                reader.close();
            } else if (fis != null) {
                fis.close();
            }
        }
    }

    protected final CharSequence toCharSequence(Reader reader) throws IOException {
        int size;
        StringBuffer result = new StringBuffer();
        char[] buffer = new char[1024];
        while ((size = reader.read(buffer)) >= 0) {
            result.append(buffer, 0, size);
        }
        return result;
    }

    protected LexicalAnalyzer createLexicalAnalyzer(String sourceName, CharSequence text, int tabStop) throws ParseException {
        return new Default.LexicalAnalyzer(sourceName, text, tabStop);
    }

    private Node __parse__notavacc_reserved(int[][] lrTable, int[][] reductions, int initialState, int classSymbolMaximum, LexicalAnalyzer analyzer) throws ParseException {
        boolean labelWordCount = true;
        ArrayList<Token> whiteTokens = new ArrayList<Token>();
        ArrayList<__GrpahStack__notavacc_reserved> states = new ArrayList<__GrpahStack__notavacc_reserved>();
        ArrayList<__GrpahStack__notavacc_reserved> nextStates = new ArrayList<__GrpahStack__notavacc_reserved>();
        states.add(__GrpahStack__notavacc_reserved.push(__GrpahStack__notavacc_reserved.EMPTY_STACK, null, initialState));
        while (true) {
            int stateID;
            __GrpahStack__notavacc_reserved stack;
            int i;
            Token nextToken = analyzer.next();
            int nextTokenID = nextToken.getSymbolID();
            if (nextToken.isWhite()) {
                whiteTokens.add(nextToken);
                continue;
            }
            if (!whiteTokens.isEmpty()) {
                Object whiteTokensObject = whiteTokens.size() == 1 ? whiteTokens.get(0) : whiteTokens.toArray(new Token[whiteTokens.size()]);
                whiteTokens.clear();
                i = 0;
                while (i < states.size()) {
                    stack = (__GrpahStack__notavacc_reserved)states.get(i);
                    states.set(i, __GrpahStack__notavacc_reserved.push(new __GrpahStack__notavacc_reserved[]{stack}, whiteTokensObject, stack.state));
                    ++i;
                }
            }
            int initialStatesSize = states.size();
            i = 0;
            while (i < states.size()) {
                stack = (__GrpahStack__notavacc_reserved)states.get(i);
                stateID = stack.topState();
                int[] tokenIDToReductionID = lrTable[stateID * 3 + 2];
                int j = PreProcessorParser.__binarySearch__notavacc_reserved(tokenIDToReductionID, nextTokenID);
                while (j < tokenIDToReductionID.length) {
                    if (tokenIDToReductionID[j] > nextTokenID) break;
                    if (tokenIDToReductionID[j] == nextTokenID) {
                        int reductionID = tokenIDToReductionID[j + 1];
                        int[] reduction = reductions[reductionID];
                        this.reduce(states, stack, nextTokenID, reductionID, reductions, lrTable, classSymbolMaximum);
                    }
                    j += 2;
                }
                ++i;
            }
            i = 0;
            while (i < states.size()) {
                stack = (__GrpahStack__notavacc_reserved)states.get(i);
                stateID = stack.topState();
                int[] tokenIDToNextState = lrTable[stateID * 3 + 0];
                int k = PreProcessorParser.__binarySearch__notavacc_reserved(tokenIDToNextState, nextTokenID);
                while (k < tokenIDToNextState.length) {
                    if (tokenIDToNextState[k] > nextTokenID) break;
                    if (tokenIDToNextState[k] == nextTokenID) {
                        int nextStateID = tokenIDToNextState[k + 1];
                        nextStates.add(__GrpahStack__notavacc_reserved.push(new __GrpahStack__notavacc_reserved[]{stack}, nextToken, nextStateID));
                        break;
                    }
                    k += 2;
                }
                ++i;
            }
            if (nextStates.isEmpty()) {
                states.subList(initialStatesSize, states.size()).clear();
                this.__error__notavacc_reserved(analyzer, lrTable, reductions, states, nextToken, classSymbolMaximum);
                continue;
            }
            if (nextTokenID == 0) break;
            ArrayList<__GrpahStack__notavacc_reserved> tmp = states;
            states = nextStates;
            nextStates = tmp;
            nextStates.clear();
        }
        states = nextStates;
        LinkedList<Object> root = new LinkedList<Object>();
        boolean ambiguous = true;
        int reductionID = -1;
        if (states.size() == 1) {
            __GrpahStack__notavacc_reserved stack = (__GrpahStack__notavacc_reserved)states.get(0);
            while (true) {
                Object topNode = stack.topNode();
                __GrpahStack__notavacc_reserved[] prevs = __GrpahStack__notavacc_reserved.pop(stack);
                if (prevs == __GrpahStack__notavacc_reserved.EMPTY_STACK) {
                    assert (topNode == null);
                    ambiguous = false;
                    break;
                }
                if (topNode instanceof Token[]) {
                    root.addAll(0, (Collection)Arrays.asList((Token[])topNode));
                } else if (topNode instanceof Token) {
                    root.add(0, topNode);
                } else {
                    __ConcreteSyntaxTree__notavacc_reserved cst = (__ConcreteSyntaxTree__notavacc_reserved)topNode;
                    assert (reductionID == -1);
                    reductionID = cst.reductionID;
                    root.addAll(0, (Collection)Arrays.asList(cst.children));
                }
                if (prevs.length > 1) break;
                stack = prevs[0];
            }
        }
        if (ambiguous) {
            throw new ParseException.AmbiguousGrammarError("PreProcessorParser.notavacc is ambiguous.");
        }
        return this.createNode(root.subList(0, root.size() - 1).toArray(), reductionID, reductions, classSymbolMaximum);
    }

    private static int __binarySearch__notavacc_reserved(int[] table, int key) {
        int base = 0;
        int width = table.length >> 1;
        while (width > 1) {
            int halfWidth = width >> 1;
            int mid = base + width & 0xFFFFFFFE;
            if (key <= table[mid]) {
                width = halfWidth;
                continue;
            }
            base = mid;
            width -= halfWidth;
        }
        return base;
    }

    private void reduce(List states, __GrpahStack__notavacc_reserved stack, int nextTokenID, int reductionID, int[][] reductions, int[][] lrTable, int classSymbolMaximum) throws ParseException {
        this.reduce(states, stack, nextTokenID, reductionID, reductions, reductions[reductionID].length - 1, null, lrTable, classSymbolMaximum);
    }

    private void reduce(List states, __GrpahStack__notavacc_reserved stack, int nextTokenID, int reductionID, int[][] reductions, int reductionSize, Object[] tail, int[][] lrTable, int classSymbolMaximum) throws ParseException {
        Token token;
        while (reductionSize > 0) {
            __GrpahStack__notavacc_reserved[] prevs;
            Object topNode = stack.topNode();
            boolean whiteToken = false;
            if (topNode instanceof Token[]) {
                whiteToken = true;
            } else if (topNode instanceof Token) {
                Token token2 = (Token)topNode;
                if (token2.isWhite()) {
                    whiteToken = true;
                }
            } else if (topNode instanceof __ConcreteSyntaxTree__notavacc_reserved) {
                __ConcreteSyntaxTree__notavacc_reserved cst = (__ConcreteSyntaxTree__notavacc_reserved)topNode;
                if (reductions[cst.reductionID][0] <= classSymbolMaximum) {
                    topNode = this.createNode(cst.children, cst.reductionID, reductions, classSymbolMaximum);
                }
            }
            tail = new Object[]{topNode, tail};
            if (!whiteToken) {
                boolean labelWordCount = true;
                --reductionSize;
            }
            if ((prevs = __GrpahStack__notavacc_reserved.pop(stack)).length > 1) {
                int i = 0;
                while (i < prevs.length) {
                    this.reduce(states, prevs[i], nextTokenID, reductionID, reductions, reductionSize, tail, lrTable, classSymbolMaximum);
                    ++i;
                }
                return;
            }
            stack = prevs[0];
        }
        Object last = null;
        LinkedList<Object> result = new LinkedList<Object>();
        while (tail != null) {
            result.addLast(tail[0]);
            last = tail[0];
            tail = (Object[])tail[1];
        }
        boolean whiteToken = false;
        if (last instanceof Token[]) {
            whiteToken = true;
        } else if (last instanceof Token && (token = (Token)last).isWhite()) {
            whiteToken = true;
        }
        if (whiteToken) {
            result.removeLast();
        }
        __ConcreteSyntaxTree__notavacc_reserved subtree = new __ConcreteSyntaxTree__notavacc_reserved(reductionID, result.toArray());
        int[] reduction = reductions[reductionID];
        int nextSymbolID = reduction[0];
        int returnedStateID = stack.topState();
        int[] symbolIDToNextState = lrTable[returnedStateID * 3 + 1];
        int k = PreProcessorParser.__binarySearch__notavacc_reserved(symbolIDToNextState, nextSymbolID);
        while (k < symbolIDToNextState.length) {
            if (symbolIDToNextState[k] > nextSymbolID) break;
            if (symbolIDToNextState[k] == nextSymbolID) {
                int nextStateID = symbolIDToNextState[k + 1];
                stack = __GrpahStack__notavacc_reserved.push(new __GrpahStack__notavacc_reserved[]{stack}, subtree, nextStateID);
                if (whiteToken) {
                    stack = __GrpahStack__notavacc_reserved.push(new __GrpahStack__notavacc_reserved[]{stack}, last, nextStateID);
                }
                states.add(stack);
                break;
            }
            k += 2;
        }
    }

    private Node createNode(Object[] children, int reductionID, int[][] reductions, int classSymbolMaximum) throws ParseException {
        int[] reduction = reductions[reductionID];
        LinkedList nodeList = new LinkedList();
        LinkedList labelsIDList = new LinkedList();
        this.__flatNodes__notavacc_reserved(0, nodeList, labelsIDList, children, reductionID, reductions, classSymbolMaximum);
        Node[] childNodes = nodeList.toArray(new Node[nodeList.size()]);
        NodeInitializationParameters parameters = new NodeInitializationParameters();
        parameters.childNodes = childNodes;
        parameters.labelsIDList = labelsIDList;
        Node result = this.createNode(reductions[reductionID][0], parameters);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void __flatNodes__notavacc_reserved(int labels, List nodeList, List labelsIDList, Object[] list, int reductionID, int[][] reductions, int classSymbolMaximum) throws ParseException {
        reduction = reductions[reductionID];
        reductionIndex = 1;
        i = 0;
        while (i < list.length) {
            block6: {
                block7: {
                    block5: {
                        node = list[i];
                        if (!(node instanceof Token[])) break block5;
                        whiteTokens = (Token[])node;
                        nodeList.addAll((Collection)Arrays.asList(whiteTokens));
                        j = 0;
                        while (j < whiteTokens.length) {
                            labelsIDList.add(null);
                            ++j;
                        }
                        break block6;
                    }
                    if (!(node instanceof Token) || !(token = (Token)node).isWhite()) break block7;
                    nodeList.add(token);
                    labelsIDList.add(null);
                    break block6;
                }
                if (((mergedLabelsID = reduction[reductionIndex++]) & 1) != 0) {
                    mergedLabelsID &= -2;
                    mergedLabelsID |= labels;
                }
                if (!(node instanceof __ConcreteSyntaxTree__notavacc_reserved)) ** GOTO lbl35
                cst = (__ConcreteSyntaxTree__notavacc_reserved)node;
                children = cst.children;
                if (reductions[cst.reductionID][0] > classSymbolMaximum) {
                    this.__flatNodes__notavacc_reserved(mergedLabelsID, nodeList, labelsIDList, children, cst.reductionID, reductions, classSymbolMaximum);
                } else {
                    node = this.createNode(children, cst.reductionID, reductions, classSymbolMaximum);
lbl35:
                    // 2 sources

                    nodeList.add((Node)node);
                    labelsIDList.add(new Integer(mergedLabelsID));
                }
            }
            ++i;
        }
    }

    private void __error__notavacc_reserved(LexicalAnalyzer analyzer, int[][] lrTable, int[][] reductions, List states, Token errorNextToken, int classSymbolMaximum) throws ParseException {
        TreeSet<Integer> candidates = new TreeSet<Integer>();
        int i = 0;
        while (i < states.size()) {
            __GrpahStack__notavacc_reserved stack = (__GrpahStack__notavacc_reserved)states.get(i);
            int stateID = stack.topState();
            int[] tokenIDToNextState = lrTable[stateID * 3 + 0];
            int k = 0;
            while (k < tokenIDToNextState.length) {
                candidates.add(new Integer(tokenIDToNextState[k]));
                k += 2;
            }
            int[] tokenIDToReductionID = lrTable[stateID * 3 + 2];
            int j = 0;
            while (j < tokenIDToReductionID.length) {
                candidates.add(new Integer(tokenIDToReductionID[j]));
                j += 2;
            }
            ++i;
        }
        TreeSet<Integer> nextTokens = new TreeSet<Integer>();
        states = new ArrayList(states);
        int originalSize = states.size();
        for (Integer candidate : candidates) {
            int stateID;
            __GrpahStack__notavacc_reserved stack;
            int nextTokenID = candidate;
            states.subList(originalSize, states.size()).clear();
            int i2 = 0;
            while (i2 < states.size()) {
                stack = (__GrpahStack__notavacc_reserved)states.get(i2);
                stateID = stack.topState();
                int[] tokenIDToReductionID = lrTable[stateID * 3 + 2];
                int j = PreProcessorParser.__binarySearch__notavacc_reserved(tokenIDToReductionID, nextTokenID);
                while (j < tokenIDToReductionID.length) {
                    if (tokenIDToReductionID[j] > nextTokenID) break;
                    if (tokenIDToReductionID[j] == nextTokenID) {
                        int reductionID = tokenIDToReductionID[j + 1];
                        int[] reduction = reductions[reductionID];
                        this.reduce(states, stack, nextTokenID, reductionID, reductions, lrTable, classSymbolMaximum);
                    }
                    j += 2;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < states.size()) {
                stack = (__GrpahStack__notavacc_reserved)states.get(i2);
                stateID = stack.topState();
                int[] tokenIDToNextState = lrTable[stateID * 3 + 0];
                int k = PreProcessorParser.__binarySearch__notavacc_reserved(tokenIDToNextState, nextTokenID);
                while (k < tokenIDToNextState.length) {
                    if (tokenIDToNextState[k] > nextTokenID) break;
                    if (tokenIDToNextState[k] == nextTokenID) {
                        int nextStateID = tokenIDToNextState[k + 1];
                        nextTokens.add(candidate);
                        break;
                    }
                    k += 2;
                }
                ++i2;
            }
        }
        int[] selectableTokens = new int[nextTokens.size()];
        int index = 0;
        for (Integer i3 : nextTokens) {
            selectableTokens[index++] = i3;
        }
        PreProcessorParser.__error__notavacc_reserved(analyzer, errorNextToken, selectableTokens);
    }

    private static void __error__notavacc_reserved(LexicalAnalyzer analyzer, Token errorNextToken, int[] selectableNextTokens) throws ParseException {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        if (errorNextToken.getSymbolID() != 0) {
            writer.println("The token " + errorNextToken + " should be one of the following.");
        } else {
            writer.println("The EOF should be one of the following.");
        }
        String[] tokenStrings = new String[]{"<EOF>", "SPACE", "COMMENT", "CXXCOMMENT", "DIRECTIVE", "LEFT_PAREN", "RIGHT_PAREN", "LEFT_BAREN", "RIGHT_BAREN", "LEFT_BBAREN", "RIGHT_BBAREN", "COMMA", "QUOTE", "SEMICOLON", "ASTERRISC", "AMPARSAND", "EQUAL", "LT", "GT", "PLUS", "MINUS", "DIV", "MOD", "NOT", "LOR", "LAND", "BOR", "NUMBER", "FLOATNUMBER", "IDENTIFIER", "NEW_LINE", "QUATED_STRING"};
        int i = 0;
        while (i < selectableNextTokens.length) {
            int selectableNextToken = selectableNextTokens[i];
            writer.print("        ");
            writer.println(tokenStrings[selectableNextToken]);
            ++i;
        }
        writer.close();
        if (writer.checkError()) {
            throw new RuntimeException();
        }
        throw new ParseException(buffer.toString(), errorNextToken);
    }

    private static void initializeDFATable0() {
        PreProcessorParser.__dfaTable__notavacc_reserved[0] = new int[]{-1, 9, 9, 1, 10, 10, 2, 13, 13, 3, 32, 32, 1, 33, 33, 4, 34, 34, 5, 35, 35, 7, 36, 36, 28, 37, 37, 29, 38, 38, 30, 39, 39, 32, 40, 40, 33, 41, 41, 34, 42, 42, 35, 43, 43, 36, 44, 44, 37, 45, 45, 38, 46, 46, 39, 47, 47, 42, 48, 57, 41, 59, 59, 49, 60, 60, 50, 61, 61, 51, 62, 62, 52, 65, 90, 28, 91, 91, 53, 93, 93, 54, 95, 95, 28, 97, 122, 28, 123, 123, 55, 124, 124, 56, 125, 125, 58, 128, 65535, 28};
        PreProcessorParser.__dfaTable__notavacc_reserved[1] = new int[]{1, 9, 9, 1, 32, 32, 1};
        PreProcessorParser.__dfaTable__notavacc_reserved[2] = new int[]{30};
        PreProcessorParser.__dfaTable__notavacc_reserved[3] = new int[]{30, 10, 10, 2};
        PreProcessorParser.__dfaTable__notavacc_reserved[4] = new int[]{23};
        int[] nArray = new int[10];
        nArray[0] = -1;
        nArray[2] = 33;
        nArray[3] = 5;
        nArray[4] = 34;
        nArray[5] = 34;
        nArray[6] = 6;
        nArray[7] = 35;
        nArray[8] = 65535;
        nArray[9] = 5;
        PreProcessorParser.__dfaTable__notavacc_reserved[5] = nArray;
        PreProcessorParser.__dfaTable__notavacc_reserved[6] = new int[]{31};
        PreProcessorParser.__dfaTable__notavacc_reserved[7] = new int[]{-1, 9, 9, 7, 32, 32, 7, 100, 100, 8, 101, 101, 14, 105, 105, 20};
        PreProcessorParser.__dfaTable__notavacc_reserved[8] = new int[]{-1, 101, 101, 9};
        PreProcessorParser.__dfaTable__notavacc_reserved[9] = new int[]{-1, 102, 102, 10};
        PreProcessorParser.__dfaTable__notavacc_reserved[10] = new int[]{-1, 105, 105, 11};
        PreProcessorParser.__dfaTable__notavacc_reserved[11] = new int[]{-1, 110, 110, 12};
        PreProcessorParser.__dfaTable__notavacc_reserved[12] = new int[]{-1, 101, 101, 13};
        PreProcessorParser.__dfaTable__notavacc_reserved[13] = new int[]{4, 9, 9, 13, 32, 32, 13};
        PreProcessorParser.__dfaTable__notavacc_reserved[14] = new int[]{-1, 108, 108, 15, 110, 110, 18};
        PreProcessorParser.__dfaTable__notavacc_reserved[15] = new int[]{-1, 115, 115, 16};
        PreProcessorParser.__dfaTable__notavacc_reserved[16] = new int[]{-1, 101, 101, 13, 105, 105, 17};
        PreProcessorParser.__dfaTable__notavacc_reserved[17] = new int[]{-1, 102, 102, 13};
        PreProcessorParser.__dfaTable__notavacc_reserved[18] = new int[]{-1, 100, 100, 19};
        PreProcessorParser.__dfaTable__notavacc_reserved[19] = new int[]{-1, 105, 105, 17};
        PreProcessorParser.__dfaTable__notavacc_reserved[20] = new int[]{-1, 102, 102, 21, 110, 110, 24};
        PreProcessorParser.__dfaTable__notavacc_reserved[21] = new int[]{4, 9, 9, 13, 32, 32, 13, 100, 100, 22, 110, 110, 23};
        PreProcessorParser.__dfaTable__notavacc_reserved[22] = new int[]{-1, 101, 101, 17};
        PreProcessorParser.__dfaTable__notavacc_reserved[23] = new int[]{-1, 100, 100, 22};
        PreProcessorParser.__dfaTable__notavacc_reserved[24] = new int[]{-1, 99, 99, 25};
        PreProcessorParser.__dfaTable__notavacc_reserved[25] = new int[]{-1, 108, 108, 26};
        PreProcessorParser.__dfaTable__notavacc_reserved[26] = new int[]{-1, 117, 117, 27};
        PreProcessorParser.__dfaTable__notavacc_reserved[27] = new int[]{-1, 100, 100, 12};
        PreProcessorParser.__dfaTable__notavacc_reserved[28] = new int[]{29, 36, 36, 28, 48, 57, 28, 65, 90, 28, 95, 95, 28, 97, 122, 28, 128, 65535, 28};
        PreProcessorParser.__dfaTable__notavacc_reserved[29] = new int[]{22};
        PreProcessorParser.__dfaTable__notavacc_reserved[30] = new int[]{15, 38, 38, 31};
        PreProcessorParser.__dfaTable__notavacc_reserved[31] = new int[]{25};
        PreProcessorParser.__dfaTable__notavacc_reserved[32] = new int[]{12};
        PreProcessorParser.__dfaTable__notavacc_reserved[33] = new int[]{5};
        PreProcessorParser.__dfaTable__notavacc_reserved[34] = new int[]{6};
        PreProcessorParser.__dfaTable__notavacc_reserved[35] = new int[]{14};
        PreProcessorParser.__dfaTable__notavacc_reserved[36] = new int[]{19};
        PreProcessorParser.__dfaTable__notavacc_reserved[37] = new int[]{11};
        PreProcessorParser.__dfaTable__notavacc_reserved[38] = new int[]{20, 46, 46, 39, 48, 57, 41};
        PreProcessorParser.__dfaTable__notavacc_reserved[39] = new int[]{-1, 48, 57, 40};
        PreProcessorParser.__dfaTable__notavacc_reserved[40] = new int[]{28, 48, 57, 40};
        PreProcessorParser.__dfaTable__notavacc_reserved[41] = new int[]{27, 46, 46, 39, 48, 57, 41};
        PreProcessorParser.__dfaTable__notavacc_reserved[42] = new int[]{21, 42, 42, 43, 47, 47, 46};
        int[] nArray2 = new int[10];
        nArray2[0] = -1;
        nArray2[2] = 41;
        nArray2[3] = 43;
        nArray2[4] = 42;
        nArray2[5] = 42;
        nArray2[6] = 44;
        nArray2[7] = 43;
        nArray2[8] = 65535;
        nArray2[9] = 43;
        PreProcessorParser.__dfaTable__notavacc_reserved[43] = nArray2;
        int[] nArray3 = new int[16];
        nArray3[0] = -1;
        nArray3[2] = 41;
        nArray3[3] = 43;
        nArray3[4] = 42;
        nArray3[5] = 42;
        nArray3[6] = 44;
        nArray3[7] = 43;
        nArray3[8] = 46;
        nArray3[9] = 43;
        nArray3[10] = 47;
        nArray3[11] = 47;
        nArray3[12] = 45;
        nArray3[13] = 48;
        nArray3[14] = 65535;
        nArray3[15] = 43;
        PreProcessorParser.__dfaTable__notavacc_reserved[44] = nArray3;
        PreProcessorParser.__dfaTable__notavacc_reserved[45] = new int[]{2};
        int[] nArray4 = new int[16];
        nArray4[0] = -1;
        nArray4[2] = 9;
        nArray4[3] = 46;
        nArray4[4] = 10;
        nArray4[5] = 10;
        nArray4[6] = 47;
        nArray4[7] = 11;
        nArray4[8] = 12;
        nArray4[9] = 46;
        nArray4[10] = 13;
        nArray4[11] = 13;
        nArray4[12] = 48;
        nArray4[13] = 14;
        nArray4[14] = 65535;
        nArray4[15] = 46;
        PreProcessorParser.__dfaTable__notavacc_reserved[46] = nArray4;
        PreProcessorParser.__dfaTable__notavacc_reserved[47] = new int[]{3};
        PreProcessorParser.__dfaTable__notavacc_reserved[48] = new int[]{3, 10, 10, 47};
        PreProcessorParser.__dfaTable__notavacc_reserved[49] = new int[]{13};
    }

    private static void initializeDFATable50() {
        PreProcessorParser.__dfaTable__notavacc_reserved[50] = new int[]{17};
        PreProcessorParser.__dfaTable__notavacc_reserved[51] = new int[]{16};
        PreProcessorParser.__dfaTable__notavacc_reserved[52] = new int[]{18};
        PreProcessorParser.__dfaTable__notavacc_reserved[53] = new int[]{9};
        PreProcessorParser.__dfaTable__notavacc_reserved[54] = new int[]{10};
        PreProcessorParser.__dfaTable__notavacc_reserved[55] = new int[]{7};
        PreProcessorParser.__dfaTable__notavacc_reserved[56] = new int[]{26, 124, 124, 57};
        PreProcessorParser.__dfaTable__notavacc_reserved[57] = new int[]{24};
        PreProcessorParser.__dfaTable__notavacc_reserved[58] = new int[]{8};
    }

    private static void initializeLRTable0() {
        PreProcessorParser.__lrTable__notavacc_reserved[0] = new int[0];
        PreProcessorParser.__lrTable__notavacc_reserved[1] = new int[0];
        PreProcessorParser.__lrTable__notavacc_reserved[2] = new int[0];
    }

    private static void __replaceAll__notavacc_reserved(List list, Node oldValue, Node newValue) {
        Collections.replaceAll(list, oldValue, newValue);
    }

    private static String __toHexCode__notavacc_reserved(char ch) {
        String hex = "000" + Integer.toString(ch, 16).toUpperCase(Locale.ENGLISH);
        hex = hex.substring(hex.length() - 4);
        return hex;
    }

    public static interface Default {

        public static class LexicalAnalyzer
        extends net.wasamon.wallet.preprocessor.PreProcessorParser$LexicalAnalyzer {
            protected final String sourceName;
            protected final CharSequence text;
            protected final int end;
            protected final int tabStop;
            private final int[][] table;
            private final int initialState;
            protected int index;
            protected int line;
            protected int column;

            public LexicalAnalyzer(String sourceName, CharSequence text, int tabStop) {
                this(sourceName, text, tabStop, 0, text.length(), 0, 0);
            }

            public LexicalAnalyzer(String sourceName, CharSequence text, int tabStop, int start, int end, int line, int column) {
                this(sourceName, text, tabStop, start, end, line, column, __dfaTable__notavacc_reserved, 0);
            }

            private LexicalAnalyzer(String sourceName, CharSequence text, int tabStop, int start, int end, int line, int column, int[][] table, int initialState) {
                this.sourceName = sourceName;
                this.text = text;
                this.end = end;
                this.tabStop = tabStop;
                this.table = table;
                this.initialState = initialState;
                this.index = start;
                this.line = line;
                this.column = column;
            }

            public net.wasamon.wallet.preprocessor.PreProcessorParser$Token next() throws ParseException {
                if (this.index >= this.end) {
                    return new Token(0, "", "", this.sourceName, this.index, -1, -1);
                }
                int state = this.initialState;
                int startIndex = this.index;
                int startLine = this.line;
                int startColumn = this.column;
                int lastHitID = -1;
                int lastHitIndex = -1;
                int lastHitLine = -1;
                int lastHitColumn = -1;
                int lastHitImageLength = 0;
                StringBuffer image = new StringBuffer();
                try {
                    block3: while (this.index < this.end) {
                        char ch = this.nextChar();
                        image.append(ch);
                        int[] map = this.table[state];
                        int base = 1;
                        int width = (map.length - 1) / 3;
                        while (width > 1) {
                            int halfWidth = width >> 1;
                            int mid = base + halfWidth * 3;
                            if (ch >= map[mid]) {
                                base = mid;
                                width -= halfWidth;
                                continue;
                            }
                            width = halfWidth;
                        }
                        int i = 0;
                        while (i++ < width) {
                            if (!(map[base] <= ch & ch <= map[base + 1])) {
                                base += 3;
                                continue;
                            }
                            state = map[base + 2];
                            int hitID = this.table[state][0];
                            if (hitID == -1) continue block3;
                            lastHitID = hitID;
                            lastHitIndex = this.index;
                            lastHitLine = this.line;
                            lastHitColumn = this.column;
                            lastHitImageLength = image.length();
                            continue block3;
                        }
                        break block3;
                    }
                    if (lastHitID == -1) {
                        throw new ParseException("An invalid character sequence starting with '" + this.text.subSequence(startIndex, this.index) + "' (line " + (startLine + 1) + ", column " + (startColumn + 1) + ")", this.sourceName, startIndex, startLine + 1, startColumn + 1);
                    }
                }
                finally {
                    this.index = startIndex;
                    this.line = startLine;
                    this.column = startColumn;
                }
                Token result = new Token(lastHitID, image.substring(0, lastHitImageLength).intern(), this.text.subSequence(startIndex, lastHitIndex).toString().intern(), this.sourceName, startIndex, startLine + 1, startColumn + 1);
                this.index = lastHitIndex;
                this.line = lastHitLine;
                this.column = lastHitColumn;
                return result;
            }

            protected char nextChar() throws ParseException, IndexOutOfBoundsException {
                return this.nextExactChar();
            }

            protected final char nextUnicodeEscapedChar() throws ParseException, IndexOutOfBoundsException {
                int startIndex = this.index;
                int startLine = this.line;
                int startColumn = this.column;
                int index = startIndex;
                if (this.text.charAt(index) == '\\' && index + 1 < this.end && this.text.charAt(index + 1) == 'u') {
                    int count = 0;
                    while (index >= 0 && this.text.charAt(index--) == '\\') {
                        ++count;
                    }
                    if (count % 2 == 0) {
                        return this.nextExactChar();
                    }
                } else {
                    return this.nextExactChar();
                }
                char ch = this.nextExactChar();
                assert (ch == '\\');
                ch = this.nextExactChar();
                assert (ch == 'u');
                try {
                    while ((ch = this.nextExactChar()) == 'u') {
                    }
                    StringBuffer number = new StringBuffer(4);
                    number.append(ch);
                    number.append(this.nextExactChar());
                    number.append(this.nextExactChar());
                    number.append(this.nextExactChar());
                    int code = Integer.parseInt(number.toString(), 16);
                    return (char)code;
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                throw new ParseException("illigal Unicode escape: " + this.text.subSequence(startIndex, this.index), this.sourceName, startIndex, startLine, startColumn);
            }

            private final char nextExactChar() throws ParseException, IndexOutOfBoundsException {
                if (this.index >= this.end) {
                    throw new IndexOutOfBoundsException();
                }
                char ch = this.text.charAt(this.index++);
                switch (ch) {
                    case '\r': {
                        if (this.index < this.end && this.text.charAt(this.index) == '\n') break;
                    }
                    case '\n': {
                        ++this.line;
                        this.column = 0;
                        break;
                    }
                    case '\t': {
                        if (this.tabStop < 1) break;
                        this.column = this.column - this.column % this.tabStop + this.tabStop;
                        break;
                    }
                    default: {
                        ++this.column;
                    }
                }
                return ch;
            }
        }

        public static abstract class Node
        implements net.wasamon.wallet.preprocessor.PreProcessorParser$Node {
            private List childNodes;

            public Node(List childNodes) {
                this.childNodes = childNodes;
            }

            public List getChildNodes() {
                return this.childNodes;
            }

            public void replaceChild(net.wasamon.wallet.preprocessor.PreProcessorParser$Node oldChild, net.wasamon.wallet.preprocessor.PreProcessorParser$Node newChild) {
                PreProcessorParser.__replaceAll__notavacc_reserved(this.getChildNodes(), oldChild, newChild);
            }

            public String toString() {
                StringWriter buffer = new StringWriter();
                PrintWriter writer = new PrintWriter(buffer);
                net.wasamon.wallet.preprocessor.PreProcessorParser$Node node = this;
                while (!(node instanceof net.wasamon.wallet.preprocessor.PreProcessorParser$Token)) {
                    if (node.getChildNodes().isEmpty()) {
                        node = null;
                        break;
                    }
                    node = (net.wasamon.wallet.preprocessor.PreProcessorParser$Node)node.getChildNodes().get(0);
                }
                if (node != null) {
                    net.wasamon.wallet.preprocessor.PreProcessorParser$Token token = (net.wasamon.wallet.preprocessor.PreProcessorParser$Token)node;
                    try {
                        writer.print(String.valueOf(token.getSourceName()) + ":");
                        writer.print(String.valueOf(token.getLine()) + ":");
                        writer.println(token.getOriginalImage());
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                Node.toString(this, 0, writer);
                writer.close();
                if (writer.checkError()) {
                    throw new RuntimeException();
                }
                return buffer.toString();
            }

            private static void toString(net.wasamon.wallet.preprocessor.PreProcessorParser$Node node, int indent, PrintWriter writer) {
                int i = 0;
                while (i < indent) {
                    writer.print("  ");
                    ++i;
                }
                if (node instanceof Token) {
                    Token token = (Token)node;
                    writer.println(token);
                } else {
                    String binaryName = node.getClass().getName();
                    binaryName = binaryName.substring(binaryName.lastIndexOf(".") + 1);
                    binaryName = binaryName.substring(binaryName.lastIndexOf("$") + 1);
                    writer.println(binaryName);
                    ++indent;
                    for (net.wasamon.wallet.preprocessor.PreProcessorParser$Node n : node.getChildNodes()) {
                        Node.toString(n, indent, writer);
                    }
                }
            }
        }

        public static class Token
        extends Node
        implements net.wasamon.wallet.preprocessor.PreProcessorParser$Token {
            private final int symbolID;
            private final String image;
            private final String originalImage;
            private final String sourceName;
            private final int index;
            private final int line;
            private final int column;

            public Token(int symbolID, String image) {
                this(symbolID, image, image, null, -1, -1, -1);
            }

            public Token(int symbolID, String image, String originalImage, String sourceName, int index, int line, int column) {
                super(Collections.EMPTY_LIST);
                this.symbolID = symbolID;
                this.image = image;
                this.originalImage = originalImage;
                this.sourceName = sourceName;
                this.index = index;
                this.line = line;
                this.column = column;
            }

            public Token(int symbolID, String image, String originalImage, net.wasamon.wallet.preprocessor.PreProcessorParser$Token token) {
                super(Collections.EMPTY_LIST);
                String sourceName = null;
                int index = -1;
                int line = -1;
                int column = -1;
                try {
                    sourceName = token.getSourceName();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    index = token.getIndex();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    line = token.getLine();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    column = token.getColumn();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                this.symbolID = symbolID;
                this.image = image;
                this.originalImage = originalImage;
                this.sourceName = sourceName;
                this.index = index;
                this.line = line;
                this.column = column;
            }

            public int getSymbolID() {
                return this.symbolID;
            }

            public boolean isWhite() {
                return 1 <= this.symbolID && this.symbolID < 4;
            }

            public String getImage() {
                return this.image;
            }

            public String getOriginalImage() {
                return this.originalImage;
            }

            public String getSourceName() throws UnsupportedOperationException {
                if (this.sourceName == null) {
                    throw new UnsupportedOperationException();
                }
                return this.sourceName;
            }

            public int getIndex() throws UnsupportedOperationException {
                if (this.index == -1) {
                    throw new UnsupportedOperationException();
                }
                return this.index;
            }

            public int getLine() throws UnsupportedOperationException {
                if (this.line == -1) {
                    throw new UnsupportedOperationException();
                }
                return this.line;
            }

            public int getColumn() throws UnsupportedOperationException {
                if (this.column == -1) {
                    throw new UnsupportedOperationException();
                }
                return this.column;
            }

            public String toString() {
                StringBuffer result = new StringBuffer();
                result.append("`");
                String original = this.getOriginalImage();
                int i = 0;
                while (i < original.length()) {
                    char ch = original.charAt(i);
                    switch (ch) {
                        default: {
                            if (ch < ' ' || ch == '\u007f') {
                                result.append("\\u").append(PreProcessorParser.__toHexCode__notavacc_reserved(ch));
                                break;
                            }
                            result.append(ch);
                            break;
                        }
                        case '\n': {
                            result.append("\\n");
                            break;
                        }
                        case '\t': {
                            result.append("\\t");
                            break;
                        }
                        case '\b': {
                            result.append("\\b");
                            break;
                        }
                        case '\r': {
                            result.append("\\r");
                            break;
                        }
                        case '\f': {
                            result.append("\\f");
                        }
                    }
                    ++i;
                }
                result.append("'");
                if (this.column != -1 || this.line != -1) {
                    result.append(" (");
                    if (this.line != -1) {
                        result.append("line ");
                        result.append(this.getLine());
                        if (this.column != -1) {
                            result.append(", ");
                        }
                    }
                    if (this.column != -1) {
                        result.append("column ");
                        result.append(this.getColumn());
                    }
                    result.append(")");
                }
                return result.toString();
            }
        }
    }

    public static abstract class LexicalAnalyzer {
        public abstract Token next() throws ParseException;
    }

    public static interface Node {
        public List getChildNodes();
    }

    protected static class NodeInitializationParameters {
        private Node[] childNodes;
        private List labelsIDList;

        private NodeInitializationParameters() {
        }
    }

    public static class ParseException
    extends Exception {
        private final String sourceName;
        private final int index;
        private final int line;
        private final int column;

        public ParseException(String msg, String sourceName, int index, int line, int column) {
            super(msg);
            this.sourceName = sourceName;
            this.index = index;
            this.line = line;
            this.column = column;
        }

        public ParseException(String msg, Token position) {
            super(msg);
            String sourceName = null;
            int index = -1;
            int line = -1;
            int column = -1;
            try {
                sourceName = position.getSourceName();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                index = position.getIndex();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                line = position.getLine();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                column = position.getColumn();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.sourceName = sourceName;
            this.index = index;
            this.line = line;
            this.column = column;
        }

        public final String getSourceName() throws UnsupportedOperationException {
            if (this.sourceName == null) {
                throw new UnsupportedOperationException();
            }
            return this.sourceName;
        }

        public final int getIndex() throws UnsupportedOperationException {
            if (this.index == -1) {
                throw new UnsupportedOperationException();
            }
            return this.index;
        }

        public final int getLine() throws UnsupportedOperationException {
            if (this.line == -1) {
                throw new UnsupportedOperationException();
            }
            return this.line;
        }

        public final int getColumn() throws UnsupportedOperationException {
            if (this.column == -1) {
                throw new UnsupportedOperationException();
            }
            return this.column;
        }

        public final String getGCCStylePositionString() throws UnsupportedOperationException {
            if (this.line == -1) {
                return this.getSourceName();
            }
            if (this.column == -1) {
                return String.valueOf(this.getSourceName()) + ":" + this.line;
            }
            return String.valueOf(this.getSourceName()) + ":" + this.line + ":" + this.column;
        }

        public static class AmbiguousGrammarError
        extends AssertionError {
            public AmbiguousGrammarError(String message) {
                super((Object)message);
            }
        }
    }

    public static interface Token
    extends Node {
        public int getSymbolID();

        public boolean isWhite();

        public String getImage();

        public String getOriginalImage();

        public String getSourceName() throws UnsupportedOperationException;

        public int getIndex() throws UnsupportedOperationException;

        public int getLine() throws UnsupportedOperationException;

        public int getColumn() throws UnsupportedOperationException;

        public String toString();
    }

    public static class Visitor {
        public void visitAll(Node node) {
            this.visitNode(node);
            for (Node child : node.getChildNodes()) {
                this.visitAll(child);
            }
        }

        protected void visitNode(Node node) {
            this.visit(node);
            if (node instanceof Token) {
                this.visit((Token)node);
            }
        }

        protected void visit(Node node) {
        }

        protected void visit(Token node) {
        }
    }

    private static class __ConcreteSyntaxTree__notavacc_reserved {
        public int reductionID;
        public Object[] children;

        public __ConcreteSyntaxTree__notavacc_reserved(int reductionID, Object[] children) {
            this.reductionID = reductionID;
            this.children = children;
        }
    }

    private static class __GrpahStack__notavacc_reserved {
        public static final __GrpahStack__notavacc_reserved[] EMPTY_STACK = null;
        private __GrpahStack__notavacc_reserved[] previous;
        private Object node;
        private int state;

        private __GrpahStack__notavacc_reserved(__GrpahStack__notavacc_reserved[] previous, Object node, int state) {
            this.previous = previous;
            this.node = node;
            this.state = state;
        }

        public static __GrpahStack__notavacc_reserved push(__GrpahStack__notavacc_reserved[] stack, Object node, int state) {
            return new __GrpahStack__notavacc_reserved(stack, node, state);
        }

        public int topState() {
            return this.state;
        }

        public Object topNode() {
            return this.node;
        }

        public static __GrpahStack__notavacc_reserved[] pop(__GrpahStack__notavacc_reserved stack) {
            return stack.previous;
        }
    }
}

