/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.wallet.preprocessor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import net.wasamon.wallet.preprocessor.PreProcessorException;
import net.wasamon.wallet.preprocessor.PreProcessorParser;

public class PreProcessor {
    private Hashtable<String, String> defineTable;
    private ArrayList includeList = new ArrayList();
    private File baseDir;
    private IfStack ifStack = new IfStack();
    private PrintStream out;

    public PreProcessor() {
        this.defineTable = new Hashtable();
    }

    public void go(File src, InputStream in, OutputStream out) throws PreProcessorException {
        block14: {
            this.out = new PrintStream(out, true);
            this.baseDir = src != null ? src.getParentFile() : new File(".");
            try {
                String s;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "EUC-JP"));
                String line = "";
                while ((s = reader.readLine()) != null) {
                    line = String.valueOf(line) + s + "\n";
                }
                PreProcessorParser.Default.LexicalAnalyzer a = new PreProcessorParser.Default.LexicalAnalyzer("test", line, 8);
                while (true) {
                    PreProcessorParser.Token token = ((PreProcessorParser.LexicalAnalyzer)a).next();
                    boolean flag = false;
                    String str = "";
                    switch (token.getSymbolID()) {
                        case 29: {
                            if (this.defineTable.containsKey(token.getImage())) {
                                str = this.defineTable.get(token.getImage());
                                break;
                            }
                            str = token.getImage();
                            break;
                        }
                        case 0: {
                            break block14;
                        }
                        case 2: {
                            str = "";
                            break;
                        }
                        case 3: {
                            str = "\n";
                            break;
                        }
                        case 4: {
                            this.doDirectiveOperation(token.getImage(), a);
                            str = "\n";
                            break;
                        }
                        default: {
                            str = token.getImage();
                        }
                    }
                    if (this.ifStack.status) {
                        this.out.print(str);
                        continue;
                    }
                    if (!str.equals("\n")) continue;
                    this.out.println(str);
                }
            }
            catch (IOException e) {
                throw new PreProcessorException(e);
            }
            catch (PreProcessorParser.ParseException e) {
                throw new PreProcessorException(e);
            }
        }
    }

    private void doDirectiveOperation(String key, PreProcessorParser.LexicalAnalyzer a) throws PreProcessorException {
        try {
            ArrayList<String> args = new ArrayList<String>();
            block5: while (true) {
                PreProcessorParser.Token token = a.next();
                switch (token.getSymbolID()) {
                    case 0: 
                    case 3: 
                    case 30: {
                        break block5;
                    }
                    default: {
                        args.add(token.getImage());
                        continue block5;
                    }
                }
                break;
            }
            key = key.substring(1).trim();
            if (key.equals("define")) {
                this.doDefineOperation(args.toArray(new String[args.size()]));
            } else if (key.equals("ifdef")) {
                this.doIfDefOperation(args.toArray(new String[args.size()]), true);
            } else if (key.equals("ifndef")) {
                this.doIfDefOperation(args.toArray(new String[args.size()]), false);
            } else if (key.equals("endif")) {
                this.ifStack.pop();
            } else if (key.equals("include")) {
                this.doIncludeOperation(args.toArray(new String[args.size()]));
            } else {
                System.err.println("unsupported directive: " + key);
            }
        }
        catch (PreProcessorParser.ParseException e) {
            throw new PreProcessorException(e);
        }
    }

    public void doIncludeOperation(String[] args) throws PreProcessorException {
        String filename = args[0].substring(1, args[0].length() - 1);
        if (args[0].charAt(0) != '\"' && args[0].charAt(0) != '<') {
            throw new PreProcessorException("syntax error: #include " + args[0]);
        }
        File includeFile = new File(this.baseDir, filename);
        if (!includeFile.exists()) {
            System.err.println("file not found: " + includeFile.getName());
            throw new PreProcessorException("syntax error: #include " + args[0]);
        }
        File originalBaseDir = this.baseDir;
        try {
            this.go(includeFile, new FileInputStream(includeFile), this.out);
        }
        catch (FileNotFoundException e) {
            throw new PreProcessorException(e);
        }
        this.baseDir = originalBaseDir;
        this.includeList.add(args[0]);
    }

    private void doDefineOperation(String[] args) {
        String value = "";
        int i = 1;
        while (i < args.length) {
            value = String.valueOf(value) + args[i];
            ++i;
        }
        this.defineTable.put(args[0], value);
    }

    private void doIfDefOperation(String[] args, boolean flag) {
        String key = args[0];
        this.ifStack.push(this.defineTable.containsKey(key) == flag);
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            File f = new File(args[0]);
            new PreProcessor().go(f, new FileInputStream(f), System.out);
        } else {
            new PreProcessor().go(null, System.in, System.out);
        }
    }

    class IfStack {
        ArrayList<Boolean> stack = new ArrayList();
        boolean status = true;

        public void push(boolean flag) {
            this.stack.add(new Boolean(flag));
            if (!flag) {
                this.status = false;
            }
        }

        public boolean pop() {
            boolean f = this.stack.get(this.stack.size() - 1);
            this.stack.remove(this.stack.size() - 1);
            this.status = true;
            for (Boolean b : this.stack) {
                if (b.booleanValue()) continue;
                this.status = false;
                break;
            }
            return f;
        }
    }
}

