/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.wallet.binutils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import net.wasamon.mjlib.xml.XMLUtil;
import net.wasamon.wallet.binutils.AssemblerException;
import net.wasamon.wallet.binutils.DataElement;
import net.wasamon.wallet.binutils.DataElementComparator;
import net.wasamon.wallet.binutils.InstructionTable;
import net.wasamon.wallet.binutils.Linker;
import net.wasamon.wallet.binutils.Parser;
import net.wasamon.wallet.binutils.ProgramCode;
import net.wasamon.wallet.binutils.Section;
import org.w3c.dom.Node;

public class TextRegion
implements Section {
    private ArrayList programs = new ArrayList();
    private Hashtable labels = new Hashtable();
    private Hashtable constants = new Hashtable();
    private int offset;
    private int align;

    public void clear() {
        this.programs.clear();
        this.labels.clear();
        this.constants.clear();
    }

    private boolean isImmidiate(String s) {
        if (s == null || s.equals("")) {
            return false;
        }
        return s.charAt(0) != 'r';
    }

    public void addData(Parser parser, String value) throws AssemblerException {
        String[] inst = new String[2];
        int offset = 0;
        String[] token = parser.getLineItems(value);
        int i = 0;
        while (i < token.length) {
            if (!token[i].equals("")) {
                if (token[i].charAt(0) == ';' || token[i].charAt(0) == '#' || token[i].startsWith("/*")) break;
                if (offset < 2) {
                    inst[offset] = token[i];
                    ++offset;
                } else {
                    throw new AssemblerException(value);
                }
            }
            ++i;
        }
        if (offset > 0) {
            if (inst[1] != null) {
                this.programs.add(new ProgramCode(inst[0], parser.getArgumentItems(inst[1])));
            } else {
                this.programs.add(new ProgramCode(inst[0], null));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execCommand(Parser parser, String value) throws AssemblerException {
        if (value.startsWith(".constant")) {
            String[] a = parser.getArgumentItems(parser.getLineArgument(value));
            try {
                if (this.constants.containsKey(a[0])) return;
                DataElement d = new DataElement(this.constants.size());
                if (a[0].startsWith("c_")) {
                    d.type = 0;
                    d.data.write(DataUtil.toByteArray(DataUtil.parseInt(a[0].substring(2))));
                } else if (a[0].startsWith("f_")) {
                    d.type = 0;
                    d.data.write(DataUtil.toByteArray(Float.floatToIntBits(Float.parseFloat(a[0].substring(2)))));
                }
                this.constants.put(a[0], d);
                return;
            }
            catch (IOException e) {
                throw new AssemblerException(e.getMessage());
            }
        } else {
            if (!value.startsWith(".align")) return;
            this.align = DataUtil.parseInt(parser.getLineArgument(value));
        }
    }

    public void addLabel(String label) {
        this.labels.put(label, new Integer(this.programs.size()));
    }

    private void writeProgramCode(ByteArrayOutputStream out, Linker linker, InstructionTable inst) throws AssemblerException, IOException {
        for (ProgramCode p : this.programs) {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            tmp.write((byte)(inst.toInstructionCode(p.inst) & 0xFF));
            int i = 0;
            while (i < 3) {
                if (p.args[i] == null) {
                    tmp.write(0);
                } else if (this.isImmidiate(p.args[i])) {
                    tmp.write(DataUtil.toByteArray(linker.toValue(p.args[i]), 2));
                } else {
                    tmp.write((byte)linker.toValue(p.args[i]));
                }
                ++i;
            }
            out.write(tmp.toByteArray(), 0, 4);
        }
    }

    private void writeConstants(ByteArrayOutputStream out) throws IOException {
        ArrayList dataList = new ArrayList(this.constants.values());
        Collections.sort(dataList, new DataElementComparator());
        for (DataElement data : dataList) {
            out.write(data.data.toByteArray());
        }
    }

    public ByteArrayOutputStream genByteStream(Linker linker, InstructionTable inst) throws IOException, AssemblerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeProgramCode(out, linker, inst);
        this.writeConstants(out);
        out.flush();
        return out;
    }

    public int getLabelValue(String label) {
        int val = -1;
        if (label.startsWith("_") && this.labels.containsKey(label.substring(1))) {
            val = (Integer)this.labels.get(label.substring(1)) * 4 + this.offset;
        } else if ((label.startsWith("c_") || label.startsWith("f_")) && this.constants.containsKey(label)) {
            val = (((DataElement)this.constants.get((Object)label)).offset + this.programs.size()) * 4 + this.offset;
        }
        return val;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int size() {
        return (this.programs.size() + this.constants.size()) * 4;
    }

    public void outputAsXML(PrintWriter writer) throws IOException {
        for (ProgramCode programCode : this.programs) {
            programCode.outputAsXML(writer);
        }
        for (Map.Entry entry : this.labels.entrySet()) {
            writer.println(XMLUtil.toElementString("label", new String[]{"label", (String)entry.getKey(), "offset", entry.getValue().toString()}));
        }
        for (Map.Entry entry : this.constants.entrySet()) {
            ((DataElement)entry.getValue()).outputAsXML(writer, (String)entry.getKey());
        }
    }

    public void inputFromXML(Node node) throws XMLParserException {
        String label;
        Node[] nodes = XMLParser.getNamedNodeArray(node, "code");
        int i = 0;
        while (i < nodes.length) {
            this.programs.add(ProgramCode.inputFromXML(nodes[i]));
            ++i;
        }
        nodes = XMLParser.getNamedNodeArray(node, "label");
        i = 0;
        while (i < nodes.length) {
            label = XMLParser.getAttribute(nodes[i], "label").getNodeValue();
            int offset = DataUtil.parseInt(XMLParser.getAttribute(nodes[i], "offset").getNodeValue());
            this.labels.put(label, new Integer(offset));
            ++i;
        }
        nodes = XMLParser.getNamedNodeArray(node, "data");
        i = 0;
        while (i < nodes.length) {
            label = XMLParser.getAttribute(nodes[i], "label").getNodeValue();
            this.constants.put(label, DataElement.inputFromXML(nodes[i]));
            ++i;
        }
    }
}

