/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.wallet.binutils;

import java.util.regex.Pattern;
import net.wasamon.wallet.binutils.Parser;

public class SimpleAssembler
implements Parser {
    static Pattern linePattern = Pattern.compile("\\s+");
    static Pattern argPattern = Pattern.compile(",");

    public String getLabelStr(String key) {
        return key.substring(0, key.length() - 1);
    }

    public String getSectionName(String section) {
        String[] token = linePattern.split(section);
        return token[1].substring(1, token[1].length() - 1);
    }

    public boolean isAssemblerCommand(String key) {
        return key.startsWith(".");
    }

    public boolean isLabel(String key) {
        return key.endsWith(":");
    }

    public boolean isSection(String key) {
        return key.startsWith(".section");
    }

    public boolean isComment(String key) {
        return key.startsWith(";") || key.startsWith("/*");
    }

    public String[] getArgumentItems(String s) {
        return argPattern.split(s);
    }

    public String getLineArgument(String s) {
        return linePattern.split(s)[1];
    }

    public String[] getLineItems(String s) {
        return linePattern.split(s);
    }
}

