/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.wallet.binutils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import net.wasamon.wallet.binutils.AssemblerException;
import net.wasamon.wallet.binutils.DataElement;
import net.wasamon.wallet.binutils.DataElementComparator;
import net.wasamon.wallet.binutils.Linker;
import net.wasamon.wallet.binutils.Parser;
import net.wasamon.wallet.binutils.Section;
import org.w3c.dom.Node;

public class DataRegion
implements Section {
    private int align;
    private int count;
    private int offset;
    Hashtable labels = new Hashtable();
    DataElement currentElement;

    public void addData(Parser parser, String value) throws AssemblerException {
        System.out.println("[??] " + value);
    }

    public void execCommand(Parser parser, String value) throws AssemblerException {
        if (value.startsWith(".align")) {
            this.align = DataUtil.parseInt(parser.getLineArgument(value));
            this.currentElement = null;
        } else if (value.startsWith(".comm")) {
            String[] args = parser.getArgumentItems(parser.getLineArgument(value));
            this.addLabel(args[0]);
            try {
                this.currentElement.data.write(DataUtil.toByteArray(0));
            }
            catch (IOException e) {
                throw new AssemblerException(e.getMessage());
            }
            this.count += DataUtil.parseInt(args[1]);
            this.currentElement.length = DataUtil.parseInt(args[1]);
        } else if (value.startsWith(".byte")) {
            this.currentElement.data.write((byte)DataUtil.parseInt(parser.getLineArgument(value)));
            ++this.count;
            ++this.currentElement.length;
        } else if (value.startsWith(".long")) {
            try {
                this.currentElement.data.write(DataUtil.toByteArray(DataUtil.parseInt(parser.getLineArgument(value))));
            }
            catch (IOException e) {
                throw new AssemblerException(e.getMessage());
            }
            this.count += 4;
            this.currentElement.length += 4;
        }
    }

    public void addLabel(String label) {
        this.currentElement = new DataElement(this.count);
        this.labels.put(label, this.currentElement);
    }

    public ByteArrayOutputStream genByteStream(Linker linker) throws IOException {
        ArrayList dataList = new ArrayList(this.labels.values());
        Collections.sort(dataList, new DataElementComparator());
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        for (DataElement data : dataList) {
            ostream.write(data.data.toByteArray());
        }
        ostream.flush();
        return ostream;
    }

    public int getLabelValue(String label) {
        int val = -1;
        if (this.labels.containsKey(label.substring(1))) {
            val = ((DataElement)this.labels.get((Object)label.substring((int)1))).offset + this.offset;
        }
        return val;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int size() {
        return this.count;
    }

    public void outputAsXML(PrintWriter writer) throws IOException {
        for (Map.Entry data : this.labels.entrySet()) {
            String label = (String)data.getKey();
            ((DataElement)data.getValue()).outputAsXML(writer, label);
        }
    }

    public void inputFromXML(Node node) throws XMLParserException {
        Node[] n = XMLParser.getNamedNodeArray(node, "data");
        int i = 0;
        while (i < n.length) {
            String label = XMLParser.getAttribute(n[i], "label").getNodeValue();
            this.labels.put(label, DataElement.inputFromXML(n[i]));
            ++i;
        }
    }
}

