/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.wasamon.mjlib.util.GetOpt;
import net.wasamon.mjlib.util.GetOptException;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class MakeInitialize {
    private String src;
    private static final int OUTPUT_JAVA = 0;
    private static final int OUTPUT_HTML = 1;
    private InitElement root;
    private String className;

    public MakeInitialize(String file) throws Exception {
        this.src = file;
        File f = new File(file);
        if (!f.exists()) {
            throw new Exception("no such file: " + file);
        }
        try {
            this.root = new InitElement();
            Node top = XMLParser.getTopNode(f);
            this.className = XMLParser.getAttribute(top, "name").getNodeValue();
            this.makeInitElement(top, this.root);
        }
        catch (XMLParserException e) {
            throw new Exception("syntax error: " + e.getMessage());
        }
    }

    private void makeInitElement(Node n, InitElement element) throws XMLParserException {
        this.makeAttribute(XMLParser.getNamedNodeArray(n, "attribute"), element);
        this.makeChild(XMLParser.getNamedNodeArray(n, "child"), element);
        this.makeExecStmt(XMLParser.getNamedNode(n, "exec"), element);
    }

    private void makeExecStmt(Node node, InitElement element) throws XMLParserException {
        element.addExecStmt(XMLParser.getNodeText(node));
    }

    private void makeChild(Node[] nodes, InitElement element) throws XMLParserException {
        int i = 0;
        while (i < nodes.length) {
            Node n = nodes[i];
            String child_name = XMLParser.getAttribute(n, "name").getNodeValue();
            String s = XMLParser.getAttribute(n, "repeatable").getNodeValue();
            boolean repeatableFlag = false;
            if ("true".equals(s)) {
                repeatableFlag = true;
            }
            InitElement elm = new InitElement(child_name, repeatableFlag);
            this.makeInitElement(n, elm);
            element.addChild(elm);
            ++i;
        }
    }

    private void makeAttribute(Node[] nodes, InitElement element) throws XMLParserException {
        int i = 0;
        while (i < nodes.length) {
            Node n = nodes[i];
            String attr_name = XMLParser.getAttribute(n, "name").getNodeValue();
            String attr_type = XMLParser.getAttribute(n, "type").getNodeValue();
            element.addAttr(new InitElementAttr(attr_name, attr_type));
            ++i;
        }
    }

    public String toString() {
        String str = "";
        str = String.valueOf(str) + "class = " + this.className + "\n";
        str = String.valueOf(str) + this.root.toString(0);
        return str;
    }

    public String toJavaSource() {
        String str = "";
        str = String.valueOf(str) + "/* generated automatically by MakeInitialize from " + this.src + " */\n";
        str = String.valueOf(str) + "public void initialize(String id, Node n) throws MicsException{\n";
        str = String.valueOf(str) + "super.initialize(id, n);\n";
        str = String.valueOf(str) + " try{\n";
        str = String.valueOf(str) + this.root.toJavaSource(0);
        str = String.valueOf(str) + "}catch(NumberFormatException e){\n";
        str = String.valueOf(str) + "throw new MicsException(\"configuration syntax error: " + this.className + "\");\n";
        str = String.valueOf(str) + "}catch(XMLParserException e){\n";
        str = String.valueOf(str) + "throw new MicsException(\"configuration syntax error: " + this.className + "\");\n";
        str = String.valueOf(str) + "}\n";
        str = String.valueOf(str) + "}\n";
        return str;
    }

    public String toHTMLTable() {
        String str = "";
        str = String.valueOf(str) + "<!-- generated automatically by MakeInitialize from " + this.src + " -->\n";
        str = String.valueOf(str) + "<table border=\"1\">";
        str = String.valueOf(str) + "<tr><td>" + this.className + "</td></tr>";
        str = String.valueOf(str) + "<tr><td>" + this.root.toHTMLTable() + "</td></tr>";
        str = String.valueOf(str) + "</table>";
        return str;
    }

    public String getText(int mode) {
        if (mode == 1) {
            return this.toHTMLTable();
        }
        return this.toJavaSource();
    }

    private static void usage() {
        System.out.println("usage: MakeInitialize [-o java/html] source");
        System.exit(0);
    }

    public static void main(String[] args) throws GetOptException {
        GetOpt opt = new GetOpt("o:", "", args);
        if (opt.getArgs().length < 1) {
            MakeInitialize.usage();
        }
        int mode = 0;
        if (opt.flag("o")) {
            String value = opt.getValue("o");
            if ("java".equals(value)) {
                mode = 0;
            } else if ("html".equals(value)) {
                mode = 1;
            } else {
                MakeInitialize.usage();
            }
        }
        int i = 0;
        while (i < opt.getArgs().length) {
            try {
                MakeInitialize mi = new MakeInitialize(opt.getArgs()[i]);
                PrintWriter writer = new PrintWriter((Writer)new FileWriter(new File(String.valueOf(opt.getArgs()[i]) + ".output")), true);
                writer.println(mi.getText(mode));
                writer.flush();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    private class InitElement {
        ArrayList initElementAttrArray;
        ArrayList initElementChildArray;
        String name = "root";
        String execStmt;
        boolean repeatableFlag = false;
        Pattern pattern = Pattern.compile("(\\$[0-9a-zA-Z]+)");

        public InitElement() {
            this.initElementAttrArray = new ArrayList();
            this.initElementChildArray = new ArrayList();
        }

        public InitElement(String name, boolean flag) {
            this();
            this.repeatableFlag = flag;
            this.name = name;
        }

        public void addAttr(InitElementAttr attr) {
            this.initElementAttrArray.add(attr);
        }

        public void addChild(InitElement child) {
            this.initElementChildArray.add(child);
        }

        public void addExecStmt(String str) {
            this.execStmt = str;
        }

        public String toString(int offset) {
            String str = "";
            String tab = "";
            int i = 0;
            while (i < offset) {
                tab = String.valueOf(tab) + " ";
                ++i;
            }
            str = String.valueOf(str) + tab + "name = " + this.name + "\n";
            str = String.valueOf(str) + tab + "exec = {" + this.execStmt + "}" + "\n";
            Iterator i2 = this.initElementAttrArray.iterator();
            while (i2.hasNext()) {
                InitElementAttr attr = (InitElementAttr)i2.next();
                str = String.valueOf(str) + tab + "attr: " + attr.name + "/" + attr.type + "\n";
            }
            i2 = this.initElementChildArray.iterator();
            while (i2.hasNext()) {
                InitElement child = (InitElement)i2.next();
                str = String.valueOf(str) + child.toString(offset + 1);
            }
            str = String.valueOf(str) + "\n";
            return str;
        }

        public String toJavaSource(int offset) {
            String str = "";
            String tab = "";
            int i = 0;
            while (i < offset) {
                tab = String.valueOf(tab) + "_";
                ++i;
            }
            str = String.valueOf(str) + "{\n";
            String varPrefix = "init_var_";
            if (!"root".equals(this.name)) {
                varPrefix = String.valueOf(varPrefix) + tab + this.name + "_";
            }
            if (!"root".equals(this.name)) {
                if (this.repeatableFlag) {
                    str = String.valueOf(str) + "ArrayList<Node> " + varPrefix + "obj = ";
                    str = String.valueOf(str) + "XMLParser.getNamedNodeArrayList(n, \"" + this.name + "\");\n";
                    str = String.valueOf(str) + "Iterator<Node> it = " + varPrefix + "obj.iterator();\n";
                    str = String.valueOf(str) + "while(it.hasNext()){\n";
                    str = String.valueOf(str) + "Node " + varPrefix + "node = it.next();\n";
                } else {
                    str = String.valueOf(str) + "Node " + varPrefix + "node = ";
                    str = String.valueOf(str) + "XMLParser.getNamedNode(n, \"" + this.name + "\");\n";
                }
            } else {
                str = String.valueOf(str) + "Node " + varPrefix + "node = n;\n";
            }
            Iterator i2 = this.initElementAttrArray.iterator();
            while (i2.hasNext()) {
                InitElementAttr attr = (InitElementAttr)i2.next();
                str = String.valueOf(str) + attr.type + " " + varPrefix + attr.name + ";\n";
                str = String.valueOf(str) + varPrefix + attr.name + " = ";
                boolean flag = "int".equals(attr.type);
                if (flag) {
                    str = String.valueOf(str) + "DataUtil.parseInt(";
                }
                str = String.valueOf(str) + "XMLParser.getAttribute(" + varPrefix + "node, \"" + attr.name + "\").getNodeValue()";
                if (flag) {
                    str = String.valueOf(str) + ")";
                }
                str = String.valueOf(str) + ";\n";
            }
            Matcher matcher = this.pattern.matcher(this.execStmt);
            StringBuffer sb = new StringBuffer();
            int c = 1;
            while (matcher.find()) {
                matcher.appendReplacement(sb, String.valueOf(varPrefix) + matcher.group(c).substring(1));
            }
            matcher.appendTail(sb);
            str = String.valueOf(str) + sb.toString() + "\n";
            if (this.repeatableFlag) {
                str = String.valueOf(str) + "}\n";
            }
            Iterator i3 = this.initElementChildArray.iterator();
            while (i3.hasNext()) {
                InitElement child = (InitElement)i3.next();
                str = String.valueOf(str) + child.toJavaSource(offset + 1);
            }
            str = String.valueOf(str) + "}\n";
            return str;
        }

        public String toHTMLTable() {
            String str = "";
            str = String.valueOf(str) + "<table border=\"1\" width=\"100%\">\n";
            if (!"root".equals(this.name)) {
                str = String.valueOf(str) + "<tr><th>Name</th><td>" + this.name + "</td></tr>\n";
            }
            Iterator i = this.initElementAttrArray.iterator();
            while (i.hasNext()) {
                InitElementAttr attr = (InitElementAttr)i.next();
                str = String.valueOf(str) + "<tr>";
                str = String.valueOf(str) + "<th>Attribute</th><td>";
                str = String.valueOf(str) + "<table border=\"1\" width=\"100%\"><tr>";
                str = String.valueOf(str) + "<th>name</th><td>" + attr.name + "</td>";
                str = String.valueOf(str) + "<th>type</th><td>" + attr.type + "</td>";
                str = String.valueOf(str) + "</tr></table>";
                str = String.valueOf(str) + "</td>";
                str = String.valueOf(str) + "</tr>";
            }
            i = this.initElementChildArray.iterator();
            while (i.hasNext()) {
                InitElement child = (InitElement)i.next();
                str = String.valueOf(str) + "<tr>";
                str = String.valueOf(str) + "<th>child</th>";
                str = String.valueOf(str) + "<td>\n";
                str = String.valueOf(str) + child.toHTMLTable();
                str = String.valueOf(str) + "</td></tr>";
            }
            str = String.valueOf(str) + "</table>\n";
            return str;
        }
    }

    private class InitElementAttr {
        String name;
        String type;

        public InitElementAttr(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }
}

