/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.rlu;

import java.io.InputStream;
import java.io.OutputStream;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.ConfigErrorException;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.wallet.binutils.UnknownInstructionException;
import org.w3c.dom.Node;

public class LogicUnit
extends MicsElement
implements DataBuffer,
ExecutableElement,
ChannelConnectable {
    public static final int major_version = 1;
    public static final int minor_version = 0;
    public static final int revision = 0;
    public static final int INST_NOP = 0;
    public static final int INST_ADD = 1;
    public static final int INST_SUB = 2;
    public static final int INST_AND = 3;
    public static final int INST_OR = 4;
    public static final int INST_MUL0 = 5;
    public static final int INST_MULT = 6;
    public static final int SHIFT_NONE = 0;
    public static final int SHIFT_LEFT = 1;
    public static final int SHIFT_RIGHT = 2;
    private char[] input = new char[3];
    private char[] output = new char[3];
    private int preShifter = 0;
    private int postShifter = 0;
    private int inst = 0;
    private DataBuffer[] connects;
    InputRegister[] srcReg = new InputRegister[2];
    private Channel bus;
    private int addr;

    public void initialize(DataBuffer[] connects) {
        this.connects = connects;
        this.srcReg[0] = new InputRegister();
        this.srcReg[1] = new InputRegister();
        this.reset();
    }

    public void reset() {
        this.input[0] = '\u0000';
        this.input[1] = '\u0000';
        this.input[2] = '\u0000';
        this.output[0] = '\u0000';
        this.output[1] = '\u0000';
        this.output[2] = '\u0000';
    }

    private int shifter(int s, int value) throws ConfigErrorException {
        switch (s) {
            case 0: {
                break;
            }
            case 1: {
                value <<= 1;
                break;
            }
            case 2: {
                value >>= 1;
                break;
            }
            default: {
                throw new ConfigErrorException();
            }
        }
        return value;
    }

    void setChannel(Channel bus, int addr) {
        this.bus = bus;
        this.addr = addr;
    }

    public ExecInfo exec_first() throws MicsException {
        RandomAccessMemoryDataPacket d;
        ExecInfo info = new ExecInfo();
        DataBuffer src = this.connects[this.srcReg[0].dir];
        if (src != null) {
            d = (RandomAccessMemoryDataPacket)src.read(RandomAccessMemoryDataPacket.readPacket(this.srcReg[0].regID * 2, 2, 8));
            this.input[0] = DataUtil.toChar(d.data, 0, 2);
        }
        if ((src = this.connects[this.srcReg[1].dir]) != null) {
            d = (RandomAccessMemoryDataPacket)src.read(RandomAccessMemoryDataPacket.readPacket(this.srcReg[1].regID * 2, 2, 8));
            this.input[1] = DataUtil.toChar(d.data, 0, 2);
        }
        if ((src = this.connects[this.srcReg[0].dir]) != null) {
            d = (RandomAccessMemoryDataPacket)src.read(RandomAccessMemoryDataPacket.readPacket(4, 2, 8));
            this.input[2] = DataUtil.toChar(d.data, 0, 2);
        }
        info.setTerminatableFlag(true);
        return info;
    }

    public ExecInfo exec_second() throws MicsException {
        ExecInfo info = new ExecInfo();
        int tmp = DataUtil.toInteger(this.input[0], this.input[1]);
        tmp = this.shifter(this.preShifter, tmp);
        switch (this.inst) {
            case 0: {
                break;
            }
            case 1: {
                tmp = this.input[0] + this.input[1];
                break;
            }
            case 2: {
                tmp = this.input[0] - this.input[1];
                break;
            }
            case 3: {
                tmp = this.input[0] & this.input[1];
                break;
            }
            case 4: {
                tmp = this.input[0] | this.input[1];
                break;
            }
            case 5: {
                if ((this.input[1] & '\u0001') == 1) {
                    tmp = this.input[0];
                    tmp = DataUtil.toInteger(DataUtil.toCharL(tmp), this.input[1]);
                    break;
                }
                tmp = DataUtil.toInteger('\u0000', this.input[1]);
                break;
            }
            case 6: {
                if ((this.input[1] & '\u0001') != 1) break;
                tmp = this.input[0] + this.input[2];
                tmp = DataUtil.toInteger(DataUtil.toCharL(tmp), this.input[1]);
                break;
            }
            default: {
                throw new ConfigErrorException();
            }
        }
        tmp = this.shifter(this.postShifter, tmp);
        this.output[0] = DataUtil.toCharH(tmp);
        this.output[1] = DataUtil.toCharL(tmp);
        this.output[2] = this.input[2];
        if (this.bus != null) {
            this.writeOutput();
        }
        info.setTerminatableFlag(true);
        return info;
    }

    private void writeOutput() throws MicsException {
        MicsDataPacket p = RandomAccessMemoryDataPacket.writePacket(this.addr, 1, 16, DataUtil.toByteArray(this.output[0], 2));
        this.bus.writeRequest(this, p);
        p = RandomAccessMemoryDataPacket.writePacket(this.addr + 2, 1, 16, DataUtil.toByteArray(this.output[1], 2));
        this.bus.writeRequest(this, p);
    }

    public void setLogicUnit(MicsDataPacket p) {
        byte[] data = ((RandomAccessMemoryDataPacket)p).data;
        this.setInst(data[0] & 0xFF);
        this.setPreSfhiter(data[1] >> 2 & 3);
        this.setPostShifter(data[1] & 3);
        this.setSrcRegisterRegisterID(0, data[1] >> 7 & 1);
        this.setSrcRegisterRegisterID(1, data[1] >> 6 & 1);
        this.setSrcRegisterDir(0, data[2] & 0xFF);
        this.setSrcRegisterDir(1, data[3] & 0xFF);
    }

    private void setInst(int value) {
        this.inst = value;
    }

    private void setPreSfhiter(int value) {
        this.preShifter = value;
    }

    private void setPostShifter(int value) {
        this.postShifter = value;
    }

    private void setSrcRegisterRegisterID(int reg, int value) {
        this.srcReg[reg].regID = value;
    }

    private void setSrcRegisterDir(int reg, int value) {
        this.srcReg[reg].dir = value;
    }

    public String getShiftOpString() {
        String str = "";
        switch (this.preShifter) {
            case 2: {
                str = String.valueOf(str) + "R";
                break;
            }
            case 1: {
                str = String.valueOf(str) + "L";
                break;
            }
            case 0: {
                str = String.valueOf(str) + "N";
                break;
            }
            default: {
                str = String.valueOf(str) + "E";
            }
        }
        switch (this.postShifter) {
            case 2: {
                str = String.valueOf(str) + "R";
                break;
            }
            case 1: {
                str = String.valueOf(str) + "L";
                break;
            }
            case 0: {
                str = String.valueOf(str) + "N";
                break;
            }
            default: {
                str = String.valueOf(str) + "E";
            }
        }
        return str;
    }

    public String getLogicUnitInstString() {
        switch (this.inst) {
            case 0: {
                return "NOP  ";
            }
            case 1: {
                return "ADD  ";
            }
            case 2: {
                return "SUB  ";
            }
            case 3: {
                return "AND  ";
            }
            case 4: {
                return "OR   ";
            }
            case 5: {
                return "MUL0 ";
            }
            case 6: {
                return "MULT ";
            }
        }
        return "ERROR";
    }

    public static int getInstructionCode(String str) throws UnknownInstructionException {
        if (str == null || str.equals("")) {
            throw new UnknownInstructionException();
        }
        if (str.equals("NOP")) {
            return 0;
        }
        if (str.equals("ADD")) {
            return 1;
        }
        if (str.equals("SUB")) {
            return 2;
        }
        if (str.equals("AND")) {
            return 3;
        }
        if (str.equals("OR")) {
            return 4;
        }
        if (str.equals("MUL0")) {
            return 5;
        }
        if (str.equals("MULT")) {
            return 6;
        }
        throw new UnknownInstructionException();
    }

    public static int getShiftOpCode(String str) throws UnknownInstructionException {
        if (str == null || str.equals("")) {
            throw new UnknownInstructionException();
        }
        if (str.equals("RIGHT")) {
            return 2;
        }
        if (str.equals("LEFT")) {
            return 1;
        }
        if (str.equals("NONE")) {
            return 0;
        }
        throw new UnknownInstructionException();
    }

    public String[] getConnectedElements() {
        return null;
    }

    public String getImagePath() {
        return null;
    }

    public void initialize(String base, Node node) throws MicsException {
    }

    public void dump(int offset, int len, OutputStream writer) throws DataBufferException {
    }

    public MicsDataPacket read(MicsDataPacket data) {
        RandomAccessMemoryDataPacket p = (RandomAccessMemoryDataPacket)data;
        return RandomAccessMemoryDataPacket.writePacket(p.addr, 1, 16, DataUtil.toByteArray(this.output[p.addr / 2]));
    }

    public int size() {
        return 0;
    }

    public String toString(int addr, int length) {
        return null;
    }

    public void write(MicsDataPacket data) {
    }

    public void write(int offset, InputStream reader) throws DataBufferException {
    }

    public int getChannelOffset(Channel c) {
        return 0;
    }

    public void writeback(MicsDataPacket data) throws MicsException {
    }

    class InputRegister {
        int regID;
        int dir;

        InputRegister() {
        }
    }
}

