/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.rlu;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.wasamon.mics.processor.rlu.LogicUnit;
import net.wasamon.mics.processor.rlu.ReconfigurableUnit;

class ConfigDataViewer {
    private ConfigDataCanvas canvas;
    private Frame frame = new Frame("Config Data Viewer");

    public ConfigDataViewer() {
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ConfigDataViewer.this.frame.setVisible(false);
            }
        });
        this.frame.setSize(600, 600);
        this.canvas = new ConfigDataCanvas();
        this.frame.add(this.canvas);
        this.frame.setVisible(false);
    }

    public void setReconfigurableUnit(ReconfigurableUnit rp) {
        this.canvas.setReconfigurableUnit(rp);
        this.frame.setTitle("Config Data Viewer (ID=" + rp.id() + ")");
        this.frame.setVisible(true);
    }

    public void repaint() {
        this.canvas.repaint();
    }

    class ConfigDataCanvas
    extends Canvas {
        private static final long serialVersionUID = 1L;
        private ReconfigurableUnit rp = null;
        private int offset = 60;
        private int luwidth = 60;
        private int luheight = 60;

        private ConfigDataCanvas() {
        }

        private void setReconfigurableUnit(ReconfigurableUnit rp) {
            this.rp = rp;
            this.repaint();
        }

        private int px(int x) {
            return this.offset + x * this.luwidth;
        }

        private int py(int y) {
            return this.offset + y * this.luheight;
        }

        private void paintLogicUnit(Graphics g, int n) {
            int i = 0;
            while (i < n) {
                int j = 0;
                while (j < n) {
                    g.drawRect(this.px(j), this.py(i), this.luwidth, this.luheight);
                    LogicUnit lu0 = this.rp.unit[i * n + j];
                    g.drawString(lu0.getLogicUnitInstString(), this.px(j) + 5, this.py(i) + 14);
                    g.drawString(lu0.getShiftOpString(), this.px(j) + 5, this.py(i) + 28);
                    ++j;
                }
                ++i;
            }
        }

        private Color getRegColor(int regID) {
            if (regID == 0) {
                return Color.blue;
            }
            return Color.red;
        }

        private Point getDirectinValue(int dir) {
            switch (dir) {
                case 2: {
                    return new Point(-1, -1);
                }
                case 3: {
                    return new Point(0, -1);
                }
                case 4: {
                    return new Point(1, -1);
                }
                case 1: {
                    return new Point(-1, 0);
                }
                case 5: {
                    return new Point(1, 0);
                }
            }
            return new Point(0, 0);
        }

        private void paintDirection(Graphics g, int n) {
            int i = 0;
            while (i < n) {
                int j = 0;
                while (j < n) {
                    LogicUnit lu0 = this.rp.unit[i * n + j];
                    g.setColor(this.getRegColor(lu0.srcReg[0].regID));
                    Point p = this.getDirectinValue(lu0.srcReg[0].dir);
                    g.drawLine(this.px(j) + 28, this.py(i) + 28, this.px(j) + 28 + p.x * 60, this.py(i) + 28 + p.y * 60);
                    g.setColor(this.getRegColor(lu0.srcReg[1].regID));
                    p = this.getDirectinValue(lu0.srcReg[1].dir);
                    g.drawLine(this.px(j) + 32, this.py(i) + 32, this.px(j) + 32 + p.x * 60, this.py(i) + 32 + p.y * 60);
                    ++j;
                }
                ++i;
            }
            g.setColor(Color.black);
        }

        public void paint(Graphics g) {
            if (this.rp == null) {
                return;
            }
            int n = (int)Math.sqrt(this.rp.size());
            this.paintDirection(g, n);
            this.paintLogicUnit(g, n);
        }
    }
}

