/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.rlu;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.wasamon.mics.processor.rlu.LogicUnit;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.wallet.binutils.AssemblerException;
import net.wasamon.wallet.binutils.UnknownInstructionException;

public class ConfigDataAssembler {
    public static final int NonDirection = 0;
    public static final int West = 1;
    public static final int NorthWest = 2;
    public static final int North = 3;
    public static final int NorthEast = 4;
    public static final int East = 5;
    private ArrayList programs = new ArrayList();
    private String currentFile;
    private int nUnits;
    private Pattern linePattern = Pattern.compile("[, ]+");

    public void parser(String f) throws IOException, FileNotFoundException {
        try {
            this.currentFile = f;
            this.programs.clear();
            File file = new File(f);
            File dest = this.parser(file);
            System.out.println(String.valueOf(f) + " -> " + file.getParent() + "/" + dest.getName());
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(0);
        }
    }

    public File parser(File file) throws UnknownInstructionException, AssemblerException, IOException, FileNotFoundException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = "";
        int count = 0;
        while ((line = reader.readLine()) != null) {
            this.parseLine(line, ++count);
        }
        ByteArrayOutputStream hex = null;
        hex = this.getObjectCode();
        int i = file.getName().lastIndexOf(46);
        File dest = new File(file.getParent(), String.valueOf(file.getName().substring(0, i)) + ".cnf");
        FileOutputStream fos = new FileOutputStream(dest);
        hex.writeTo(fos);
        fos.flush();
        fos.close();
        hex.close();
        return dest;
    }

    private ByteArrayOutputStream getObjectCode() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] context = new byte[this.nUnits * this.nUnits * 4];
        ConfigData data = null;
        int i = 0;
        while (i < this.programs.size()) {
            data = (ConfigData)this.programs.get(i);
            int id = data.id[0] * this.nUnits + data.id[1];
            context[4 * id] = data.inst;
            context[4 * id + 1] = data.shiftOp;
            context[4 * id + 2] = (byte)this.getDirectionID(id, data.src0[0] * this.nUnits + data.src0[1]);
            context[4 * id + 3] = (byte)this.getDirectionID(id, data.src1[0] * this.nUnits + data.src1[1]);
            ++i;
        }
        out.write(context, 0, context.length);
        out.flush();
        return out;
    }

    private int getDirectionID(int unitID, int srcID) {
        int diff = unitID - srcID;
        int dir = 0;
        if (diff == 0) {
            dir = 0;
        } else if (diff == this.nUnits + 1) {
            dir = 2;
        } else if (diff == this.nUnits) {
            dir = 3;
        } else if (diff == this.nUnits - 1) {
            dir = 4;
        } else if (diff == 1) {
            dir = 1;
        } else if (diff == -1) {
            dir = 5;
        } else {
            System.err.println("[E] Illegal Direction at " + this.getClass().getName() + " " + srcID + "->" + unitID);
        }
        return dir;
    }

    private void parseAssemblerIndicate(String str) throws AssemblerException {
        StringTokenizer st = new StringTokenizer(str, " ");
        String[] token = new String[st.countTokens()];
        int i = 0;
        while (i < token.length) {
            token[i] = st.nextToken();
            ++i;
        }
        if (".size".equals(token[0])) {
            try {
                this.nUnits = DataUtil.parseInt(token[1]);
            }
            catch (NumberFormatException e) {
                throw new AssemblerException("syntax error");
            }
        } else {
            throw new AssemblerException("Unknown parameter: " + token[0]);
        }
    }

    private void parseLine(String str, int number) throws UnknownInstructionException, AssemblerException {
        if (str.equals("")) {
            return;
        }
        String[] token = null;
        token = this.linePattern.split(str);
        if (token[0].charAt(0) == '#') {
            return;
        }
        if (token[0].charAt(0) == '.') {
            try {
                this.parseAssemblerIndicate(str);
                return;
            }
            catch (AssemblerException e) {
                throw new AssemblerException(String.valueOf(e.getMessage()) + " " + this.currentFile + " at line " + number);
            }
        }
        if (token.length != 6) {
            int i = 0;
            while (i < token.length) {
                ++i;
            }
            throw new AssemblerException("syntax error: " + this.currentFile + " at line " + number);
        }
        this.programs.add(new ConfigData(token));
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("no input file");
            System.exit(0);
        }
        ConfigDataAssembler asm = new ConfigDataAssembler();
        int i = 0;
        while (i < args.length) {
            asm.parser(args[i]);
            ++i;
        }
    }

    class ConfigData {
        public int[] id;
        public byte inst;
        public byte shiftOp;
        public int[] src0;
        public int[] src1;
        private Pattern argPattern = Pattern.compile(":");

        public ConfigData(String[] token) throws UnknownInstructionException {
            this.inst = (byte)LogicUnit.getInstructionCode(token[1].toUpperCase());
            this.src0 = this.getLogicUnitID(token[4]);
            this.src1 = this.getLogicUnitID(token[5]);
            this.id = this.getLogicUnitID(token[0]);
            this.shiftOp = (byte)((LogicUnit.getShiftOpCode(token[2].toUpperCase()) << 2) + LogicUnit.getShiftOpCode(token[3].toUpperCase()));
            if (this.src0[2] != 0) {
                if (this.src0[2] == 1) {
                    this.shiftOp = (byte)(this.shiftOp | 0xFFFFFF80);
                } else {
                    throw new UnknownInstructionException("Illegal source register id = " + this.src0[2] + " for logic unit(0)");
                }
            }
            if (this.src1[2] != 0) {
                if (this.src1[2] == 1) {
                    this.shiftOp = (byte)(this.shiftOp | 0x40);
                } else {
                    throw new UnknownInstructionException("Illegal source register id = " + this.src1[2] + " for logic unit(1)");
                }
            }
        }

        private int[] getLogicUnitID(String s) throws UnknownInstructionException {
            String[] token = this.argPattern.split(s);
            int[] id = new int[token.length];
            int i = 0;
            while (i < token.length) {
                id[i] = Integer.parseInt(token[i]);
                ++i;
            }
            return id;
        }
    }
}

