/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor;

import net.wasamon.mics.processor.Register;
import net.wasamon.mjlib.util.DataUtil;

public class IntRegister
implements Register {
    int data = 0;

    public int intValue() {
        return this.data;
    }

    public byte[] byteArray() {
        return DataUtil.toByteArray(this.data);
    }

    public byte[] byteArray(int offset, int len) {
        return DataUtil.subArray(DataUtil.toByteArray(this.data), offset, len);
    }

    public void reset() {
        this.data = 0;
    }

    public void set(Register r) {
        this.data = r.intValue();
    }

    public void set(int v) {
        this.data = v;
    }

    public void set(byte b) {
        this.data = b;
    }

    public void set(char v) {
        this.data = DataUtil.toSiginedInteger(v);
    }

    public void setL(char v) {
        this.data &= 0xFFFF0000;
        this.data += v & 0xFFFF;
    }

    public void setH(char v) {
        this.data &= 0xFFFF;
        this.data += v << 16 & 0xFFFF0000;
    }

    public void set(byte[] d) {
        this.data = DataUtil.toInteger(d);
    }

    public void set(byte[] d, int offset, int len) {
        this.data = DataUtil.toInteger(d, offset, len);
    }

    public void add(int v) {
        this.data += v;
    }

    public Register add(Register r0, Register r1) {
        this.data = r0.intValue() + r1.intValue();
        return this;
    }

    public Register mult(Register r0, Register r1) {
        this.data = r0.intValue() * r1.intValue();
        return this;
    }

    public Register div(Register r0, Register r1) {
        this.data = r0.intValue() / r1.intValue();
        return this;
    }

    public Register mod(Register r0, Register r1) {
        this.data = r0.intValue() % r1.intValue();
        return this;
    }

    public Register sub(Register r0, Register r1) {
        this.data = r0.intValue() - r1.intValue();
        return this;
    }

    public void neg(Register r0) {
        this.data = -r0.intValue();
    }

    public Register shiftL(Register r0, Register r1) {
        this.data = r0.intValue() << r1.intValue();
        return this;
    }

    public Register shiftR(Register r0, Register r1) {
        this.data = r0.intValue() >> r1.intValue();
        return this;
    }

    public Register and(Register r0, Register r1) {
        this.data = r0.intValue() & r1.intValue();
        return this;
    }

    public Register or(Register r0, Register r1) {
        this.data = r0.intValue() | r1.intValue();
        return this;
    }

    public boolean eqeq(Register r0) {
        return this.intValue() == r0.intValue();
    }

    public boolean gt(Register r0) {
        return this.intValue() > r0.intValue();
    }

    public String toString() {
        return DataUtil.toBigEndianValueString(this.byteArray()).substring(2);
    }

    public float floatValue() {
        return this.data;
    }
}

