/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor;

import net.wasamon.mics.processor.Register;
import net.wasamon.mjlib.util.DataUtil;

public class FloatRegister
implements Register {
    float data = 0.0f;

    public float floatValue() {
        return this.data;
    }

    public int intValue() {
        return (int)this.data;
    }

    public void reset() {
        this.data = 0.0f;
    }

    public void set(Register r) {
        this.data = r.floatValue();
    }

    public void set(int v) {
        this.data = v;
    }

    public void set(float v) {
        this.data = v;
    }

    public void set(byte b) {
        this.data = b;
    }

    public void set(char v) {
        this.data = DataUtil.toSiginedInteger(v);
    }

    public void set(byte[] d) {
        this.data = d.length == 2 ? (float)DataUtil.toInteger(d) : Float.intBitsToFloat(DataUtil.toInteger(d));
    }

    public void set(byte[] d, int offset, int len) {
        this.data = Float.intBitsToFloat(DataUtil.toInteger(d, offset, len));
    }

    public void add(int v) {
        this.data += (float)v;
    }

    public Register add(Register r0, Register r1) {
        this.data = r0.floatValue() + r1.floatValue();
        return this;
    }

    public Register mult(Register r0, Register r1) {
        this.data = r0.floatValue() * r1.floatValue();
        return this;
    }

    public Register div(Register r0, Register r1) {
        this.data = r0.floatValue() / r1.floatValue();
        return this;
    }

    public Register sub(Register r0, Register r1) {
        this.data = r0.floatValue() - r1.floatValue();
        return this;
    }

    public void neg(Register r0) {
        this.data = -r0.floatValue();
    }

    public Register mod(Register r0, Register r1) {
        this.data = r0.floatValue() % r1.floatValue();
        return this;
    }

    public Register shiftL(Register r0, Register r1) {
        return null;
    }

    public Register shiftR(Register r0, Register r1) {
        return null;
    }

    public Register and(Register r0, Register r1) {
        return null;
    }

    public Register or(Register r0, Register r1) {
        return null;
    }

    public boolean eqeq(Register r0) {
        return this.floatValue() == r0.floatValue();
    }

    public boolean gt(Register r0) {
        return this.floatValue() > r0.floatValue();
    }

    public byte[] byteArray() {
        return DataUtil.toByteArray(Float.floatToIntBits(this.data));
    }

    public byte[] byteArray(int offset, int len) {
        return DataUtil.subArray(this.byteArray(), offset, len);
    }

    public String toString() {
        return DataUtil.toBigEndianValueString(this.byteArray()).substring(2);
    }
}

