/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.peripheral;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.memory.InterruptDataPacket;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class SoftKeyboard
extends MicsElement
implements Channel,
MicsViewable,
KeyListener {
    private String[] dest;
    private JFrame frame = new JFrame("SoftKeyboard");
    static final int SIZE = 100;
    private SoftKeyboardCanvas keyboard;

    public SoftKeyboard() {
        this.frame.setSize(100, 100);
        this.frame.addKeyListener(this);
        this.keyboard = new SoftKeyboardCanvas();
        this.keyboard.addKeyListener(this);
        this.frame.getContentPane().add(this.keyboard);
        this.frame.setVisible(false);
    }

    public void initialize(String base, Node n) throws MicsException {
        try {
            Node init_var_node = n;
            Node[] init_var__channel_obj = XMLParser.getNamedNodeArray(init_var_node, "channel");
            this.dest = new String[init_var__channel_obj.length];
            int i = 0;
            while (i < init_var__channel_obj.length) {
                String init_var__channel_id;
                Node init_var__channel_node = init_var__channel_obj[i];
                this.dest[i] = init_var__channel_id = XMLParser.getAttribute(init_var__channel_node, "id").getNodeValue();
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.SimpleProcessor");
        }
        catch (XMLParserException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.SimpleProcessor");
        }
    }

    public void readRequest(ChannelConnectable src, MicsDataPacket data) throws MicsException {
    }

    public void writeRequest(ChannelConnectable src, MicsDataPacket data) throws MicsException {
    }

    public String[] getConnectedElements() {
        return this.dest;
    }

    public String getImagePath() {
        return "pp_keyboard1_8.gif";
    }

    public void show() {
        this.frame.setVisible(true);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        int i = 0;
        while (i < this.dest.length) {
            try {
                ChannelConnectable cc = this.composite.getChannelConnectable(this.dest[i]);
                cc.writeback(new InterruptDataPacket(0, DataUtil.toByteArray(c)));
            }
            catch (MicsException micsException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void reset() {
    }

    class SoftKeyboardCanvas
    extends JPanel {
        Image image;

        public SoftKeyboardCanvas() {
            this.setSize(100, 100);
            this.image = this.getToolkit().getImage(this.getClass().getClassLoader().getResource("pp_keyboard1_8.gif"));
        }

        public void paint(Graphics g) {
            g.drawImage(this.image, 0, 0, 100, 100, this);
        }
    }
}

