/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.peripheral;

import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class DirectMemoryAccessController
extends MicsElement
implements Channel,
ChannelConnectable,
ExecutableElement {
    private String srcChannelID;
    private String destChannelID;
    private int width = 4;
    private int srcAddr;
    private int destAddr;
    private int length;
    private int count;
    Channel srcChannel;
    Channel destChannel;
    private boolean enableFlag;
    private boolean sourceIncrement;
    private boolean destinationIncrement;
    private int transferMode;
    private static final int READ = 0;
    private static final int WRITE = 1;

    public String getImagePath() {
        return "combo_bus3.png";
    }

    private void initialize(String src, String dest, int width) {
        this.srcChannelID = src;
        this.destChannelID = dest;
        this.width = width;
    }

    public void initialize(String base, Node n) throws MicsException {
        try {
            Node init_var_node = n;
            int init_var_width = DataUtil.parseInt(XMLParser.getAttribute(init_var_node, "width").getNodeValue());
            String init_var_src = XMLParser.getAttribute(init_var_node, "src").getNodeValue();
            String init_var_dest = XMLParser.getAttribute(init_var_node, "dest").getNodeValue();
            this.initialize(init_var_src, init_var_dest, init_var_width);
        }
        catch (NumberFormatException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.peripheral.DirectMemoryAccessController");
        }
        catch (XMLParserException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.peripheral.DirectMemoryAccessController");
        }
    }

    private Channel getSrcChannel() throws MicsException {
        if (this.srcChannel == null) {
            this.srcChannel = this.composite.getChannel(this.srcChannelID);
        }
        return this.srcChannel;
    }

    private Channel getDestChannel() throws MicsException {
        if (this.destChannel == null) {
            this.destChannel = this.composite.getChannel(this.destChannelID);
        }
        return this.destChannel;
    }

    private Channel getReadChannel() throws MicsException {
        if (this.transferMode == 0) {
            return this.getDestChannel();
        }
        if (this.transferMode == 1) {
            return this.getSrcChannel();
        }
        return null;
    }

    private Channel getWriteChannel() throws MicsException {
        if (this.transferMode == 0) {
            return this.getSrcChannel();
        }
        if (this.transferMode == 1) {
            return this.getDestChannel();
        }
        return null;
    }

    public ExecInfo exec_first() throws MicsException {
        ExecInfo info = new ExecInfo();
        if (this.enableFlag) {
            MicsDataPacket req = RandomAccessMemoryDataPacket.readPacket(this.srcAddr, this.width, 8);
            this.getReadChannel().readRequest(this, req);
            this.count += this.width;
            if (this.sourceIncrement) {
                this.srcAddr += this.width;
            }
            this.enableFlag = this.count < this.length;
        }
        info.setTerminatableFlag(!this.enableFlag);
        return info;
    }

    public ExecInfo exec_second() {
        return null;
    }

    public void reset() {
        this.enableFlag = false;
        this.transferMode = 1;
        this.count = 0;
    }

    public void writeRequest(ChannelConnectable dest, MicsDataPacket data) throws MicsException {
        this.write(data);
    }

    public void readRequest(ChannelConnectable dest, MicsDataPacket data) throws MicsException {
    }

    public void write(MicsDataPacket data) {
        RandomAccessMemoryDataPacket rd = (RandomAccessMemoryDataPacket)data;
        switch (rd.addr / 4) {
            case 0: {
                this.srcAddr = DataUtil.toInteger(rd.data, 0, rd.data.length);
                break;
            }
            case 1: {
                this.destAddr = DataUtil.toInteger(rd.data, 0, rd.data.length);
                break;
            }
            case 2: {
                this.length = DataUtil.toInteger(rd.data, 0, rd.data.length);
                break;
            }
            case 3: {
                if ((DataUtil.toInteger(rd.data, 0, rd.data.length) & 1) == 1) {
                    this.enableFlag = true;
                    this.count = 0;
                } else {
                    this.enableFlag = false;
                    this.count = 0;
                }
                this.transferMode = (DataUtil.toInteger(rd.data, 0, rd.data.length) & 2) == 2 ? 0 : 1;
                this.destinationIncrement = (DataUtil.toInteger(rd.data, 0, rd.data.length) & 4) != 4;
                this.sourceIncrement = (DataUtil.toInteger(rd.data, 0, rd.data.length) & 8) != 8;
            }
        }
    }

    public int size() {
        return 0;
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + this.id() + ":" + this.getClass().getName() + "\n";
        s = String.valueOf(s) + "srcAddr : " + this.srcAddr + "\n";
        s = String.valueOf(s) + "destAddr: " + this.destAddr + "\n";
        s = String.valueOf(s) + "length  : " + this.length + "\n";
        s = String.valueOf(s) + "enable  : " + this.enableFlag + "\n";
        s = String.valueOf(s) + "transfer: \n";
        s = this.transferMode == 0 ? String.valueOf(s) + "READ\n" : (this.transferMode == 1 ? String.valueOf(s) + "WRITE\n" : String.valueOf(s) + "UNKNOWN\n");
        return s;
    }

    public void writeback(MicsDataPacket p) throws MicsException {
        RandomAccessMemoryDataPacket rp = (RandomAccessMemoryDataPacket)p;
        MicsDataPacket req = RandomAccessMemoryDataPacket.writePacket(this.destAddr, this.width, 8, rp.data);
        this.getWriteChannel().writeRequest(this, req);
        if (this.destinationIncrement) {
            this.destAddr += this.width;
        }
    }

    public int getChannelOffset(Channel c) {
        return 0;
    }

    public String[] getConnectedElements() {
        return new String[]{this.srcChannelID, this.destChannelID};
    }
}

