/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.memory;

import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mjlib.util.DataUtil;

public class RandomAccessMemoryDataPacket
implements MicsDataPacket {
    public int addr;
    public byte[] data;
    public int width;
    public int length;

    public RandomAccessMemoryDataPacket(int addr, int length, int width, byte[] data) {
        this.addr = addr;
        this.length = length;
        this.width = width;
        this.data = data;
    }

    public static MicsDataPacket readPacket(int addr, int length, int width) {
        return new RandomAccessMemoryDataPacket(addr, length, width, null);
    }

    public static MicsDataPacket writePacket(int addr, int length, int width, byte[] data) {
        return new RandomAccessMemoryDataPacket(addr, length, width, data);
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + this.getClass().getName() + ":";
        s = String.valueOf(s) + " addr = " + DataUtil.toBigEndianValueString(DataUtil.toByteArray(this.addr)) + ",";
        s = String.valueOf(s) + " width = " + this.width + ",";
        s = String.valueOf(s) + " length = " + this.length + ",";
        s = String.valueOf(s) + "data = [";
        if (this.data != null) {
            String tmp = "";
            int i = 0;
            while (i < this.data.length) {
                tmp = String.valueOf(tmp) + "," + this.data[i];
                ++i;
            }
            if (tmp.length() > 1) {
                s = String.valueOf(s) + tmp.substring(1);
            }
        }
        s = String.valueOf(s) + "]";
        return s;
    }
}

