/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.memory;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mjlib.print.FormatException;
import net.wasamon.mjlib.print.PrintFormat;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class RandomAccessMemory
extends MicsElement
implements DataBuffer {
    private byte[] data;

    public RandomAccessMemory() {
    }

    public RandomAccessMemory(int size) {
        this.data = new byte[size];
    }

    public String getImagePath() {
        return "pp_memorynote1_1.gif";
    }

    public void initialize(String base, Node n) throws MicsException {
        try {
            Node init_var_node = n;
            int init_var_size = DataUtil.parseInt(XMLParser.getAttribute(init_var_node, "size").getNodeValue());
            this.data = new byte[init_var_size];
            Node[] init_var__init_obj = XMLParser.getNamedNodeArray(n, "init");
            int i = 0;
            while (i < init_var__init_obj.length) {
                Node init_var__init_node = init_var__init_obj[i];
                String init_var__init_file = XMLParser.getAttribute(init_var__init_node, "file").getNodeValue();
                if (init_var__init_file.charAt(0) != '/') {
                    init_var__init_file = String.valueOf(base) + "/" + init_var__init_file;
                }
                int init_var__init_offset = DataUtil.parseInt(XMLParser.getAttribute(init_var__init_node, "offset").getNodeValue());
                try {
                    this.write(init_var__init_offset, new BufferedInputStream(new FileInputStream(init_var__init_file)));
                }
                catch (FileNotFoundException e) {
                    System.out.println("no such file: " + init_var__init_file);
                    System.out.println("[W] no data is written as initialize.");
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.memory.RandomAccessMemory16");
        }
        catch (XMLParserException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.memory.RandomAccessMemory16");
        }
    }

    public int size() {
        return this.data.length;
    }

    public byte read(int addr) {
        return this.data[addr];
    }

    public byte[] read(int addr, int length) {
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            d[i] = this.data[i + addr];
            ++i;
        }
        return d;
    }

    public void write(MicsDataPacket data) {
        RandomAccessMemoryDataPacket rd = (RandomAccessMemoryDataPacket)data;
        int i = 0;
        while (i < rd.length * (rd.width / 8)) {
            this.data[rd.addr + i] = rd.data[i];
            ++i;
        }
    }

    public MicsDataPacket read(MicsDataPacket data) {
        RandomAccessMemoryDataPacket rd = (RandomAccessMemoryDataPacket)data;
        RandomAccessMemoryDataPacket d = new RandomAccessMemoryDataPacket(rd.addr, rd.length, rd.width, new byte[rd.length * (rd.width / 8)]);
        int i = 0;
        while (i < d.data.length) {
            d.data[i] = this.data[i + rd.addr];
            ++i;
        }
        return d;
    }

    public void write(int addr, int length, byte[] d) {
        int i = 0;
        while (i < length) {
            this.data[i + addr] = d[i];
            ++i;
        }
    }

    public void write(int addr, byte d) {
        this.data[addr] = d;
    }

    public String toString(int addr, int len) {
        String str = "";
        try {
            int i = 0;
            while (i < len && addr + i * 16 < this.data.length) {
                str = String.valueOf(str) + PrintFormat.print("%04x: ", addr + i * 16);
                int j = 0;
                while (j < 16) {
                    if (addr + i * 16 + j >= this.data.length) {
                        str = String.valueOf(str) + "\n";
                        return str;
                    }
                    str = String.valueOf(str) + PrintFormat.print("%02x", this.data[addr + i * 16 + j]);
                    str = j == 15 ? String.valueOf(str) + "\n" : String.valueOf(str) + " ";
                    ++j;
                }
                ++i;
            }
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return str;
    }

    public void write(int offset, InputStream reader) throws DataBufferException {
        byte[] buf = new byte[1024];
        int addr = offset;
        int len = 0;
        try {
            while ((len = reader.read(buf, 0, 1024)) != -1) {
                this.write(addr, len, buf);
                addr += len;
            }
        }
        catch (IOException e) {
            throw new DataBufferException("file read error.");
        }
    }

    public void dump(int offset, int len, OutputStream writer) throws DataBufferException {
        try {
            writer.write(this.data, offset, len);
        }
        catch (IOException e) {
            throw new DataBufferException("file read error.");
        }
    }

    public String getInfo() {
        String str = "";
        str = String.valueOf(str) + "RandomAccessMemory16\n";
        str = String.valueOf(str) + "  CLASS: " + this.getClass().getName() + "\n";
        str = String.valueOf(str) + "  address length: " + this.data.length + "\n";
        str = String.valueOf(str) + "  data width: 16 bit";
        return str;
    }

    public String[] getConnectedElements() {
        return null;
    }

    public void reset() {
    }
}

