/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.gui.awt;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.MicsElement;

public class MemoryLoader
implements ActionListener {
    private Frame frame = new Frame();
    private TextField offsetField;
    private TextField fileField;
    private Button btnOK;
    private Button btnCancel;
    private Button btnFile;
    private DataBuffer memory;
    private static MemoryLoader instance = new MemoryLoader();

    public static MemoryLoader getInstance() {
        return instance;
    }

    private MemoryLoader() {
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MemoryLoader.this.frame.setVisible(false);
            }
        });
        Panel p = new Panel(new BorderLayout());
        TextField t = new TextField("offset");
        this.offsetField = new TextField("0", 10);
        t.setEditable(false);
        p.add((Component)t, "West");
        p.add((Component)this.offsetField, "Center");
        this.frame.add((Component)p, "North");
        p = new Panel(new BorderLayout());
        this.fileField = new TextField(30);
        this.fileField.setEditable(false);
        this.btnFile = new Button("File");
        this.btnFile.addActionListener(this);
        p.add((Component)this.fileField, "Center");
        p.add((Component)this.btnFile, "East");
        this.frame.add((Component)p, "Center");
        p = new Panel();
        this.btnOK = new Button("OK");
        this.btnOK.addActionListener(this);
        p.add((Component)this.btnOK, "West");
        this.btnCancel = new Button("Cancel");
        this.btnCancel.addActionListener(this);
        p.add((Component)this.btnCancel, "West");
        this.frame.add((Component)p, "South");
        this.frame.pack();
        this.frame.setVisible(false);
    }

    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src != null) {
            if (src == this.btnFile) {
                FileDialog fd = new FileDialog(this.frame, "Open", 0);
                fd.setVisible(true);
                if (fd.getFile() != null) {
                    File f = new File(fd.getDirectory(), fd.getFile());
                    this.fileField.setText(f.getAbsolutePath());
                }
            } else if (src == this.btnOK) {
                if (this.fileField.getText().equals("")) {
                    System.out.println("File is not selected.");
                    return;
                }
                int offset = 0;
                try {
                    offset = Integer.parseInt(this.offsetField.getText());
                }
                catch (NumberFormatException e) {
                    System.out.println("Illegal offset.");
                    return;
                }
                try {
                    if (this.memory != null) {
                        BufferedInputStream reader = new BufferedInputStream(new FileInputStream(new File(this.fileField.getText())));
                        this.memory.write(offset, reader);
                    }
                }
                catch (DataBufferException e) {
                    System.out.println(e.getMessage());
                }
                catch (FileNotFoundException e) {
                    System.out.println(e.getMessage());
                }
                this.discard();
                System.out.println("write succeeded. src=" + this.fileField.getText() + "," + " offset=" + offset);
            } else if (src == this.btnCancel) {
                this.discard();
            }
        }
    }

    public void discard() {
        this.memory = null;
        this.frame.setVisible(false);
    }

    public void show(DataBuffer memory) {
        this.memory = memory;
        this.frame.setTitle("RandomAccessMemory (ID=" + ((MicsElement)((Object)memory)).id() + ")");
        this.frame.setVisible(true);
    }
}

