/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.gui.awt;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.gui.MicsArchitectureViewer;
import net.wasamon.mics.gui.awt.MemoryLoader;
import net.wasamon.mjlib.util.DataUtil;

public class AWTArchitectureViewer
extends MicsArchitectureViewer
implements ActionListener {
    private Frame frame;
    private ArchitectureCanvas canvas;
    private ScrollPane pane;
    private MicsElement selectedElement;
    private Button btnLoad;
    private Button btnView;
    private TextField fieldAddr;
    private Button btnPrint;

    public AWTArchitectureViewer(MicsCompositeElement composite) {
        super(composite);
        this.frame = composite.id() != null && !composite.id().equals("") ? new Frame("Architecture Viewer: " + composite.id()) : new Frame("Architecture Viewer");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AWTArchitectureViewer.this.frame.setVisible(false);
            }
        });
        this.frame.setBounds(10, 10, 600, 400);
        this.frame.add((Component)this.getToolBar(), "North");
        this.canvas = new ArchitectureCanvas();
        this.pane = new ScrollPane(1);
        this.pane.add(this.canvas);
        this.frame.add((Component)this.pane, "Center");
        this.selectedElement = null;
        this.btnView.setEnabled(false);
        this.btnLoad.setEnabled(false);
        this.btnPrint.setEnabled(false);
        this.fieldAddr.setEnabled(false);
        this.canvas.imageTable.clear();
    }

    public MicsElement getSelectedElement() {
        return this.selectedElement;
    }

    public void setSelectedElement(MicsElement element) {
        if (element != null && this.selectedElement != element) {
            System.out.println(element.getInfo());
            if (element instanceof DataBuffer) {
                this.btnLoad.setEnabled(true);
                this.btnPrint.setEnabled(true);
                this.fieldAddr.setEnabled(true);
            } else {
                this.btnLoad.setEnabled(false);
            }
            if (element instanceof MicsViewable) {
                this.btnView.setEnabled(true);
            } else {
                this.btnView.setEnabled(false);
            }
            this.selectedElement = element;
        }
    }

    private Panel getToolBar() {
        Panel bar = new Panel();
        bar.setLayout(new FlowLayout());
        this.btnLoad = new Button("Load");
        this.btnLoad.addActionListener(this);
        bar.add(this.btnLoad);
        this.btnView = new Button("View");
        this.btnView.addActionListener(this);
        bar.add(this.btnView);
        Panel p = new Panel();
        this.fieldAddr = new TextField("0", 5);
        this.fieldAddr.addActionListener(this);
        this.btnPrint = new Button("Print");
        this.btnPrint.addActionListener(this);
        p.add(this.fieldAddr);
        p.add(this.btnPrint);
        bar.add(p);
        return bar;
    }

    public void show() {
        this.selectedElement = null;
        this.btnView.setEnabled(false);
        this.btnLoad.setEnabled(false);
        this.btnPrint.setEnabled(false);
        this.fieldAddr.setEnabled(false);
        this.frame.setVisible(true);
        this.canvas.repaint();
    }

    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src != null) {
            if (src == this.btnView) {
                MicsElement element = this.getSelectedElement();
                if (element != null && element instanceof MicsViewable) {
                    ((MicsViewable)((Object)element)).show();
                }
            } else if (src == this.btnLoad) {
                MicsElement element = this.getSelectedElement();
                if (element != null && element instanceof DataBuffer) {
                    MemoryLoader.getInstance().show((DataBuffer)((Object)element));
                }
            } else if (src == this.btnPrint) {
                int offset = 0;
                try {
                    offset = DataUtil.parseInt(this.fieldAddr.getText());
                }
                catch (NumberFormatException e) {
                    System.out.println("Illegal address format.");
                }
                System.out.println("Read Memory: " + this.getSelectedElement().id());
                System.out.println("From = " + offset);
                System.out.println(((DataBuffer)((Object)this.getSelectedElement())).toString(offset, 4));
            }
        }
    }

    public MicsArchitectureViewer.ViwerCanvas canvas() {
        return this.canvas;
    }

    class ArchitectureCanvas
    extends Canvas
    implements MouseListener,
    MouseMotionListener,
    MicsArchitectureViewer.ViwerCanvas {
        private Hashtable imageTable = new Hashtable();
        private Image buf = null;
        private int bufWidth;
        private int bufHeight;
        private Graphics g;
        private int selectedOffsetY;
        private int selectedOffsetX;

        public ArchitectureCanvas() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            if (this.buf == null) {
                this.buf = this.createImage(this.getWidth(), this.getHeight());
                this.bufWidth = this.getWidth();
                this.bufHeight = this.getHeight();
            } else if (this.bufWidth != this.getWidth() || this.bufHeight != this.getHeight()) {
                this.buf = null;
                this.buf = this.createImage(this.getWidth(), this.getHeight());
            }
            Graphics g2 = this.buf.getGraphics();
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.g = g2;
            AWTArchitectureViewer.this.paint();
            g.drawImage(this.buf, 0, 0, this);
            AWTArchitectureViewer.this.pane.doLayout();
        }

        public void mouseClicked(MouseEvent arg0) {
        }

        public void mouseEntered(MouseEvent arg0) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            AWTArchitectureViewer.this.setSelectedNode(e.getX(), e.getY());
            this.repaint();
            if (AWTArchitectureViewer.this.selectedNode != null) {
                this.selectedOffsetX = ((AWTArchitectureViewer)AWTArchitectureViewer.this).selectedNode.X - e.getX();
                this.selectedOffsetY = ((AWTArchitectureViewer)AWTArchitectureViewer.this).selectedNode.Y - e.getY();
                AWTArchitectureViewer.this.setSelectedElement(((AWTArchitectureViewer)AWTArchitectureViewer.this).selectedNode.element);
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent arg0) {
            if (AWTArchitectureViewer.this.selectedNode != null) {
                AWTArchitectureViewer.this.selectedNode.setPosition(arg0.getX() + this.selectedOffsetX, arg0.getY() + this.selectedOffsetY);
                this.repaint();
            }
        }

        public void mouseMoved(MouseEvent arg0) {
        }

        public void drawImage(String name, int x, int y, int w, int h) {
            if (!this.imageTable.containsKey(name)) {
                Image image;
                File f = new File(name);
                if (f.exists()) {
                    image = this.getToolkit().getImage(f.getAbsolutePath());
                    System.out.println(f.getAbsolutePath());
                } else {
                    image = this.getToolkit().getImage(this.getClass().getClassLoader().getResource(name));
                }
                this.imageTable.put(name, image);
            }
            this.g.drawImage((Image)this.imageTable.get(name), x, y, w, h, this);
        }

        public void drawLine(int x0, int y0, int x1, int y1) {
            this.g.drawLine(x0, y0, x1, y1);
        }

        public void drawRect(int x, int y, int w, int h) {
            this.g.drawRect(x, y, w, h);
        }

        public void drawString(String str, int x, int y) {
            this.g.drawString(str, x, y);
        }

        public void fillRect(int x, int y, int w, int h) {
            this.g.fillRect(x, y, w, h);
        }

        public int height() {
            return this.getBounds().height;
        }

        public void setBGColor() {
            this.g.setColor(Color.gray);
        }

        public void setColorBlack() {
            this.g.setColor(Color.black);
        }

        public void setColorRed() {
            this.g.setColor(Color.red);
        }

        public void setFGColor() {
            this.g.setColor(Color.black);
        }

        public int width() {
            return this.getBounds().width;
        }
    }
}

