/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.gui;

import java.util.Hashtable;
import java.util.Iterator;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsElement;

public abstract class MicsArchitectureViewer {
    private Hashtable data = new Hashtable();
    protected Node selectedNode;

    protected MicsArchitectureViewer(MicsCompositeElement composite) {
        this.data.clear();
        MicsElement[] elements = composite.getMicsElementArray();
        int count = 0;
        int i = 0;
        while (i < elements.length) {
            MicsElement e = elements[i];
            this.data.put(e.id(), new Node(e, count * 30));
            ++count;
            ++i;
        }
    }

    public void paint() {
        if (this.data == null) {
            return;
        }
        Iterator it = this.data.values().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).paintEdge();
        }
        it = this.data.values().iterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.isSelected()) {
                n.paintNode(true);
                continue;
            }
            n.paintNode(false);
        }
    }

    public void setSelectedNode(int x, int y) {
        Iterator it = this.data.values().iterator();
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(false);
        }
        this.selectedNode = null;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (!n.isContain(x, y)) continue;
            n.setSelected(true);
            this.selectedNode = n;
            break;
        }
    }

    public abstract ViwerCanvas canvas();

    public abstract void show();

    public class Node {
        public MicsElement element;
        String name;
        String image = null;
        boolean fSelected = false;
        public int X;
        public int Y;
        public int SIZE = 30;
        private int marginY = 15;
        private int ascent;

        public Node(MicsElement element, int offset) {
            this.element = element;
            MicsElement.Appearance appearance = element.getAppearance();
            this.X = appearance.x == null ? 20 + offset : appearance.x;
            this.Y = appearance.y == null ? 20 + offset : appearance.y;
            this.name = String.valueOf(element.id()) + ":" + this.getShortName(element.getClass().getName());
            this.image = appearance.image;
        }

        private String getShortName(String s) {
            int ch = s.lastIndexOf(46);
            if (ch < 0) {
                return s;
            }
            return s.substring(ch);
        }

        public int getCenterX() {
            return this.X + this.SIZE / 2;
        }

        public int getCenterY() {
            return this.Y + this.SIZE / 2;
        }

        public void paintEdge() {
            MicsArchitectureViewer.this.canvas().setColorBlack();
            String[] connecteds = this.element.getConnectedElements();
            if (connecteds != null) {
                int i = 0;
                while (i < connecteds.length) {
                    Node dest = (Node)MicsArchitectureViewer.this.data.get(connecteds[i]);
                    if (dest != null) {
                        MicsArchitectureViewer.this.canvas().drawLine(this.getCenterX(), this.getCenterY(), dest.getCenterX(), dest.getCenterY());
                    }
                    ++i;
                }
            }
        }

        public void paintNode(boolean flag) {
            if (flag) {
                MicsArchitectureViewer.this.canvas().setFGColor();
            } else {
                MicsArchitectureViewer.this.canvas().setBGColor();
            }
            if (this.image != null) {
                MicsArchitectureViewer.this.canvas().drawImage(this.image, this.X, this.Y, this.SIZE, this.SIZE);
            } else {
                MicsArchitectureViewer.this.canvas().fillRect(this.X, this.Y, this.SIZE, this.SIZE);
            }
            MicsArchitectureViewer.this.canvas().setFGColor();
            MicsArchitectureViewer.this.canvas().drawString(this.name, this.X, this.Y + this.ascent + this.marginY + this.SIZE);
            if (flag) {
                MicsArchitectureViewer.this.canvas().setColorRed();
            }
            MicsArchitectureViewer.this.canvas().drawRect(this.X, this.Y, this.SIZE, this.SIZE);
            MicsArchitectureViewer.this.canvas().drawRect(this.X - 1, this.Y - 1, this.SIZE + 2, this.SIZE + 2);
            int w = MicsArchitectureViewer.this.canvas().width();
            int h = MicsArchitectureViewer.this.canvas().height();
            if (this.X + this.SIZE + 1 > w || this.Y + this.SIZE + 1 > h) {
                int x = this.X + this.SIZE + 1 > w ? this.X + this.SIZE + 100 : w;
                int y = this.Y + this.SIZE + 1 > h ? this.Y + this.SIZE + 100 : h;
                MicsArchitectureViewer.this.canvas().setSize(x, y);
            }
        }

        public boolean isContain(int x, int y) {
            return x > this.X && x < this.X + this.SIZE && y > this.Y && y < this.Y + this.SIZE;
        }

        public void setPosition(int x, int y) {
            this.X = x;
            this.Y = y;
        }

        public boolean isSelected() {
            return this.fSelected;
        }

        public void setSelected(boolean flag) {
            this.fSelected = flag;
        }
    }

    public static interface ViwerCanvas {
        public void setColorBlack();

        public void setColorRed();

        public void setFGColor();

        public void setBGColor();

        public void drawLine(int var1, int var2, int var3, int var4);

        public void drawImage(String var1, int var2, int var3, int var4, int var5);

        public void drawRect(int var1, int var2, int var3, int var4);

        public void fillRect(int var1, int var2, int var3, int var4);

        public void drawString(String var1, int var2, int var3);

        public int width();

        public int height();

        public void setSize(int var1, int var2);
    }
}

