/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.ConfigErrorException;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.ExecutableElementException;
import net.wasamon.mics.IMicsElement;
import net.wasamon.mics.Mics;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.gui.MicsArchitectureViewer;
import org.w3c.dom.Node;

public class MicsCompositeElement
extends MicsElement
implements Runnable,
ExecutableElement,
DataBuffer,
MicsViewable {
    private ArrayList element = new ArrayList();
    private ArrayList ram = new ArrayList();
    private ArrayList channel = new ArrayList();
    private ArrayList channelConnectable = new ArrayList();
    private ArrayList dataBufferElements = new ArrayList();
    private MicsArchitectureViewer viewer;
    private ArrayList executableElements = new ArrayList();
    private boolean activeFlag;
    private boolean executableFlag;
    private int cycle = 0;

    private void init() {
        this.activeFlag = false;
        this.executableFlag = false;
        this.cycle = 0;
    }

    public MicsCompositeElement() {
        this.init();
    }

    public void clear() {
        this.element.clear();
        this.ram.clear();
        this.channel.clear();
        this.executableElements.clear();
        this.init();
    }

    public void reset() {
        if (!this.activeFlag) {
            Iterator i = this.executableElements.iterator();
            while (i.hasNext()) {
                ((MicsEngineElement)i.next()).proc.reset();
            }
            this.init();
        } else {
            System.out.println("cannot reset processors while engin is active.");
        }
    }

    public void stop() {
        this.executableFlag = false;
        System.out.println("engine is stopped at " + this.cycle);
        this.activeFlag = false;
    }

    public String getProcStatusString() throws MicsException {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.executableElements.iterator();
        while (i.hasNext()) {
            sb.append(String.valueOf(((MicsEngineElement)i.next()).proc.toString()) + "\n");
        }
        return sb.toString();
    }

    private void stepCycle() {
        ++this.cycle;
        Iterator i = this.executableElements.iterator();
        while (i.hasNext()) {
            ((MicsEngineElement)i.next()).decrement();
        }
    }

    private void updateCycle() {
        Iterator i = this.executableElements.iterator();
        while (i.hasNext()) {
            ((MicsEngineElement)i.next()).updateCycle();
        }
    }

    public boolean step() throws MicsException, ExecutableElementException, ConfigErrorException, MicsException, DataBufferException {
        this.stepCycle();
        ExecInfo info1 = this.exec_first();
        ExecInfo info2 = this.exec_second();
        this.updateCycle();
        return !info1.isTerminatable() || !info2.isTerminatable();
    }

    public void run() {
        if (this.activeFlag) {
            System.out.println("cannot start while engin is active.");
            return;
        }
        this.activeFlag = true;
        Calendar cal = Calendar.getInstance();
        System.out.println("Starting of Execution All at " + cal.getTime());
        long start_time = cal.getTimeInMillis();
        this.executableFlag = true;
        try {
            while (this.step() && this.executableFlag) {
            }
            this.activeFlag = false;
        }
        catch (MicsException e) {
            System.out.println("Program Terminated at " + cal.getTime() + " abnormally.");
            System.out.println(String.valueOf(e.getMessage()) + " at " + this.cycle);
            return;
        }
        cal = Calendar.getInstance();
        if (this.executableFlag) {
            Mics.getInstance().shell().setMicsEngineEnableState(true);
            System.out.println("Program Terminated at " + cal.getTime());
            long timespan = cal.getTimeInMillis() - start_time;
            System.out.print("Execution Cycle: " + this.cycle + " Time: " + timespan + "ms");
            if (timespan > 0L) {
                System.out.println(" C/S: " + (double)this.cycle / (double)timespan + "kHz");
            } else {
                System.out.println("");
            }
        }
    }

    public ExecInfo exec_first() throws MicsException {
        Iterator i = this.executableElements.iterator();
        boolean flag = false;
        while (i.hasNext()) {
            MicsEngineElement element = (MicsEngineElement)i.next();
            if (element.isExecutable()) {
                ExecInfo info = element.proc.exec_first();
                if (info == null) continue;
                element.addCycle(info.getCycle());
                if (info.isTerminatable()) continue;
                flag = true;
                continue;
            }
            flag = true;
        }
        return new ExecInfo(!flag, 0);
    }

    public ExecInfo exec_second() throws MicsException {
        Iterator i = this.executableElements.iterator();
        boolean flag = false;
        while (i.hasNext()) {
            MicsEngineElement element = (MicsEngineElement)i.next();
            if (element.isExecutable()) {
                ExecInfo info = element.proc.exec_second();
                if (info == null) continue;
                element.addCycle(info.getCycle());
                if (info.isTerminatable()) continue;
                flag = true;
                continue;
            }
            flag = true;
        }
        return new ExecInfo(!flag, 0);
    }

    public String[] getConnectedElements() {
        return null;
    }

    private boolean hasMicsElement(String name) {
        boolean flag = false;
        Iterator i = this.element.iterator();
        while (i.hasNext()) {
            if (!((MicsElement)i.next()).id().equals(name)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public String getImagePath() {
        return null;
    }

    private void initializeElement(String base, Node[] nodes) throws MicsException {
        int i = 0;
        while (i < nodes.length) {
            Node n = nodes[i];
            String classtype = "";
            try {
                classtype = this.getAttributeAsString(n, "class");
                String id = this.getAttributeAsString(n, "id");
                Class<?> c = ClassLoader.getSystemClassLoader().loadClass(classtype);
                MicsElement r = (MicsElement)c.newInstance();
                r.initialize_base(this, base, id, n);
                this.element.add(r);
                if (r instanceof ExecutableElement) {
                    this.executableElements.add(new MicsEngineElement((ExecutableElement)((Object)r)));
                }
                if (r instanceof Channel) {
                    this.channel.add((Channel)((Object)r));
                }
                if (r instanceof ChannelConnectable) {
                    this.channelConnectable.add((ChannelConnectable)((Object)r));
                }
                if (r instanceof DataBuffer) {
                    this.ram.add((DataBuffer)((Object)r));
                    int offset = 0;
                    if (this.dataBufferElements.size() > 0) {
                        DataBufferElement element = (DataBufferElement)this.dataBufferElements.get(this.dataBufferElements.size() - 1);
                        offset = element.offset + element.data.size();
                    }
                    this.dataBufferElements.add(new DataBufferElement((DataBuffer)((Object)r), offset));
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new MicsException("no such class: " + classtype);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new MicsException("cannot instantiation: " + classtype);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new MicsException("illegal access: " + classtype);
            }
            ++i;
        }
    }

    public void initialize(String base, Node node) throws MicsException {
        this.initializeElement(base, this.getNamedNodeArray(node, "element"));
        this.viewer = Mics.getInstance().shell().getMicsArchitectureViewerData(this);
    }

    public MicsElement[] getMicsElementArray() {
        return this.element.toArray(new MicsElement[this.element.size()]);
    }

    public DataBuffer[] getDataBufferArray() {
        return this.ram.toArray(new DataBuffer[this.ram.size()]);
    }

    public Channel[] getChannelArray() {
        return this.channel.toArray(new Channel[this.channel.size()]);
    }

    public ChannelConnectable[] getChannelConnectableArray() {
        return this.channelConnectable.toArray(new ChannelConnectable[this.channelConnectable.size()]);
    }

    public IMicsElement getMicsElement(String id, IMicsElement[] array) throws MicsException {
        IMicsElement val = null;
        try {
            int i = 0;
            while (i < array.length) {
                val = array[i];
                if (!val.id().equals(id)) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MicsException("no such element: " + id);
        }
        return val;
    }

    public MicsElement getMicsElement(String id) throws MicsException {
        return (MicsElement)this.getMicsElement(id, this.getMicsElementArray());
    }

    public DataBuffer getDataBuffer(String id) throws MicsException {
        DataBuffer d = (DataBuffer)this.getMicsElement(id, this.getDataBufferArray());
        if (!(d != null && id.equals(d.id()) || this.composite == null)) {
            d = this.composite.getDataBuffer(id);
        }
        return d;
    }

    public Channel getChannel(String id) throws MicsException {
        Channel c = (Channel)this.getMicsElement(id, this.getChannelArray());
        if (!(c != null && id.equals(c.id()) || this.composite == null)) {
            c = this.composite.getChannel(id);
        }
        return c;
    }

    public ChannelConnectable getChannelConnectable(String id) throws MicsException {
        ChannelConnectable cc = (ChannelConnectable)this.getMicsElement(id, this.getChannelConnectableArray());
        if (!(cc != null && id.equals(cc.id()) || this.composite == null)) {
            cc = this.composite.getChannelConnectable(id);
        }
        return cc;
    }

    public void shutdown() {
        if (this.element != null) {
            Iterator it = this.element.iterator();
            while (it.hasNext()) {
                ((MicsElement)it.next()).shutdown();
            }
        }
    }

    public void dump(int offset, int len, OutputStream writer) throws DataBufferException {
        DataBufferElement d = this.searchDataBuffer(offset);
        if (d != null) {
            d.data.dump(offset - d.offset, len, writer);
        }
    }

    public MicsDataPacket read(MicsDataPacket data) {
        return null;
    }

    public int size() {
        if (this.dataBufferElements.size() == 0) {
            return 0;
        }
        DataBufferElement d = (DataBufferElement)this.dataBufferElements.get(this.dataBufferElements.size() - 1);
        return d.offset + d.data.size();
    }

    public String toString(int addr, int length) {
        DataBufferElement d = this.searchDataBuffer(addr);
        if (d != null) {
            return d.data.toString(addr - d.offset, length);
        }
        return null;
    }

    public void write(MicsDataPacket data) {
    }

    public void write(int offset, InputStream reader) throws DataBufferException {
        DataBufferElement d = this.searchDataBuffer(offset);
        if (d != null) {
            d.data.write(offset - d.offset, reader);
        }
    }

    private DataBufferElement searchDataBuffer(int offset) {
        int i = 0;
        while (i < this.dataBufferElements.size() - 1) {
            DataBufferElement d0 = (DataBufferElement)this.dataBufferElements.get(i);
            DataBufferElement d1 = (DataBufferElement)this.dataBufferElements.get(i + 1);
            if (d0.offset <= offset && offset < d1.offset) {
                return d0;
            }
            ++i;
        }
        if (this.dataBufferElements.size() > 0) {
            return (DataBufferElement)this.dataBufferElements.get(this.dataBufferElements.size() - 1);
        }
        return null;
    }

    public void show() {
        if (this.viewer != null) {
            this.viewer.show();
        }
    }

    private class DataBufferElement {
        DataBuffer data;
        int offset;

        public DataBufferElement(DataBuffer d, int o) {
            this.data = d;
            this.offset = o;
        }
    }

    private class MicsEngineElement {
        ExecutableElement proc;
        int step;
        int tmpCycle;

        public MicsEngineElement(ExecutableElement _proc) {
            this.proc = _proc;
        }

        public void decrement() {
            if (this.step > 0) {
                --this.step;
            }
        }

        public void addCycle(int v) {
            this.tmpCycle += v;
        }

        public void updateCycle() {
            if (this.isExecutable()) {
                this.step = this.tmpCycle;
                this.tmpCycle = 0;
            }
        }

        public boolean isExecutable() {
            return this.step == 0;
        }
    }
}

