/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecutableElementException;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsPrompt;
import net.wasamon.mics.MicsShell;
import net.wasamon.mics.gui.awt.MicsAWTWindow;
import net.wasamon.mjlib.util.GetOpt;
import net.wasamon.mjlib.util.GetOptException;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class Mics {
    public static final int majorVersion = 0;
    public static final int minorVersion = 5;
    public static final int revision = 2;
    private static Mics instance = new Mics();
    private MicsShell shell;
    private MicsCompositeElement engine = new MicsCompositeElement();
    private final String defaultDir = ".";

    public static Mics getInstance() {
        return instance;
    }

    private Mics() {
    }

    private void setMicsShell(MicsShell shell) {
        this.shell = shell;
    }

    public MicsShell shell() {
        return this.shell;
    }

    public MicsCompositeElement engine() {
        return this.engine;
    }

    private void init() {
        this.engine.clear();
    }

    public MicsElement[] getMicsElementArray() {
        return this.engine.getMicsElementArray();
    }

    public void setMemoryData(String id, int offset, BufferedInputStream reader) throws MicsException {
        DataBuffer r = this.engine.getDataBuffer(id);
        r.write(offset, reader);
    }

    public void reset() throws MicsException {
        this.engine.reset();
    }

    public void execEngine() {
        new Thread(this.engine).start();
    }

    public void execEngineBlock() {
        this.engine.run();
    }

    public void stopEngine() {
        this.engine.stop();
    }

    public void printMemory(String id, int addr, int length) throws MicsException {
        System.out.println(this.engine.getDataBuffer(id).toString(addr, length));
    }

    public void execStepByStep() throws ExecutableElementException, MicsException, DataBufferException {
        this.execStepByStep(1);
    }

    public void execStepByStep(int count) throws MicsException, MicsException, DataBufferException {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < count - 1) {
            this.engine.step();
            ++i;
        }
        str.append(this.engine.getProcStatusString());
        this.engine.step();
        System.out.println(str.toString());
    }

    public String getDefaultDir() {
        return ".";
    }

    public void configTargetArchitecture(File file) throws MicsException {
        this.init();
        try {
            Node top = XMLParser.getTopNode(file);
            String base = file.getParent();
            this.engine.initialize_base(null, base, "engine", top);
        }
        catch (XMLParserException e) {
            throw new MicsException("configuration error: " + e);
        }
        System.out.println("architecture update as " + file.getName());
    }

    public void shutdown(int stat) {
        this.engine.shutdown();
        System.exit(stat);
    }

    public static String printVersion() {
        return String.valueOf(String.valueOf(0)) + "." + String.valueOf(5) + "." + String.valueOf(2);
    }

    public static void main(String[] args) {
        GetOpt opt = new GetOpt("f:ge:", "swt", args);
        boolean script = false;
        File scriptSource = null;
        if (opt.flag("swt")) {
            System.out.println("SWT shell has not been suported yet.");
            System.exit(0);
        } else if (opt.flag("g")) {
            Mics.getInstance().setMicsShell(new MicsPrompt());
        } else {
            Mics.getInstance().setMicsShell(MicsAWTWindow.getInstance());
        }
        try {
            if (opt.flag("f")) {
                try {
                    Mics.getInstance().configTargetArchitecture(new File(opt.getValue("f")));
                }
                catch (MicsException e) {
                    System.out.println("configuration error: " + e);
                    System.exit(0);
                }
            }
            if (opt.flag("e")) {
                script = true;
                scriptSource = new File(opt.getValue("e"));
                if (!scriptSource.exists()) {
                    System.out.println("usage: net.wasamon.mics.Mics -e script");
                    System.exit(0);
                }
            }
        }
        catch (GetOptException e) {
            System.out.println("usage: net.wasamon.mics.Mics [-f config.xml]");
            System.exit(0);
        }
        try {
            System.out.println("MICS is Cycle-level Simulator");
            System.out.println("Version: " + Mics.printVersion());
            System.out.println("Copyright (c) 2005-2007 Takefumi MIYOSHI All Rights Reserved.");
            if (!script) {
                Mics.getInstance().shell.exec();
            } else {
                Mics.getInstance().shell.exec(scriptSource);
            }
        }
        catch (MicsException e) {
            System.err.println(e);
        }
    }

    public void readMemory(String[] cmd) throws MicsException {
        if (cmd.length == 4) {
            Mics.getInstance().printMemory(cmd[1], Integer.parseInt(cmd[2]), Integer.parseInt(cmd[3]));
        } else {
            System.out.println("memory id addr length");
        }
    }

    public void loadFile(String[] cmd) throws MicsException {
        try {
            if (cmd.length != 4) {
                throw new MicsException("load id offset \"file\"");
            }
            Mics.getInstance().setMemoryData(cmd[1], Integer.parseInt(cmd[2]), new BufferedInputStream(new FileInputStream(new File(cmd[3]))));
        }
        catch (FileNotFoundException e) {
            System.out.println("no such file " + cmd[3]);
        }
    }
}

