/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime.resource;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jp.sourceforge.mergedoc.org.apache.commons.io.IOUtils;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.runtime.Analyses;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.CacheFiles;

public class TransformedClassCache {
    private static final Logger log = Logger.getLogger(TransformedClassCache.class);
    private static final TransformedClassCache singleton = new TransformedClassCache();
    private final File cacheFile = Pleiades.getResourceFile(CacheFiles.TRANSFORMED_CLASS_CACHE);
    private Map<String, byte[]> loadMap = new HashMap<String, byte[]>();
    private Map<String, byte[]> storeMap = new ConcurrentHashMap<String, byte[]>();

    public static TransformedClassCache getInstance() {
        return singleton;
    }

    private TransformedClassCache() {
        this.loadMap = this.load();
    }

    private Map<String, byte[]> load() {
        HashMap<String, byte[]> map;
        long start;
        block8: {
            start = System.nanoTime();
            map = new HashMap<String, byte[]>();
            if (!this.cacheFile.exists()) {
                log.info(String.valueOf(this.cacheFile.getName()) + " \u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", new Object[0]);
            } else {
                ZipInputStream in = null;
                try {
                    try {
                        in = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile)));
                        ZipEntry inEntry = null;
                        while ((inEntry = in.getNextEntry()) != null) {
                            byte[] bytecode = IOUtils.toByteArray(in);
                            map.put(inEntry.getName(), bytecode);
                        }
                        log.info("load  %6d \u30a8\u30f3\u30c8\u30ea\u30fc %s", map.size(), this.cacheFile.getName());
                    }
                    catch (Exception e) {
                        log.warn("\u5909\u63db\u6e08\u307f\u30af\u30e9\u30b9\u30fb\u30ad\u30e3\u30c3\u30b7\u30e5 %s \u306e\u7834\u640d\u3092\u691c\u51fa\u3002\u5fa9\u5143\u4e2d... - %s", this.cacheFile, e.toString());
                        this.cacheFile.delete();
                        map.clear();
                        IOUtils.closeQuietly(in);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly(in);
            }
        }
        Analyses.end(this.getClass(), "<init>", start);
        return map;
    }

    public void shutdown() {
        block7: {
            if (this.storeMap == null || this.storeMap.size() == 0) {
                return;
            }
            Map<String, byte[]> map = this.load();
            ZipOutputStream out = null;
            try {
                try {
                    out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));
                    out.setLevel(1);
                    Map<String, byte[]> sMap = this.storeMap;
                    this.storeMap = null;
                    map.putAll(sMap);
                    for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                        out.putNextEntry(new ZipEntry(entry.getKey()));
                        out.write(entry.getValue());
                    }
                    log.info("store  %6d \u30a8\u30f3\u30c8\u30ea\u30fc %s", map.size(), this.cacheFile.getName());
                }
                catch (IOException e) {
                    log.error(e, String.valueOf(this.cacheFile.getName()) + "\u306e\u4fdd\u7ba1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", new Object[0]);
                    IOUtils.closeQuietly(out);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly(out);
        }
    }

    public byte[] get(String classId) {
        return this.loadMap.remove(classId);
    }

    public void putNextLaunch(String classId, byte[] bytecode) {
        if (this.storeMap == null) {
            return;
        }
        if (this.storeMap.containsKey(classId)) {
            return;
        }
        this.storeMap.put(classId, bytecode);
    }

    public boolean contains(String classId) {
        if (this.storeMap == null) {
            return false;
        }
        return this.storeMap.containsKey(classId);
    }

    public boolean isActive() {
        return this.storeMap != null;
    }
}

