/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime.resource;

import jp.sourceforge.mergedoc.pleiades.runtime.resource.IdentityTranslationCache;
import junit.framework.TestCase;

public class IdentityTranslationCacheTest
extends TestCase {
    protected final IdentityTranslationCache cache = new IdentityTranslationCache();
    protected static final char ESC_CHAR = '\u001b';

    protected void assertLookup(String input, String expected) {
        String result = this.cache.translateUnderscoreMnemonic(input.replace('@', '\u001b'), null);
        System.out.println(input + "=" + result);
        IdentityTranslationCacheTest.assertEquals((String)expected, (String)result.replace('\u001b', '@'));
    }

    protected void assertLookupFalse(String input) {
        String result = this.cache.translateUnderscoreMnemonic(input, null);
        System.out.println(input + "=" + result);
        IdentityTranslationCacheTest.assertEquals((String)input, (String)result);
    }

    public void testLookup() {
        this.assertLookup("D@eployment", "\u30c7\u30d7\u30ed\u30a4(@E)");
        this.assertLookup("@Automatic Upload", "\u81ea\u52d5\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9(@A)");
        this.assertLookup("Include &non-&&project files", "\u975e\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30fb\u30d5\u30a1\u30a4\u30eb\u3092\u542b\u3081\u308b");
        this.assertLookup("Set layout_width to match_parent", "layout_width \u306b match_parent \u3092\u8a2d\u5b9a\u3059\u308b");
        this.assertLookupFalse("KOTLIN_BUNDLED");
        this.assertLookupFalse("keep_java-style_getters_and_setters");
        this.assertLookup("'aaa' x_y_z", "'aaa' x_y_z");
        this.assertLookup("'aaa' x_yz", "'aaa' xyz(_Y)");
        this.assertLookup("'a_aa' x_yz", "'a_aa' xyz(_Y)");
        this.assertLookup("_Tasks & Contexts", "\u30bf\u30b9\u30af\u304a\u3088\u3073\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8(_T)");
    }
}

