/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime.resource;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.mergedoc.org.apache.commons.lang.StringUtils;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.RuntimeJointPoint;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.RuntimeTranslationDictionary;

public class IdentityTranslationCache {
    private static final Logger log = Logger.getLogger(IdentityTranslationCache.class);
    private static final RuntimeTranslationDictionary dictionary = RuntimeTranslationDictionary.getInstance();
    private String jaCache;
    private String enCache;
    private static final int LRU_CACHE_CAPACITY = 100;
    private static Map<IdentityKey, Map<String, String>> targetObjectCache = new LinkedHashMap<IdentityKey, Map<String, String>>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<IdentityKey, Map<String, String>> eldest) {
            boolean removes = this.size() > 100;
            return removes;
        }
    };

    private Map<String, String> getCache(String en, RuntimeJointPoint jointPoint) {
        if (jointPoint == null) {
            return null;
        }
        IdentityKey targetKey = new IdentityKey(jointPoint.getTarget());
        Map<String, String> enJaMap = targetObjectCache.get(targetKey);
        if (enJaMap == null) {
            enJaMap = new HashMap<String, String>();
            targetObjectCache.put(targetKey, enJaMap);
        }
        return enJaMap;
    }

    public String translateMnemonic(String en, RuntimeJointPoint jointPoint) {
        return this.translate(en, jointPoint, true);
    }

    public String translateNoMnemonic(String en, RuntimeJointPoint jointPoint) {
        return this.translate(en, jointPoint, false);
    }

    private String translate(String en, RuntimeJointPoint jointPoint, boolean mnemonics) {
        String ja;
        if (en == this.enCache) {
            return this.jaCache;
        }
        if (en.isEmpty()) {
            return en;
        }
        Map<String, String> cache = this.getCache(en, jointPoint);
        if (cache != null && (ja = cache.get(en)) != null) {
            return ja;
        }
        if (en.length() > 6000) {
            if (log.isDebugEnabled()) {
                log.debug("\u7ffb\u8a33\u5bfe\u8c61\u304c\u5927\u304d\u3059\u304e\u308b\u305f\u3081\u7121\u8996 length=%d %s %s", en.length(), jointPoint, en.substring(0, 2000).replaceAll("\n", "\\\\n"));
            }
            return en;
        }
        if (mnemonics) {
            if (en.length() > 300) {
                mnemonics = false;
            } else if (en.charAt(0) == '<' && en.startsWith("<html")) {
                mnemonics = false;
            }
        }
        this.jaCache = dictionary.lookup(en, jointPoint, mnemonics);
        this.enCache = en;
        if (cache != null) {
            cache.put(this.enCache, this.jaCache);
        }
        return this.jaCache;
    }

    public String translateUnderscoreMnemonic(String en, RuntimeJointPoint jointPoint) {
        String jaAmp;
        String ja;
        if (en == this.enCache) {
            return this.jaCache;
        }
        if (en.isEmpty()) {
            return en;
        }
        Map<String, String> cache = this.getCache(en, jointPoint);
        if (cache != null && (ja = cache.get(en)) != null) {
            return ja;
        }
        int origin = 0;
        int ESC = 27;
        if (en.indexOf(27) > -1) {
            origin = 27;
        } else if (en.contains("&&") && en.matches(".+&&\\w.+")) {
            log.debug("\u7279\u6b8a\u306a && \u3092\u9664\u53bb '%s'", en);
            en = en.replaceAll("&", "");
        } else if (en.contains("_") && StringUtils.countMatches(en, "/") <= 2 && StringUtils.countMatches(en, "\\") <= 2 && this.countNonQuoted(en, '_') < 2 && !en.matches(".+[A-Z]_HOME.*") && !en.matches("[A-Z][A-Z_]+[A-Z]") && !en.matches(".*&\\w.*") && en.matches(".*_\\w.*")) {
            origin = 95;
        }
        if (origin == 0) {
            String ja2 = this.translateMnemonic(en, jointPoint);
            if (en.contains("&") && !ja2.contains("&")) {
                ja2 = ja2 + "&";
            }
            return ja2;
        }
        String enAmp = this.replaceNonQuoted(en, (char)origin, '&');
        this.jaCache = enAmp.equals(jaAmp = dictionary.lookup(enAmp, jointPoint, true)) ? en : this.replaceNonQuoted(jaAmp, '&', (char)origin);
        this.enCache = en;
        if (cache != null) {
            cache.put(this.enCache, this.jaCache);
        }
        return this.jaCache;
    }

    private int countNonQuoted(String s, char ch) {
        int count = 0;
        boolean insideQuote = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                boolean bl = insideQuote = !insideQuote;
            }
            if (insideQuote || c != ch) continue;
            ++count;
        }
        return count;
    }

    private String replaceNonQuoted(String s, char oldChar, char newChar) {
        char[] chars = s.toCharArray();
        boolean insideQuote = false;
        for (int i = 0; i < chars.length - 1; ++i) {
            char next;
            char c = chars[i];
            if (c == '\'') {
                boolean bl = insideQuote = !insideQuote;
            }
            if (insideQuote || c != oldChar || !String.valueOf(next = chars[i + 1]).matches("\\w")) continue;
            chars[i] = newChar;
            break;
        }
        return new String(chars);
    }

    private static class IdentityKey {
        private final Object target;

        public IdentityKey(Object target) {
            this.target = target;
        }

        public boolean equals(Object obj) {
            return obj instanceof IdentityKey && ((IdentityKey)obj).target == this.target;
        }

        public int hashCode() {
            return this.target.hashCode();
        }
    }
}

