/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;

public class ExcludePackageProperties {
    private static final Logger log = Logger.getLogger(ExcludePackageProperties.class);
    private static final ExcludePackageProperties singleton = new ExcludePackageProperties();
    private final Map<String, List<String>> map = new HashMap<String, List<String>>();

    public static ExcludePackageProperties getInstance() {
        return singleton;
    }

    private ExcludePackageProperties() {
        String appName = Pleiades.getPleiadesOption().appName;
        if (appName == null) {
            return;
        }
        String appPrefix = String.valueOf(appName) + ":";
        File file = Files.conf("translation-exclude-package.properties");
        if (!file.exists()) {
            String msg = String.valueOf(file.getName()) + " \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
            log.fatal(msg, new Object[0]);
            FileNotFoundException e = new FileNotFoundException(file.getPath());
            throw new IllegalStateException(msg, e);
        }
        PropertySet prop = new PropertySet(100).load(file);
        for (Property p : prop) {
            ArrayList<String> pkgs = new ArrayList<String>();
            String[] stringArray = p.value.split("\\s*,\\s*");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pkg = stringArray[n2];
                if (pkg.startsWith(appPrefix)) {
                    pkgs.add(pkg.substring(appPrefix.length()));
                }
                ++n2;
            }
            if (pkgs.size() <= 0) continue;
            this.map.put(p.key, pkgs);
        }
    }

    public List<String> getPathEntries(String enValue) {
        List<String> pathEntries = this.map.get(enValue);
        if (pathEntries != null && pathEntries.contains("")) {
            log.info(new IllegalStateException(), "[" + enValue + "] \u306e\u7ffb\u8a33\u547c\u3073\u51fa\u3057\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9\u3002", new Object[0]);
            return null;
        }
        return pathEntries;
    }
}

