/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import jp.sourceforge.mergedoc.org.apache.commons.lang.StringUtils;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.runtime.Analyses;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.PleiadesConfig;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.RuntimeJointPoint;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.TraceConfig;

public class TranslationEditor
extends ExprEditor {
    private static final Logger log = Logger.getLogger(TranslationEditor.class);
    private static final TraceConfig traceConfig = PleiadesConfig.getInstance().traceConfig;
    private final CtClass ctClass;
    private boolean isEdited;

    public TranslationEditor(CtClass ctClass) {
        this.ctClass = ctClass;
    }

    public void edit(ConstructorCall call) throws CannotCompileException {
        this.edit((MethodCall)call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void edit(MethodCall call) throws CannotCompileException {
        long start = System.nanoTime();
        boolean isConstructor = call instanceof ConstructorCall;
        try {
            String advice;
            PleiadesConfig config;
            String targetClassName = call.getClassName();
            String targetMethodName = call.getMethodName();
            if (isConstructor) {
                targetMethodName = targetClassName.replaceFirst("(.+?\\.)+", "");
                targetMethodName = this.optimizeConstructorName(targetClassName, targetMethodName);
            }
            if (!(config = PleiadesConfig.getInstance()).containsCall(targetClassName, targetMethodName)) {
                return;
            }
            JointPoint targetJP = new JointPoint();
            targetJP.setEditPoint(JointPoint.EditPoint.CALL);
            targetJP.setClassName(targetClassName);
            targetJP.setMethodName(targetMethodName);
            PointCut pointCut = config.getPointCut(targetJP);
            if (pointCut == null) {
                try {
                    CtMethod targetMethod = isConstructor ? ((ConstructorCall)call).getConstructor() : call.getMethod();
                    targetJP.setDescriptor(targetMethod.getMethodInfo().getDescriptor());
                }
                catch (NotFoundException e) {
                    log.warn("\u547c\u3073\u51fa\u3057\u5148 %s \u30af\u30e9\u30b9\u30d1\u30b9\u306a\u3057\u3002\u547c\u3073\u51fa\u3057\u5143: %s", targetClassName, this.ctClass.getName());
                    Analyses.end(TranslationEditor.class, "edit", start);
                    return;
                }
                pointCut = config.getPointCut(targetJP);
            }
            if (pointCut == null) {
                return;
            }
            if (!this.isEnabledLevel(pointCut.getLevel())) {
                return;
            }
            CtBehavior whereMethod = call.where();
            String whereClassName = whereMethod.getDeclaringClass().getName();
            String whereMethodName = whereMethod.getName();
            whereMethodName = this.optimizeConstructorName(whereClassName, whereMethodName);
            if (traceConfig == null || !TranslationEditor.traceConfig.disabled) {
                if (this.containsWhere(pointCut.getExcludeWheres(), whereClassName, whereMethodName)) {
                    return;
                }
                List<JointPoint> includeWheres = pointCut.getIncludeWheres();
                if (includeWheres.size() > 0 && !this.containsWhere(includeWheres, whereClassName, whereMethodName)) {
                    return;
                }
            }
            if ((advice = pointCut.getAdvice()).contains("?{")) {
                JointPoint whereJP = new JointPoint();
                whereJP.setEditPoint(JointPoint.EditPoint.CALL);
                whereJP.setClassName(whereMethod.getDeclaringClass().getName());
                whereJP.setMethodName(whereMethod.getName());
                whereJP.setDescriptor(whereMethod.getMethodInfo().getDescriptor());
                advice = this.bindArguments(advice, whereJP, targetJP);
            }
            try {
                call.replace(advice);
                this.isEdited = true;
            }
            catch (CannotCompileException e) {
                log.warn("%s \u547c\u3073\u51fa\u3057\u5143: %s#%s\u3001\u547c\u3073\u51fa\u3057\u5148: %s#%s", new Object[]{e, whereClassName, whereMethodName, targetClassName, targetMethodName});
            }
        }
        finally {
            Analyses.end(TranslationEditor.class, "edit", start);
        }
    }

    private boolean isEnabledLevel(String level) {
        if (level == null) {
            return true;
        }
        return log.isEnabled(Logger.Level.valueOf(level.toUpperCase()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsWhere(List<JointPoint> jointPointList, String whereClassName, String whereMethodName) {
        long start = System.nanoTime();
        try {
            for (JointPoint jointPoint : jointPointList) {
                String mName;
                if (!whereClassName.startsWith(jointPoint.getClassName()) || (mName = jointPoint.getMethodName()) != null && !whereMethodName.equals(mName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Analyses.end(TranslationEditor.class, "containsWhere", start);
        }
    }

    private String bindArguments(String advice, JointPoint whereJP, JointPoint targetJP) {
        long start = System.nanoTime();
        if (advice.contains("?{JOINT_POINT}")) {
            advice = advice.replaceAll("\\?\\{JOINT_POINT\\}", Matcher.quoteReplacement("new " + RuntimeJointPoint.class.getName() + "(" + JointPoint.EditPoint.class.getName() + "." + whereJP.getEditPoint().name() + ",\"" + whereJP.getClassName() + "\"" + ",\"" + whereJP.getMethodName() + "\"" + ",\"" + whereJP.getDescriptor() + "\"" + ", $0" + ")"));
        }
        if (advice.contains("?{TARGET_STRING}")) {
            advice = advice.replaceAll("\\?\\{TARGET_STRING\\}", Matcher.quoteReplacement("\"" + targetJP.getClassName() + "#" + targetJP.getMethodName() + StringUtils.trimToEmpty(targetJP.getDescriptor()) + "\""));
        }
        Analyses.end(TranslationEditor.class, "bindArguments", start);
        return advice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editBehavior(CtBehavior ctBehavior) throws CannotCompileException {
        long start = System.nanoTime();
        try {
            String className = this.ctClass.getName();
            String methodName = ctBehavior.getName();
            methodName = this.optimizeConstructorName(className, methodName);
            JointPoint jointPoint = new JointPoint();
            jointPoint.setEditPoint(JointPoint.EditPoint.EXECUTION);
            jointPoint.setClassName(className);
            jointPoint.setMethodName(methodName);
            jointPoint.setDescriptor(ctBehavior.getMethodInfo().getDescriptor());
            PleiadesConfig mapping = PleiadesConfig.getInstance();
            PointCut pointCut = mapping.getPointCut(jointPoint);
            if (pointCut == null) {
                return;
            }
            if (!this.isEnabledLevel(pointCut.getLevel())) {
                return;
            }
            PointCut.Timing timing = pointCut.getTiming();
            String advice = this.bindArguments(pointCut.getAdvice(), jointPoint, jointPoint);
            if (timing == PointCut.Timing.BEFORE) {
                ctBehavior.insertBefore(advice);
            } else if (timing == PointCut.Timing.AFTER) {
                ctBehavior.insertAfter(advice);
            } else {
                throw new IllegalStateException("\u7de8\u96c6\u30dd\u30a4\u30f3\u30c8\u304c execution \u306e\u5834\u5408\u3001timing \u306f before \u307e\u305f\u306f after \u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" + jointPoint);
            }
            this.isEdited = true;
        }
        finally {
            Analyses.end(TranslationEditor.class, "editBehavior", start);
        }
    }

    private String optimizeConstructorName(String className, String methodName) {
        if (className.contains("$") && methodName.contains("$") && !methodName.endsWith("$") && className.endsWith(methodName)) {
            return methodName.substring(methodName.indexOf("$") + 1);
        }
        return methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytecode() throws IOException, CannotCompileException {
        long start = System.nanoTime();
        try {
            byte[] byArray = this.isEdited ? this.ctClass.toBytecode() : null;
            return byArray;
        }
        finally {
            Analyses.end(TranslationEditor.class, "toBytecode", start);
        }
    }
}

