/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.org.apache.commons.lang.ArrayUtils;
import jp.sourceforge.mergedoc.org.apache.commons.lang.StringUtils;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.PleiadesOption;
import jp.sourceforge.mergedoc.pleiades.log.FileLogger;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import jp.sourceforge.mergedoc.pleiades.runtime.AbstractTransformer;
import jp.sourceforge.mergedoc.pleiades.runtime.Analyses;
import jp.sourceforge.mergedoc.pleiades.runtime.Applications;
import jp.sourceforge.mergedoc.pleiades.runtime.AsyncCommand;
import jp.sourceforge.mergedoc.pleiades.runtime.AsyncQueue;
import jp.sourceforge.mergedoc.pleiades.runtime.LauncherEclipseTransformer;
import jp.sourceforge.mergedoc.pleiades.runtime.Locks;
import jp.sourceforge.mergedoc.pleiades.runtime.TranslationTransformer;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.PleiadesConfig;
import jp.sourceforge.mergedoc.pleiades.runtime.advice.TraceConfig;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.CacheFiles;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.CallHierarchyExplorer;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.ExcludeClassNameCache;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.ExcludePackageProperties;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.RuntimeTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.TransformedClassCache;

public class LauncherTransformer
extends AbstractTransformer {
    private static final Logger log = Logger.getLogger(LauncherTransformer.class);
    private static final String THIS_CLASS = LauncherTransformer.class.getName();
    protected static volatile TransformedClassCache transformedClassCache;
    private static LauncherTransformer thisInstance;
    private static final String CLEAN_OPTION_STRING = "-clean";

    public LauncherTransformer() {
        thisInstance = this;
        this.init();
    }

    protected void init() {
        long start = System.nanoTime();
        final File pleiadesConfigurationPath = Applications.getPleiadesConfigurationPath();
        PleiadesConfig.getInstance();
        AsyncQueue.add(new AsyncCommand("-clean \u306b\u4f9d\u5b58\u3057\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u306e\u30ed\u30fc\u30c9"){

            @Override
            public void execute() throws Exception {
                File initBatchMarkFile;
                ExcludePackageProperties.getInstance();
                RegexDictionary.getInstance();
                String initBatch = Pleiades.getPleiadesOption().initBatch;
                if (initBatch != null && !(initBatchMarkFile = new File(pleiadesConfigurationPath, ".init.batch.processed")).exists()) {
                    initBatchMarkFile.createNewFile();
                    String cmd = "cmd /c start " + initBatch.replace('/', '\\');
                    File currentDir = new File(Applications.getHome(), initBatch.replaceFirst("[^/\\\\]+$", ""));
                    log.info("\u521d\u56de\u8d77\u52d5\u6642\u5b9f\u884c\u30b3\u30de\u30f3\u30c9\u5b9f\u884c \u30b3\u30de\u30f3\u30c9:" + cmd + " \u30ab\u30ec\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea:" + currentDir, new Object[0]);
                    Runtime.getRuntime().exec(cmd, null, currentDir);
                }
            }
        });
        AsyncQueue.addAwait(new AsyncCommand("\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u30d5\u30a1\u30a4\u30eb\u51fa\u529b"){

            @Override
            public void execute() throws Exception {
                File sysPropFile = new File(pleiadesConfigurationPath, "system.properties");
                PleiadesOption pleiadesOption = Pleiades.getPleiadesOption();
                if (log.isDebugEnabled()) {
                    if (!pleiadesOption.isClean && !sysPropFile.exists()) {
                        pleiadesOption.isClean = true;
                        log.info("-clean \u3092\u6709\u52b9\u306b\u3057\u307e\u3057\u305f\u3002(\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3 debug OFF -> ON \u5909\u66f4\u691c\u51fa)", new Object[0]);
                    }
                    new PropertySet(System.getProperties()).store(sysPropFile, "System Properties");
                } else if (!pleiadesOption.isClean && sysPropFile.exists()) {
                    sysPropFile.delete();
                    pleiadesOption.isClean = true;
                    log.info("-clean \u3092\u6709\u52b9\u306b\u3057\u307e\u3057\u305f\u3002(\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3 debug ON -> OFF \u5909\u66f4\u691c\u51fa)", new Object[0]);
                }
            }
        });
        Analyses.end(LauncherTransformer.class, "init", start);
    }

    @Override
    protected byte[] transformBytecode(String classId, String className, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        if (className.startsWith("jp.sourceforge.mergedoc.")) {
            return null;
        }
        try {
            CtClass clazz = this.createCtClass(bytecode);
            CtMethod main = clazz.getMethod("main", "([Ljava/lang/String;)V");
            main.insertBefore("$1 = " + THIS_CLASS + ".start($$);" + THIS_CLASS + ".addShutdownHook();" + THIS_CLASS + ".shutdownLauncherProcess();");
            byte[] byArray = clazz.toBytecode();
            return byArray;
        }
        finally {
            LauncherTransformer.removeTransformer();
        }
    }

    @Override
    protected void handleException(Throwable e, String msg) {
        log.error(e, msg, new Object[0]);
    }

    protected static void removeTransformer() {
        log.info("Pleiades AOP \u8d77\u52d5\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u3092\u505c\u6b62\u3057\u307e\u3059\u3002", new Object[0]);
        Pleiades.getInstrumentation().removeTransformer(thisInstance);
    }

    protected static String[] startTranslationTransformer(String ... args) {
        long start = System.nanoTime();
        try {
            File excludeList;
            PleiadesOption option = Pleiades.getPleiadesOption();
            ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
            boolean isIncludeArgsClean = argList.contains(CLEAN_OPTION_STRING);
            if (!option.isClean) {
                option.isClean = isIncludeArgsClean;
            }
            if (!option.isClean && !(excludeList = Pleiades.getResourceFile(CacheFiles.EXCLUDE_CLASS_LIST)).exists()) {
                log.info("\u5909\u63db\u9664\u5916\u30af\u30e9\u30b9\u540d\u30ad\u30e3\u30c3\u30b7\u30e5\u304c\u5b58\u5728\u3057\u306a\u3044\u305f\u3081\u3001\u5f37\u5236\u7684\u306b -clean \u30e2\u30fc\u30c9\u3067\u8d77\u52d5\u3057\u307e\u3059\u3002", new Object[0]);
                option.isClean = true;
            }
            log.info("\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306e\u8d77\u52d5\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002-clean:" + option.isClean, new Object[0]);
            if (option.isClean) {
                CacheFiles.clear();
                if (!isIncludeArgsClean) {
                    argList.add(CLEAN_OPTION_STRING);
                }
            } else {
                LauncherTransformer.removeTransformer();
            }
            Locks.lock();
            AsyncQueue.add(new AsyncCommand("\u30ea\u30bd\u30fc\u30b9\u306e\u30ed\u30fc\u30c9"){

                @Override
                public void execute() {
                    try {
                        ExcludeClassNameCache.getInstance();
                        transformedClassCache = TransformedClassCache.getInstance();
                        RuntimeTranslationDictionary.getInstance();
                    }
                    finally {
                        Locks.release();
                    }
                }
            });
            log.info("Pleiades AOP \u7ffb\u8a33\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u3092\u958b\u59cb\u3057\u307e\u3059\u3002", new Object[0]);
            Instrumentation inst = Pleiades.getInstrumentation();
            TraceConfig traceConfig = PleiadesConfig.getInstance().traceConfig;
            if (traceConfig != null && StringUtils.isNotEmpty(traceConfig.logDescClass)) {
                inst.addTransformer(new TranslationTransformer.LoggingDescTranslationTransformer(traceConfig.logDescClass));
            } else {
                inst.addTransformer(new TranslationTransformer());
            }
            String[] stringArray = argList.toArray(new String[argList.size()]);
            return stringArray;
        }
        catch (Throwable e) {
            String msg = "Pleiades AOP \u7ffb\u8a33\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u306e\u958b\u59cb\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            log.fatal(e, msg, new Object[0]);
            throw new IllegalStateException(msg, e);
        }
        finally {
            Analyses.end(LauncherEclipseTransformer.class, "startTranslationTransformer", start);
        }
    }

    public static String[] start(String ... args) {
        AsyncQueue.awaitTermination();
        LauncherTransformer.startTranslationTransformer(args);
        String[] newArgs = (String[])ArrayUtils.removeElement(args, CLEAN_OPTION_STRING);
        return newArgs;
    }

    public static void shutdownLauncherProcess() {
        AsyncQueue.add(new AsyncCommand("\u975e\u540c\u671f\u30ad\u30e5\u30fc\u306e\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3"){

            @Override
            public void execute() throws Exception {
                AsyncQueue.shutdown();
            }
        });
    }

    public static void addShutdownHook() {
        AsyncQueue.add(new AsyncCommand("\u30ea\u30bd\u30fc\u30b9\u306e\u30ed\u30fc\u30c9"){

            @Override
            public void execute() {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                log.debug("Java \u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u30d5\u30c3\u30af\u3092\u767b\u9332\u3057\u307e\u3059\u3002", new Object[0]);
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        log.debug("Java \u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u30d5\u30c3\u30af\u304c\u547c\u3073\u51fa\u3055\u308c\u307e\u3057\u305f\u3002", new Object[0]);
                        LauncherTransformer.shutdown();
                    }
                });
                if (log.isDebugEnabled()) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Analyses.flashLog("\u30b9\u30bf\u30fc\u30c8\u30a2\u30c3\u30d7\u6642\u306e\u8a08\u6e2c", new Object[0]);
                }
            }
        });
    }

    public static void shutdown() {
        if (log.isDebugEnabled()) {
            Analyses.flashLog("Pleiades \u3092\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u3057\u307e\u3059\u3002", new Object[0]);
        }
        try {
            try {
                Locks.lock();
                if (RuntimeTranslationDictionary.getInstance().isInvalidateCache) {
                    CacheFiles.clear();
                } else {
                    TransformedClassCache.getInstance().shutdown();
                    ExcludeClassNameCache.getInstance().shutdown();
                    RuntimeTranslationDictionary.getInstance().shutdown();
                }
                CallHierarchyExplorer.getInstance().flushStackTraceCount();
            }
            catch (Exception e) {
                log.warn(e, "\u30ad\u30e3\u30c3\u30b7\u30e5\u306e\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", new Object[0]);
                Locks.release();
                AsyncQueue.shutdown();
                FileLogger.close();
                if (Pleiades.getPleiadesOption().isPreload()) {
                    System.exit(0);
                }
            }
        }
        finally {
            Locks.release();
            AsyncQueue.shutdown();
            FileLogger.close();
            if (Pleiades.getPleiadesOption().isPreload()) {
                System.exit(0);
            }
        }
    }

    public static void debug(Object o) {
        log.debug(String.valueOf(o), new Object[0]);
    }
}

