/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime;

import java.io.File;
import java.io.IOException;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.PleiadesOption;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.runtime.Analyses;
import jp.sourceforge.mergedoc.pleiades.runtime.Applications;
import jp.sourceforge.mergedoc.pleiades.runtime.AsyncCommand;
import jp.sourceforge.mergedoc.pleiades.runtime.AsyncQueue;
import jp.sourceforge.mergedoc.pleiades.runtime.LauncherTransformer;

public class LauncherIdeaTransformer
extends LauncherTransformer {
    private static final Logger log = Logger.getLogger(LauncherIdeaTransformer.class);

    @Override
    protected void init() {
        long start = System.nanoTime();
        String jarFileName = "bootstrap.jar";
        String jarPath = null;
        String[] stringArray = System.getProperty("java.class.path").split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.endsWith("bootstrap.jar")) {
                jarPath = path;
                break;
            }
            ++n2;
        }
        if (jarPath == null) {
            throw new IllegalStateException("bootstrap.jar \u304c\u898b\u3064\u304b\u3089\u306a\u3044\u305f\u3081 lib \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30fc\u3092\u7279\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        final File lib = new File(jarPath).getParentFile();
        AsyncQueue.add(new AsyncCommand("IDEA lib \u306e jar \u3092 AOP \u30af\u30e9\u30b9\u30d1\u30b9\u3078\u8ffd\u52a0"){

            @Override
            public void execute() throws Exception {
                File[] fileArray = lib.listFiles(Files.createSuffixFilter(".jar"));
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File jar = fileArray[n2];
                    LauncherIdeaTransformer.this.addClassPath(jar);
                    ++n2;
                }
                File plugins = new File(lib.getParentFile(), "plugins");
                LauncherIdeaTransformer.this.addClassPathExists(new File(plugins, "android/lib/android.jar"));
                LauncherIdeaTransformer.this.addClassPathExists(new File(plugins, "android/lib/sdk-tools.jar"));
                LauncherIdeaTransformer.this.addClassPathExists(new File(plugins, "sdk-updates/lib/sdk-updates.jar"));
            }
        });
        final PleiadesOption option = Pleiades.getPleiadesOption();
        if (!option.isClean) {
            AsyncQueue.addAwait(new AsyncCommand("IDEA \u6700\u7d42\u66f4\u65b0\u6642\u523b\u306e\u5224\u5b9a"){

                @Override
                public void execute() throws Exception {
                    if (Applications.isUpdated(lib)) {
                        option.isClean = true;
                        log.info("IDEA \u306e\u66f4\u65b0\u304c\u691c\u51fa\u3055\u308c\u305f\u305f\u3081\u3001\u5f37\u5236\u7684\u306b -clean \u30e2\u30fc\u30c9\u3067\u8d77\u52d5\u3057\u307e\u3059\u3002", new Object[0]);
                    }
                }
            });
        }
        super.init();
        Analyses.end(LauncherIdeaTransformer.class, "init", start);
    }

    protected void addClassPathExists(File jarFile) throws IOException, NotFoundException {
        if (jarFile.exists()) {
            log.info("\u8ffd\u52a0\u30af\u30e9\u30b9\u30d1\u30b9\u3042\u308a: " + jarFile.getPath(), new Object[0]);
            this.addClassPath(jarFile);
        } else {
            log.info("\u8ffd\u52a0\u30af\u30e9\u30b9\u30d1\u30b9\u306a\u3057: " + jarFile.getPath(), new Object[0]);
        }
    }
}

