/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;

public class CleanMessage {
    private static final Logger log = Logger.getLogger(CleanMessage.class);
    private static JWindow cleanWindow;

    public static void show(final String splashLocation) {
        if (Pleiades.getOS() == Pleiades.OS.MAC) {
            log.info("\u30af\u30ea\u30fc\u30f3\u8d77\u52d5\u3057\u307e\u3059\u3002(Mac \u3067\u306f\u30af\u30ea\u30fc\u30f3\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8\u8868\u793a\u4e0d\u53ef)", new Object[0]);
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ImageIcon cleanIcon;
                    Image cleanImage;
                    Image resizedCleanImage;
                    if (cleanWindow == null) {
                        cleanWindow = new JWindow();
                    }
                    if ((resizedCleanImage = CleanMessage.setupRectangle(splashLocation, cleanImage = (cleanIcon = new ImageIcon(Files.conf("images/splash_clean.png").toURI().toURL())).getImage())) != null) {
                        cleanIcon.setImage(resizedCleanImage);
                    }
                    JLabel cleanComponent = new JLabel(cleanIcon);
                    cleanWindow.getContentPane().add(cleanComponent);
                    cleanWindow.pack();
                    cleanWindow.setVisible(true);
                }
                catch (Exception e) {
                    log.error(e, "\u30af\u30ea\u30fc\u30f3\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u8868\u793a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", new Object[0]);
                }
            }
        });
    }

    protected static Image setupRectangle(String splashLocation, Image cleanImage) throws IOException {
        File splashFile;
        Dimension eclipseSplash = null;
        if (splashLocation != null && (splashFile = new File(splashLocation)).exists()) {
            BufferedImage splash = ImageIO.read(splashFile);
            eclipseSplash = new Dimension(splash.getWidth(), splash.getHeight());
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle cleanRect = cleanWindow.getBounds();
        Image resizedCleanImage = null;
        if (eclipseSplash == null) {
            cleanRect.x = screenSize.width / 2 - cleanImage.getWidth(null) / 2;
            cleanRect.y = screenSize.height / 2 - cleanImage.getHeight(null) / 2;
        } else {
            if (eclipseSplash.width > 400 && eclipseSplash.width < 500) {
                resizedCleanImage = cleanImage.getScaledInstance(eclipseSplash.width, cleanImage.getHeight(null), 4);
            }
            cleanRect.x = screenSize.width / 2 - (int)Math.ceil((double)eclipseSplash.width / 2.0);
            cleanRect.y = screenSize.height / 2 + eclipseSplash.height / 2;
        }
        cleanWindow.setBounds(cleanRect);
        log.debug("\u30af\u30ea\u30fc\u30f3\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8\u8868\u793a (Eclipse \u30b9\u30d7\u30e9\u30c3\u30b7\u30e5:%s, \u30e1\u30c3\u30bb\u30fc\u30b8:%s)", eclipseSplash, cleanRect.getLocation());
        return resizedCleanImage;
    }

    public static void close() {
        if (Pleiades.getOS() == Pleiades.OS.MAC) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (cleanWindow != null) {
                    cleanWindow.dispose();
                    cleanWindow = null;
                }
            }
        });
    }
}

