/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.util.List;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationString;
import junit.framework.TestCase;

public class TranslationStringTest
extends TestCase {
    private void printEach(List<TranslationString> list) {
        System.out.println("-------------------------------------------------------------------");
        if (list == null) {
            System.out.println("null");
        } else {
            for (TranslationString s : list) {
                System.out.println("\u2192 " + s);
            }
        }
    }

    public void testTrim() {
        TranslationString t = null;
        t = new TranslationString("[ All configurations ]");
        System.out.println(t.trim());
        TranslationStringTest.assertEquals((String)"[ All configurations ]", (String)t.toString());
        TranslationStringTest.assertEquals((String)"All configurations", (String)t.trim());
        t = new TranslationString("-- End of Stream Output --");
        System.out.println(t.trim());
        TranslationStringTest.assertEquals((String)"-- End of Stream Output --", (String)t.toString());
        TranslationStringTest.assertEquals((String)"End of Stream Output", (String)t.trim());
        t = new TranslationString("<!-- End of Stream Output -->");
        System.out.println(t.trim());
        TranslationStringTest.assertEquals((String)"<!-- End of Stream Output -->", (String)t.toString());
        TranslationStringTest.assertEquals((String)"End of Stream Output", (String)t.trim());
        t = new TranslationString("\"  \"");
        System.out.println(t.trim());
        TranslationStringTest.assertEquals((String)"\"  \"", (String)t.toString());
        TranslationStringTest.assertEquals((String)"", (String)t.trim());
        t = new TranslationString("<html><p style=\"font-family:Lucida Grande;\">OSGi, Web frameworks are detected in the project <a href=\"configure\">Configure</a></p></html>");
        System.out.println(t.trim());
        TranslationStringTest.assertEquals((String)"OSGi, Web frameworks are detected in the project <a href=\"configure\">Configure</a>", (String)t.trim());
        t = new TranslationString("<html>One-line methods<html>");
        System.out.println(t.trim());
        TranslationStringTest.assertEquals((String)"One-line methods", (String)t.trim());
        t = new TranslationString("<html><head><style>\u00a5nxxx\u00a5n</style><style>yyy</style></head><body> zzz <b><a href=\"updates\">Updates</a></b> 000.</body></html>");
        System.out.println(t.trim());
        TranslationStringTest.assertEquals((String)"zzz <b><a href=\"updates\">Updates</a></b> 000.", (String)t.trim());
        TranslationStringTest.assertEquals((String)"zzz <b><a href=\"updates\">Updates</a></b> 000", (String)t.trimForce());
        t = new TranslationString("<i>\u306a\u3057</i>");
        System.out.println(t.trim());
        TranslationStringTest.assertEquals((String)"\u306a\u3057", (String)t.trim());
        t = new TranslationString("10.5.2, 10.6.10).");
        System.out.println(t.trim());
        TranslationStringTest.assertEquals((String)"10.5.2, 10.6.10).", (String)t.toString());
        TranslationStringTest.assertEquals((String)"10.5.2, 10.6.10).", (String)t.trim());
        TranslationStringTest.assertEquals((String)"10.5.2, 10.6.10", (String)t.trimForce());
        TranslationStringTest.assertEquals((String)"10.5.2, 10.6.10)\u3002", (String)t.revert());
        t = new TranslationString("<html><head><style>; </style></head><body><a >xxx</a></body></html>");
        TranslationStringTest.assertEquals((String)"xxx", (String)t.trim());
        t = new TranslationString("add entries prefixed with !");
        TranslationStringTest.assertEquals((String)"add entries prefixed with !", (String)t.trim());
        TranslationStringTest.assertEquals((String)"add entries prefixed with !", (String)t.trimForce());
        t = new TranslationString("<form><p>aaa</p><li>bbb.</li></form>");
        TranslationStringTest.assertEquals((String)"<p>aaa</p><li>bbb.</li>", (String)t.trim());
        TranslationStringTest.assertEquals((String)"aaa</p><li>bbb", (String)t.trimForce());
        t = new TranslationString("<form><p>aaa</p><li>bbb.</li></form>");
        t = new TranslationString(t.trim());
        TranslationStringTest.assertEquals((String)"aaa</p><li>bbb", (String)t.trimForce());
    }

    public void testSplit() {
        TranslationString t = null;
        t = new TranslationString("\u3042\u3044\u3046\u3048\u304a\u3002");
        List<TranslationString> list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals(null, list);
        t = new TranslationString("\u3042\u3044\u3046\u3048\u304a\u3002  \u304b\u304d\u304f\u3051\u3053\u3002");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((String)"\u3042\u3044\u3046\u3048\u304a\u3002  ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"\u304b\u304d\u304f\u3051\u3053\u3002", (String)list.get(1).toString());
        t = new TranslationString("aaa bbb. 1.23 abc - xxx yyy. 1 - 2.");
        t.trimForce();
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((String)"aaa bbb. ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"1.23 abc - ", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"1.23 abc", (String)list.get(1).trim());
        TranslationStringTest.assertEquals((String)"xxx yyy. ", (String)list.get(2).toString());
        TranslationStringTest.assertEquals((String)"1 - 2.", (String)list.get(3).toString());
        t = new TranslationString("Connector to submit code to the R-GUI (Windows).\n Note:\n - The Connector requires .NET-Framework\n - For some operations the connector uses the system-clipboard (previous content will be deleted).");
        list = t.split();
        TranslationStringTest.assertNull(list);
        t = new TranslationString("Analyze the application Method Coverage. See what methods were\nexecuted.");
        list = t.split();
        TranslationStringTest.assertNull(list);
        t = new TranslationString("A required property is missing from the Common Base Event.\nProperty: {0}");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((String)"A required property is missing from the Common Base Event.\n", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"Property: ", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"{0}", (String)list.get(2).toString());
        t = new TranslationString("\u5171\u901a\u30d9\u30fc\u30b9\u30fb\u30a4\u30d9\u30f3\u30c8\u306b\u5fc5\u8981\u306a\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u304c\u3042\u308a\u307e\u305b\u3093\u3002\n\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc: {0}");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((String)"\u5171\u901a\u30d9\u30fc\u30b9\u30fb\u30a4\u30d9\u30f3\u30c8\u306b\u5fc5\u8981\u306a\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u304c\u3042\u308a\u307e\u305b\u3093\u3002\n", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc: ", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"{0}", (String)list.get(2).toString());
        String[] text = new String[]{"\u4f7f\u7528\u53ef\u80fd\u306b\u3059\u308b\u3068\u3001\u30e1\u30bd\u30c3\u30c9/\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u30fc\u306e\u547c\u3073\u51fa\u3057\u306b\u6e21\u3055\u308c\u308b\u3068\u304d\u306b\u53ef\u5909\u5f15\u6570\u306e\u30ad\u30e3\u30b9\u30c8\u304c\u5fc5\u8981\u306a\u5834\u5408\u306b\u3001\u30b3\u30f3\u30d1\u30a4\u30e9\u30fc\u306f\u30a8\u30e9\u30fc\u307e\u305f\u306f\u8b66\u544a\u3092\u51fa\u3057\u307e\u3059\u3002\n", "(\u4f8b\u3048\u3070\u3001\u5f15\u6570 (\"foo\", null) \u3067\u547c\u3073\u51fa\u3055\u308c\u308b Class.getMethod(String name, Class ... args )\u3002)"};
        t = new TranslationString(text[0] + text[1]);
        list = t.split();
        TranslationStringTest.assertEquals((String)text[0], (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)text[1], (String)list.get(1).toString());
        t = new TranslationString("aaa (Incubation)");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((String)"aaa ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"(Incubation)", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"Incubation", (String)list.get(1).trim());
        t = new TranslationString("aaa (label).");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((String)"aaa ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"(label).", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"label", (String)list.get(1).trim());
        TranslationStringTest.assertEquals((String)"(\u30e9\u30d9\u30eb)\u3002", (String)list.get(1).revert("\u30e9\u30d9\u30eb"));
        t = new TranslationString("aaa Inc. xxx.");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals(null, list);
        t = new TranslationString("IWAE0005E IWAJ0131I Cannot add:");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals(null, list);
        TranslationStringTest.assertEquals((String)"IWAE0005E IWAJ0131I Cannot add:", (String)t.toString());
        TranslationStringTest.assertEquals((String)"IWAJ0131I Cannot add:", (String)t.trim());
        t = new TranslationString("MyISAM uses special tree-like cache to make bulk inserts (that is, INSERT ... SELECT, INSERT ... VALUES (...), (...), ..., and LOAD DATA INFILE) faster. This variable limits the size of the cache tree in bytes per thread. Setting it to 0 will disable this optimisation. Note: this cache is only used when adding data to non-empty table. Default value is 8 MB.");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)6, (int)list.size());
        t = new TranslationString("\u3053\u308c\u306f a: b \u3067\u3059\u3002");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        t = new TranslationString("\u3053\u308c\u306f (a: b) \u3067\u3059\u3002");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals(null, list);
        t = new TranslationString("\u8868\u793a\u4e2d\u306e id: \u30a8\u30e9\u30fc\u3067\u3059\u3002");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        t = new TranslationString("No data source available for data set - {0}, please select a data source");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertTrue((list == null ? 1 : 0) != 0);
        t = new TranslationString("The non default location: {0} for {1} is in use.");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertTrue((list == null ? 1 : 0) != 0);
        t = new TranslationString("IWAE0036E URI Name: {0}; File name: {1}");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((String)"URI Name: ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"{0}; ", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"File name: ", (String)list.get(2).toString());
        TranslationStringTest.assertEquals((String)"{1}", (String)list.get(3).toString());
        t = new TranslationString("IWAE0036E URI \u540d: {0}\u3001\u30d5\u30a1\u30a4\u30eb\u540d: {1}");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"URI \u540d: {0}\u3001\u30d5\u30a1\u30a4\u30eb\u540d: ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"{1}", (String)list.get(1).toString());
        t = new TranslationString("''{0}'' \u3068\u3044\u3046\u540d\u524d\u306e\u578b\u306f ''{1}'' \u5185\u306b\u30a4\u30f3\u30dd\u30fc\u30c8 (\u5358\u4e00\u306e\u578b\u306e\u30a4\u30f3\u30dd\u30fc\u30c8) \u3055\u308c\u3066\u3044\u307e\u3059 (\u30b3\u30f3\u30d1\u30a4\u30eb\u5358\u4f4d\u306f\u540c\u3058\u540d\u524d\u3067\u578b\u3092\u30a4\u30f3\u30dd\u30fc\u30c8\u304a\u3088\u3073\u5ba3\u8a00\u3067\u304d\u307e\u305b\u3093)");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"''{0}'' \u3068\u3044\u3046\u540d\u524d\u306e\u578b\u306f ''{1}'' \u5185\u306b\u30a4\u30f3\u30dd\u30fc\u30c8 (\u5358\u4e00\u306e\u578b\u306e\u30a4\u30f3\u30dd\u30fc\u30c8) \u3055\u308c\u3066\u3044\u307e\u3059 ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"(\u30b3\u30f3\u30d1\u30a4\u30eb\u5358\u4f4d\u306f\u540c\u3058\u540d\u524d\u3067\u578b\u3092\u30a4\u30f3\u30dd\u30fc\u30c8\u304a\u3088\u3073\u5ba3\u8a00\u3067\u304d\u307e\u305b\u3093)", (String)list.get(1).toString());
        t = new TranslationString("Specify filters to control the resource copy process. (&lt;name&gt; is a file name pattern (only * wild-cards allowed) or the name of a folder which ends with '/')");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"Specify filters to control the resource copy process. ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"(&lt;name&gt; is a file name pattern (only * wild-cards allowed) or the name of a folder which ends with '/')", (String)list.get(1).toString());
        t = new TranslationString("JDT Core options control the behavior of core features such as the Java compiler, code formatter, code assist, and other core behaviors.&nbsp; The APIs for accessing the options are defined in <a href=\"../reference/api/org/eclipse/jdt/core/JavaCore.html\"><b>JavaCore</b></a>.&nbsp; Options can be accessed as a group as follows: ");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((String)"JDT Core options control the behavior of core features such as the Java compiler, code formatter, code assist, and other core behaviors.&nbsp; ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"The APIs for accessing the options are defined in <a href=\"../reference/api/org/eclipse/jdt/core/JavaCore.html\"><b>JavaCore</b></a>.&nbsp; ", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"Options can be accessed as a group as follows:", (String)list.get(2).toString());
        TranslationStringTest.assertEquals((String)"JDT Core options control the behavior of core features such as the Java compiler, code formatter, code assist, and other core behaviors.", (String)list.get(0).trim());
        TranslationStringTest.assertEquals((String)"The APIs for accessing the options are defined in <a href=\"../reference/api/org/eclipse/jdt/core/JavaCore.html\"><b>JavaCore</b></a>.", (String)list.get(1).trim());
        TranslationStringTest.assertEquals((String)"Options can be accessed as a group as follows:", (String)list.get(2).trim());
        t = new TranslationString("aaa productName; xxx");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"aaa productName; ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"xxx", (String)list.get(1).toString());
        t = new TranslationString("aaa &productName; xxx");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertTrue((list == null ? 1 : 0) != 0);
        TranslationStringTest.assertEquals((String)"aaa &productName; xxx", (String)t.toString());
        t = new TranslationString("JDT \u30b3\u30a2\u30fb\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u3001Java \u30b3\u30f3\u30d1\u30a4\u30e9\u30fc\u3001\u30b3\u30fc\u30c9\u30fb\u30d5\u30a9\u30fc\u30de\u30c3\u30bf\u30fc\u3001\u30b3\u30fc\u30c9\u30fb\u30a2\u30b7\u30b9\u30c8\u3001 \u304a\u3088\u3073\u305d\u306e\u4ed6\u306e\u30b3\u30a2\u306e\u632f\u308b\u821e\u3044\u306a\u3069\u3001\u30b3\u30a2\u30fb\u30d5\u30a3\u30fc\u30c1\u30e3\u30fc\u306e\u632f\u308b\u821e\u3044\u3092\u5236\u5fa1\u3057\u307e\u3059\u3002 \u30aa\u30d7\u30b7\u30e7\u30f3\u306b\u30a2\u30af\u30bb\u30b9\u3059\u308b\u305f\u3081\u306e API \u306f <a href=\"../reference/api/org/eclipse/jdt/core/JavaCore.html\"><b>JavaCore</b></a> \u3067\u5b9a\u7fa9\u3055\u308c\u307e\u3059\u3002 \u30aa\u30d7\u30b7\u30e7\u30f3\u306b\u306f\u3001\u4ee5\u4e0b\u306e\u30b0\u30eb\u30fc\u30d7\u3068\u3057\u3066\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u3059\u3002");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((String)"JDT \u30b3\u30a2\u30fb\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u3001Java \u30b3\u30f3\u30d1\u30a4\u30e9\u30fc\u3001\u30b3\u30fc\u30c9\u30fb\u30d5\u30a9\u30fc\u30de\u30c3\u30bf\u30fc\u3001\u30b3\u30fc\u30c9\u30fb\u30a2\u30b7\u30b9\u30c8\u3001 \u304a\u3088\u3073\u305d\u306e\u4ed6\u306e\u30b3\u30a2\u306e\u632f\u308b\u821e\u3044\u306a\u3069\u3001\u30b3\u30a2\u30fb\u30d5\u30a3\u30fc\u30c1\u30e3\u30fc\u306e\u632f\u308b\u821e\u3044\u3092\u5236\u5fa1\u3057\u307e\u3059\u3002 ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"\u30aa\u30d7\u30b7\u30e7\u30f3\u306b\u30a2\u30af\u30bb\u30b9\u3059\u308b\u305f\u3081\u306e API \u306f <a href=\"../reference/api/org/eclipse/jdt/core/JavaCore.html\"><b>JavaCore</b></a> \u3067\u5b9a\u7fa9\u3055\u308c\u307e\u3059\u3002 ", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"\u30aa\u30d7\u30b7\u30e7\u30f3\u306b\u306f\u3001\u4ee5\u4e0b\u306e\u30b0\u30eb\u30fc\u30d7\u3068\u3057\u3066\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u3059\u3002", (String)list.get(2).toString());
        t = new TranslationString("\u30d0\u30f3\u30c9\u30eb\u306e\u30b7\u30f3\u30dc\u30eb\u540d\u306b\u6b63\u3057\u304f\u306a\u3044\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002 \u6b63\u3057\u3044\u6587\u5b57\u306f A-Z a-z 0-9 . _ - \u3067\u3059");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"\u30d0\u30f3\u30c9\u30eb\u306e\u30b7\u30f3\u30dc\u30eb\u540d\u306b\u6b63\u3057\u304f\u306a\u3044\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002 ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"\u6b63\u3057\u3044\u6587\u5b57\u306f A-Z a-z 0-9 . _ - \u3067\u3059", (String)list.get(1).toString());
        t = new TranslationString("Bundle symbolic name contains illegal characters. Legal characters are A-Z a-z 0-9 . _ -");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"Bundle symbolic name contains illegal characters. ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"Legal characters are A-Z a-z 0-9 . _ -", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"Legal characters are A-Z a-z 0-9 . _ -", (String)list.get(1).trim());
        t = new TranslationString("Agent Controller \u5229\u7528\u4e0d\u53ef - Agent Controller \u304c\u5b9f\u884c\u4e2d\u3067\u63a5\u7d9a\u53d7\u3051\u5165\u308c\u72b6\u614b\u3067\u3042\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"Agent Controller \u5229\u7528\u4e0d\u53ef - ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"Agent Controller \u5229\u7528\u4e0d\u53ef", (String)list.get(0).trim());
        TranslationStringTest.assertEquals((String)"Agent Controller \u304c\u5b9f\u884c\u4e2d\u3067\u63a5\u7d9a\u53d7\u3051\u5165\u308c\u72b6\u614b\u3067\u3042\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044", (String)list.get(1).toString());
        t = new TranslationString("Agent Controller Unavailable - Please ensure the Agent Controller is running and accepting connections");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"Agent Controller Unavailable - ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"Agent Controller Unavailable", (String)list.get(0).trim());
        TranslationStringTest.assertEquals((String)"Please ensure the Agent Controller is running and accepting connections", (String)list.get(1).toString());
        t = new TranslationString("Use default SDK (App Engine - 1.2.0)");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)3, (int)list.size());
        TranslationStringTest.assertEquals((String)"Use default SDK ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"(App Engine - ", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"App Engine", (String)list.get(1).trim());
        TranslationStringTest.assertEquals((String)"1.2.0)", (String)list.get(2).toString());
        TranslationStringTest.assertEquals((String)"1.2.0", (String)list.get(2).trim());
        t = new TranslationString("    ... more   ");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertTrue((list == null ? 1 : 0) != 0);
        TranslationStringTest.assertEquals((String)"... more", (String)t.trim());
        TranslationStringTest.assertEquals((String)"more", (String)t.trimForce());
        t = new TranslationString("<html>Do not have an account at github.com? <a href=\"https://github.com\">Sign up</a></html>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"Do not have an account at github.com? ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"Do not have an account at github.com?", (String)list.get(0).trim());
        TranslationStringTest.assertEquals((String)"<a href=\"https://github.com\">Sign up</a>", (String)list.get(1).toString());
        t = new TranslationString("<html><body><p style=\"margin-top:5px;\">Subscription is active until November 30, 2017.</p><p>For non-commercial open source development only</p></body></html>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"Subscription is active until November 30, 2017.</p>", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"Subscription is active until November 30, 2017.", (String)list.get(0).trim());
        TranslationStringTest.assertEquals((String)"Subscription is active until November 30, 2017", (String)list.get(0).trimForce());
        TranslationStringTest.assertEquals((String)"<p>For non-commercial open source development only", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"For non-commercial open source development only", (String)list.get(1).trim());
        t = new TranslationString("<html><head><style>\nbody, div, td, p {font-family:'Lucida Grande'; font-size:13pt;} a {font-family:'Lucida Grande'; font-size:13pt;} code {font-size:13pt;} </style><style>body {background: #3c3f41;}</style></head><body><html>A new <a href='https://sites.google.com/a/android.com/tools/recent'>Android Studio</a> 2.3 Beta 1 is available in the beta channel.<p/> 2.3 Beta 1 includes new functionality, bug fixes, and performance improvements.<br/><br/>We recommend updating to this version.<br/><br/>Please continue to file feedback (Help > Submit Feedback) if you see issues in this release.<br/><br/> </html></body></html>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((String)"A new <a href='https://sites.google.com/a/android.com/tools/recent'>Android Studio</a> 2.3 Beta 1 is available in the beta channel.<p/>2.3 Beta 1 includes new functionality, bug fixes, and performance improvements.<br/><br/>We recommend updating to this version.<br/><br/>Please continue to file feedback (Help > Submit Feedback) if you see issues in this release.", (String)t.trim());
        TranslationStringTest.assertEquals((int)4, (int)list.size());
        TranslationStringTest.assertEquals((String)"A new <a href='https://sites.google.com/a/android.com/tools/recent'>Android Studio</a> 2.3 Beta 1 is available in the beta channel.<p/>", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"2.3 Beta 1 includes new functionality, bug fixes, and performance improvements.<br/><br/>", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"We recommend updating to this version.<br/><br/>", (String)list.get(2).toString());
        TranslationStringTest.assertEquals((String)"Please continue to file feedback (Help > Submit Feedback) if you see issues in this release.", (String)list.get(3).toString());
        t = new TranslationString("<html>Updates are available for the Android SDK and Tools<br><br>Android SDK updates ensure you have the latest features and enhancements.<br>Android Studio will update the following components:</html>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)3, (int)list.size());
        TranslationStringTest.assertEquals((String)"Updates are available for the Android SDK and Tools<br><br>", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"Updates are available for the Android SDK and Tools", (String)list.get(0).trim());
        TranslationStringTest.assertEquals((String)"Android SDK updates ensure you have the latest features and enhancements.<br>", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"Android SDK updates ensure you have the latest features and enhancements.", (String)list.get(1).trim());
        TranslationStringTest.assertEquals((String)"Android SDK updates ensure you have the latest features and enhancements", (String)list.get(1).trimForce());
        TranslationStringTest.assertEquals((String)"Android Studio will update the following components:", (String)list.get(2).trim());
        TranslationStringTest.assertEquals((String)"Android Studio will update the following components", (String)list.get(2).trimForce());
        t = new TranslationString("<b>Unindexed remote maven repositories found.</b> <a href=\"#disable\">Disable...</a>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"<b>Unindexed remote maven repositories found.</b> ", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"Unindexed remote maven repositories found.", (String)list.get(0).trim());
        TranslationStringTest.assertEquals((String)"<a href=\"#disable\">Disable...</a>", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"Disable...", (String)list.get(1).trim());
        t = new TranslationString("<html><b>Android NDK location:</b><br> The directory where the Android NDK is located. This location will be saved as ndk.dir property in the local.properties file.</html>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)3, (int)list.size());
        TranslationStringTest.assertEquals((String)"<b>Android NDK location:</b><br>", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"The directory where the Android NDK is located. ", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"This location will be saved as ndk.dir property in the local.properties file.", (String)list.get(2).toString());
        t = new TranslationString("<html>\n<head>\n    <link rel=\"stylesheet\" type=\"text/css\" href=\"css/tips.css\">\n</head>\n<body>\n\n\n<p>To select multiple words, press <span class=\"shortcut\">Alt+Shift</span>, place\n    the caret at each word to be selected and double-click the left mouse button.</p>\n<p class=\"image\"><img src=\"images/multiselection_words.png\"></p>\n</body>\n</html>");
        list = t.split();
        TranslationStringTest.assertTrue((list == null ? 1 : 0) != 0);
        TranslationStringTest.assertEquals((String)"To select multiple words, press <span class=\"shortcut\">Alt+Shift</span>, place the caret at each word to be selected and double-click the left mouse button.", (String)t.trim());
        TranslationStringTest.assertEquals((String)"To select multiple words, press <span class=\"shortcut\">Alt+Shift</span>, place the caret at each word to be selected and double-click the left mouse button", (String)t.trimForce());
        t = new TranslationString("<html>\n<head>\n    <link rel=\"stylesheet\" type=\"text/css\" href=\"css/tips.css\">\n</head>\n<body>\n\n<p>All your most indispensable VCS commands are just one-click away...</p>\n<p>\nChoose <span class=\"control\">VCS | VCS Operations Popup</span>\non the main menu, and get a popup with the VCS commands that are relevant to the current context:\n</p>\n\n<p class=\"image\"><img width=\"322\" height=\"302\" src=\"images/vcsQuickList.png\"></p>\n\n</body>\n</html>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"All your most indispensable VCS commands are just one-click away...", (String)list.get(0).trim());
        TranslationStringTest.assertEquals((String)"Choose <span class=\"control\">VCS | VCS Operations Popup</span> on the main menu, and get a popup with the VCS commands that are relevant to the current context:", (String)list.get(1).trim());
        t = new TranslationString("<html>\n<head>\n    <link rel=\"stylesheet\" type=\"text/css\" href=\"css/tips.css\">\n</head>\n<body>\n    <p>\n        There are two ways of closing all tabs in the editor, except the current one:</p>\n<ul>\n<li>First, right-click the editor tab, and choose <span class=\"control\">Close Others</span> on the context menu.</li>\n<li>Second, keeping the Alt key pressed, click <img src=\"images/close1.png\"/> on the editor tab.</li>\n</ul>   \n    <p class=\"image\">\n        <img src=\"images/close_others.png\"></p>\n</body>\n</html>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)3, (int)list.size());
        TranslationStringTest.assertEquals((String)"There are two ways of closing all tabs in the editor, except the current one:", (String)list.get(0).trim());
        TranslationStringTest.assertEquals((String)"First, right-click the editor tab, and choose <span class=\"control\">Close Others</span> on the context menu.", (String)list.get(1).trim());
        TranslationStringTest.assertEquals((String)"Second, keeping the Alt key pressed, click <img src=\"images/close1.png\"/> on the editor tab.", (String)list.get(2).trim());
        t = new TranslationString("<html>\n<head>\n    <link rel=\"stylesheet\" type=\"text/css\" href=\"css/tips.css\">\n</head>\n<body>\n    <h1>\n        Welcome to <span class=\"product\">productName;</span> <span class=\"version\">&majorVersion;.&minorVersion;</span></h1>\n    <p>\n        You can quickly get familiar with the main features of the IDE by reading these tips. You may try out\n        the features described in the tips while this dialog stays open on the screen. If you close the dialog,\n        you can always get back to it from the <span class=\"control\">Help | Tip of the Day</span>\n        main menu item.</p>\n</body>\n</html>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)4, (int)list.size());
        TranslationStringTest.assertEquals((String)"Welcome to <span class=\"product\">productName;</span> <span class=\"version\">&majorVersion;.&minorVersion;</span>", (String)list.get(0).trim());
        t = new TranslationString("<html><head><style> body, div, td, p {font-family:'.SF NS Text'; font-size:13pt; color:#bbbbbb;} a {font-family:'.SF NS Text'; font-size:13pt; color:#589df6;} code {font-size:13pt;} ul {list-style-image:url('jar:file:/Applications/IntelliJ%20IDEA.app/Contents/lib/icons.jar!/general/mdot-white.png');} </style></head><body>\u30e1\u30bd\u30c3\u30c9\u3092 java.lang.Object \u306b\u30aa\u30fc\u30d0\u30fc\u30e9\u30a4\u30c9\u3057\u307e\u3059<br><div style='margin-top: 5px'><font size='2'>Click or press \u2318U to navigate</font></div></body></html>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"\u30e1\u30bd\u30c3\u30c9\u3092 java.lang.Object \u306b\u30aa\u30fc\u30d0\u30fc\u30e9\u30a4\u30c9\u3057\u307e\u3059<br>", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"\u30e1\u30bd\u30c3\u30c9\u3092 java.lang.Object \u306b\u30aa\u30fc\u30d0\u30fc\u30e9\u30a4\u30c9\u3057\u307e\u3059", (String)list.get(0).trim());
        TranslationStringTest.assertEquals((String)"<div style='margin-top: 5px'><font size='2'>Click or press \u2318U to navigate</font>", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"Click or press \u2318U to navigate", (String)list.get(1).trim());
        t = new TranslationString("<html><table><tr><td>col11</td><td><a href=\"x\">col12</a></td></tr><tr><td>col2</td></tr></table></html>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)3, (int)list.size());
        TranslationStringTest.assertEquals((String)"col11", (String)list.get(0).trim());
        TranslationStringTest.assertEquals((String)"col12", (String)list.get(1).trim());
        TranslationStringTest.assertEquals((String)"col2", (String)list.get(2).trim());
        t = new TranslationString("Parameters//Type parameter");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"Parameters//", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"Parameters", (String)list.get(0).trim());
        TranslationStringTest.assertEquals((String)"Type parameter", (String)list.get(1).toString());
        t = new TranslationString("'http://www.sample-url.org/doc/' or 'file:///c\\:/xxx/doc'");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertNull(list);
        t = new TranslationString("Wrap with <br>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertNull(list);
        TranslationStringTest.assertEquals((String)"Wrap with <br>", (String)t.trim());
        t = new TranslationString("Wrap with <p>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertNull(list);
        TranslationStringTest.assertEquals((String)"Wrap with <p>", (String)t.trim());
        t = new TranslationString("<p> \u30d6\u30ed\u30c3\u30af\u3067\u30c6\u30ad\u30b9\u30c8\u3092\u6298\u308a\u8fd4\u3057");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertNull(list);
        TranslationStringTest.assertEquals((String)"<p> \u30d6\u30ed\u30c3\u30af\u3067\u30c6\u30ad\u30b9\u30c8\u3092\u6298\u308a\u8fd4\u3057", (String)t.trim());
        t = new TranslationString("Discard empty <p> elements");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertNull(list);
        TranslationStringTest.assertEquals((String)"Discard empty <p> elements", (String)t.trim());
        t = new TranslationString("<{0}> unmatched in documentation");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertNull(list);
        TranslationStringTest.assertEquals((String)"<{0}> unmatched in documentation", (String)t.trim());
        t = new TranslationString("<a href='FindOptions'>Find Options...</a>&nbsp;(\u2325\u21e7\u2318F7)");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"<a href='FindOptions'>Find Options...</a>&nbsp;", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"Find Options...", (String)list.get(0).trim());
        t = new TranslationString("&productName; aaa. bbb.");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        t = new TranslationString("<html>\n<body>\nThis inspection reports all fields, methods or classes, found in the specified inspection\nscope, that may have a <b><font color=\"#000080\">final</font></b> modifier added to their declarations. <br> <br>\n<!-- tooltip end -->\nUse check boxes in the inspection options below, to define which declarations are to be reported.\n</body>\n</html>\n");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
        TranslationStringTest.assertEquals((String)"This inspection reports all fields, methods or classes, found in the specified inspection scope, that may have a <b><font color=\"#000080\">final</font></b> modifier added to their declarations.<br><br><!-- tooltip end -->", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"This inspection reports all fields, methods or classes, found in the specified inspection scope, that may have a <b><font color=\"#000080\">final</font></b> modifier added to their declarations.", (String)list.get(0).trim());
        TranslationStringTest.assertEquals((String)"Use check boxes in the inspection options below, to define which declarations are to be reported.", (String)list.get(1).toString());
        t = new TranslationString("<table width=\"100%\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" style=\"border-collapse: collapse\">  <tr>    <td><font face=\"verdana\" size=\"-1\">Along with static text, code and comments, you can also use      predefined variables (listed below) that will then be expanded like macros into the corresponding values.<br>      It is also possible to specify an arbitrary number of custom variables in the format      <b>${&lt;VARIABLE_NAME&gt;}</b>. In this case, before the new      file is created, you will be prompted with a dialog where you can define particular values for all      custom variables.<br>      Using the <b>#parse</b> directive, you can include templates from the <i>Includes</i>      tab, by specifying the full name of the desired template as a parameter in quotation marks.      For example:<br>      <b>#parse(\"File Header.java\")</b>    </font></td>  </tr></table><table width=\"100%\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" style=\"border-collapse: collapse\">  <tr>    <td colspan=\"3\"><font face=\"verdana\" size=\"-1\">Predefined variables will take the following values:</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${PACKAGE_NAME}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">name of the package in which the new file is created</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${NAME}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">name of the new file specified by you in the <i>New &lt;TEMPLATE_NAME&gt;</i> dialog</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${USER}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">current user system login name</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${DATE}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">current system date</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${TIME}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">current system time</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${YEAR}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">current year</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${MONTH}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">current month</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${MONTH_NAME_SHORT}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">first 3 letters of the current month name. Example: Jan, Feb, etc.</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${MONTH_NAME_FULL}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">full name of the current month. Example: January, February, etc.</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${DAY}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">current day of the month</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${DAY_NAME_SHORT}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">first 3 letters of the current day name. Example: Mon, Tue, etc.</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${DAY_NAME_FULL}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">full name of the current day. Example: Monday, Tuesday, etc.</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${HOUR}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">current hour</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${MINUTE}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">current minute</font></td>  </tr>  <tr>    <td valign=\"top\"><nobr><font face=\"verdana\" size=\"-2\"><b>${PROJECT_NAME}</b></font></nobr></td>    <td width=\"10\">&nbsp;</td>    <td width=\"100%\" valign=\"top\"><font face=\"verdana\" size=\"-1\">the name of the current project</font></td>  </tr></table><hr> <font face=\"verdana\" size=\"-1\"><a href='http://velocity.apache.org/engine/devel/user-guide.html#Velocity_Template_Language_VTL:_An_Introduction'>\nApache Velocity</a> template language is used</font>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((String)"For example:<br>", (String)list.get(4).toString());
        TranslationStringTest.assertEquals((String)"For example:", (String)list.get(4).trim());
        TranslationStringTest.assertEquals((String)"For example", (String)list.get(4).trimForce());
        TranslationStringTest.assertEquals((String)"Predefined variables will take the following values:", (String)list.get(6).trim());
        TranslationStringTest.assertEquals((String)"<a href='http://velocity.apache.org/engine/devel/user-guide.html#Velocity_Template_Language_VTL:_An_Introduction'> Apache Velocity</a> template language is used", (String)list.get(list.size() - 1).trim());
        t = new TranslationString("<html>\nNo in-line parameter name hints will be shown for methods matching any of these patterns.<br>\nPatterns are matched on fully qualified method name, parameter count and parameter names.\n<ul>\n<li><code>java.lang</code> matches all methods from <em>java.lang</em> package</li>\n<li><code>java.lang.*(*, *)</code> matches all methods from the <em>java.lang</em> package with two parameters</li>\n<li><code>(*info)</code> matches all single parameter methods where the parameter name ends with <em>info</em></li>\n<li><code>(key, value)</code> matches all methods with parameters <em>key</em> and <em>value</em></li>\n<li><code>*.put(key, value)</code> matches all <em>put</em> methods with <em>key</em> and <em>value</em> parameters\n</ul>\n</html>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)7, (int)list.size());
        t = new TranslationString("<html>Semantic highlighting<br><font color=gray><sub>Assign each parameter and local variable its<br>own color picked from spectrum below</sub></font></html>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((String)"Semantic highlighting<br>", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"Semantic highlighting", (String)list.get(0).trim());
        TranslationStringTest.assertEquals((String)"<font color=gray><sub>Assign each parameter and local variable its<br>own color picked from spectrum below</sub></font>", (String)list.get(1).toString());
        TranslationStringTest.assertEquals((String)"Assign each parameter and local variable its<br>own color picked from spectrum below", (String)list.get(1).trim());
        t = new TranslationString("<html><style></style><div>aaa<div x>bbb<div>ccc</div></html>");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)3, (int)list.size());
        TranslationStringTest.assertEquals((String)"aaa", (String)list.get(0).toString());
        TranslationStringTest.assertEquals((String)"bbb", (String)list.get(1).trim());
        TranslationStringTest.assertEquals((String)"ccc", (String)list.get(2).trim());
        t = new TranslationString("Installation failed with message {0}.\nIt is possible that this issue is resolved by uninstalling an existing version of the apk if it is present, and then re-installing.\n\nWARNING: Uninstalling will remove the application data!\n\nDo you want to uninstall the existing application?");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertEquals((int)5, (int)list.size());
        t = new TranslationString("aaa<br>bbb");
        list = t.split();
        this.printEach(list);
        TranslationStringTest.assertNull(list);
        t = new TranslationString("aaa<br>bbb");
        list = t.split("<BR/?>");
        this.printEach(list);
        TranslationStringTest.assertEquals((int)2, (int)list.size());
    }
}

