/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.org.apache.commons.io.IOUtils;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.PatternCache;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationString;

public class TranslationNotFoundProperties {
    private static final Logger log = Logger.getLogger(TranslationNotFoundProperties.class);
    private static final File NOT_FOUND_LOG_FILE_NAME = Pleiades.getResourceFile("translation-notfound.properties");
    private static final File EXCLUDE_LIST_FILE = Files.conf("translation-notfound-exclud.list");
    private static TranslationNotFoundProperties notFoundLog;
    private Set<String> excludSet;
    private Set<Pattern> excludPatternSet;
    private Set<String> loggedSet;
    private PrintStream out;

    static {
        if (Pleiades.getPleiadesOption().enabledNotFoundLog) {
            notFoundLog = new TranslationNotFoundProperties();
            notFoundLog.init();
        } else {
            notFoundLog = new TranslationNotFoundProperties(){

                @Override
                public void put(TranslationString enTs) {
                }
            };
        }
    }

    private TranslationNotFoundProperties() {
    }

    public static TranslationNotFoundProperties getInstance() {
        return notFoundLog;
    }

    private void init() {
        this.excludSet = new HashSet<String>();
        this.excludPatternSet = new HashSet<Pattern>();
        this.loggedSet = Collections.synchronizedSet(new HashSet());
        BufferedReader in = null;
        try {
            try {
                String line;
                in = new BufferedReader(new FileReader(EXCLUDE_LIST_FILE));
                while ((line = in.readLine()) != null) {
                    String prefix;
                    if (line.startsWith("#")) continue;
                    String str = line.replaceAll("\\\\n", "\n");
                    if (str.startsWith(prefix = "%REGEX%")) {
                        Pattern pattern = PatternCache.get(str.replaceFirst(prefix, ""));
                        this.excludPatternSet.add(pattern);
                        continue;
                    }
                    this.excludSet.add(str);
                }
            }
            catch (IOException e) {
                String msg = "\u8a33\u7121\u3057\u30ed\u30b0\u51fa\u529b\u9664\u5916\u30ea\u30b9\u30c8\u3092\u30ed\u30fc\u30c9\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
                log.fatal(msg, new Object[0]);
                throw new IllegalStateException(msg, e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        try {
            this.out = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(NOT_FOUND_LOG_FILE_NAME)), true, "UTF-8");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    PrintStream out = TranslationNotFoundProperties.getInstance().out;
                    IOUtils.closeQuietly(out);
                }
            });
        }
        catch (IOException e) {
            log.fatal(e, "\u8a33\u7121\u3057\u30ed\u30b0\u30e9\u30a4\u30bf\u30fc\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", new Object[0]);
        }
    }

    public void put(TranslationString enTs) {
        enTs.init();
        this.println(enTs.toString().trim());
        this.println(enTs.trim());
        this.println(enTs.trimForce());
    }

    protected void println(String en) {
        if (this.loggedSet.contains(en)) {
            return;
        }
        if (this.excludSet.contains(en)) {
            return;
        }
        for (Pattern pattern : this.excludPatternSet) {
            if (!pattern.matcher(en).matches()) continue;
            return;
        }
        this.loggedSet.add(en);
        String key = Property.escapeKey(en);
        String value = Property.escapeValue(en);
        value = value.replace("\\r", " ");
        value = value.replace("\\n", " ");
        if (key.matches("(?s).*\\p{Alpha}{2}.*")) {
            this.out.println(String.valueOf(key) + "=" + value);
        }
    }

    /* synthetic */ TranslationNotFoundProperties(TranslationNotFoundProperties translationNotFoundProperties) {
        this();
    }
}

